/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import ic2.core.init.InternalName;
import ic2.core.item.ItemIC2FluidContainer;
import ic2.core.util.LiquidUtil;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class ItemFluidCell
extends ItemIC2FluidContainer {
    public ItemFluidCell(InternalName internalName) {
        super(internalName, 1000);
    }

    @Override
    public String getTextureFolder() {
        return "cell";
    }

    @Override
    public String getTextureName(int index) {
        switch (index) {
            case 0: {
                return this.func_77658_a().substring(4);
            }
            case 1: {
                return this.func_77658_a().substring(4) + ".window";
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    IIcon getWindowIcon() {
        return this.textures[1];
    }

    public boolean isRepairable() {
        return false;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        if (this.interactWithTank(stack, player, world, x, y, z, side)) {
            return true;
        }
        MovingObjectPosition position = this.func_77621_a(world, player, true);
        if (position == null) {
            return false;
        }
        if (position.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            x = position.field_72311_b;
            y = position.field_72312_c;
            z = position.field_72309_d;
            if (!world.func_72962_a(player, x, y, z)) {
                return false;
            }
            if (!player.func_82247_a(x, y, z, position.field_72310_e, stack)) {
                return false;
            }
            if (this.collectFluidBlock(stack, player, world, x, y, z)) {
                return true;
            }
            FluidStack fs = LiquidUtil.drainContainerStack(stack, player, 1000, true);
            ForgeDirection dir = ForgeDirection.VALID_DIRECTIONS[position.field_72310_e];
            if (LiquidUtil.placeFluid(fs, world, x, y, z) || player.func_82247_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, position.field_72310_e, stack) && LiquidUtil.placeFluid(fs, world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    LiquidUtil.drainContainerStack(stack, player, 1000, false);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List itemList) {
        itemList.add(Ic2Items.FluidCell.func_77946_l());
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid == null) continue;
            ItemStack stack = Ic2Items.FluidCell.func_77946_l();
            this.fill(stack, new FluidStack(fluid, Integer.MAX_VALUE), true);
            itemList.add(stack);
        }
    }

    private boolean interactWithTank(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof IFluidHandler)) {
            return false;
        }
        IFluidHandler handler = (IFluidHandler)te;
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        FluidStack fs = this.getFluid(stack);
        if (fs == null || player.func_70093_af() && fs.amount < this.capacity) {
            int amount = fs == null ? this.capacity : this.capacity - fs.amount;
            FluidStack input = handler.drain(dir, amount, false);
            if (input == null || input.amount <= 0) {
                return true;
            }
            amount = LiquidUtil.fillContainerStack(stack, player, input, false);
            if (amount <= 0) {
                return true;
            }
            handler.drain(dir, amount, true);
            return true;
        }
        int amount = handler.fill(dir, fs, false);
        if (amount <= 0) {
            return true;
        }
        fs = LiquidUtil.drainContainerStack(stack, player, amount, false);
        if (fs == null || fs.amount <= 0) {
            return true;
        }
        handler.fill(dir, fs, true);
        return true;
    }

    private boolean collectFluidBlock(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block instanceof IFluidBlock) {
            FluidStack fluid;
            int amount;
            IFluidBlock liquid = (IFluidBlock)block;
            if (liquid.canDrain(world, x, y, z) && (amount = LiquidUtil.fillContainerStack(stack, player, fluid = liquid.drain(world, x, y, z, false), true)) == fluid.amount) {
                LiquidUtil.fillContainerStack(stack, player, fluid, false);
                liquid.drain(world, x, y, z, true);
                return true;
            }
        } else if (world.func_72805_g(x, y, z) == 0) {
            int amount;
            FluidStack fluid = null;
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                fluid = new FluidStack(FluidRegistry.WATER, 1000);
            } else if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
                fluid = new FluidStack(FluidRegistry.LAVA, 1000);
            }
            if (fluid != null && (amount = LiquidUtil.fillContainerStack(stack, player, fluid, true)) == fluid.amount) {
                LiquidUtil.fillContainerStack(stack, player, fluid, false);
                world.func_147468_f(x, y, z);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getUniversalFluidCell(FluidStack fluidStack) {
        ItemStack stack = Ic2Items.FluidCell.func_77946_l();
        ((ItemFluidCell)Ic2Items.FluidCell.func_77973_b()).fill(stack, new FluidStack(fluidStack.getFluid(), fluidStack.amount), true);
        return stack;
    }
}

