/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.invslot;

import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.item.DamageHandler;
import ic2.core.util.StackUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class InvSlotConsumable
extends InvSlot {
    public InvSlotConsumable(TileEntityInventory base1, String name1, int oldStartIndex1, int count) {
        super(base1, name1, oldStartIndex1, InvSlot.Access.I, count, InvSlot.InvSide.TOP);
    }

    public InvSlotConsumable(TileEntityInventory base1, String name1, int oldStartIndex1, InvSlot.Access access1, int count, InvSlot.InvSide preferredSide1) {
        super(base1, name1, oldStartIndex1, access1, count, preferredSide1);
    }

    @Override
    public abstract boolean accepts(ItemStack var1);

    @Override
    public boolean canOutput() {
        return super.canOutput() || this.access != InvSlot.Access.NONE && this.get() != null && !this.accepts(this.get());
    }

    public ItemStack consume(int amount) {
        return this.consume(amount, false, false);
    }

    public ItemStack consume(int amount, boolean simulate, boolean consumeContainers) {
        ItemStack ret = null;
        for (int i = 0; i < this.size(); ++i) {
            ItemStack stack = this.get(i);
            if (stack == null || stack.field_77994_a < 1 || !this.accepts(stack) || ret != null && !StackUtil.isStackEqualStrict(stack, ret) || stack.field_77994_a != 1 && !consumeContainers && stack.func_77973_b().hasContainerItem(stack)) continue;
            int currentAmount = Math.min(amount, stack.field_77994_a);
            amount -= currentAmount;
            if (!simulate) {
                if (stack.field_77994_a == currentAmount) {
                    if (!consumeContainers && stack.func_77973_b().hasContainerItem(stack)) {
                        this.put(i, stack.func_77973_b().getContainerItem(stack));
                    } else {
                        this.put(i, null);
                    }
                } else {
                    stack.field_77994_a -= currentAmount;
                }
            }
            if (ret == null) {
                ret = StackUtil.copyWithSize(stack, currentAmount);
            } else {
                ret.field_77994_a += currentAmount;
            }
            if (amount == 0) break;
        }
        return ret;
    }

    public ItemStack damage(int amount, boolean simulate) {
        return this.damage(amount, simulate, null);
    }

    public ItemStack damage(int amount, boolean simulate, EntityLivingBase src) {
        ItemStack ret = null;
        int damageApplied = 0;
        for (int i = 0; i < this.size() && amount > 0; ++i) {
            ItemStack stack = this.get(i);
            Item item = stack.func_77973_b();
            if (stack == null || !this.accepts(stack) || !item.func_77645_m() || ret != null && (stack.func_77973_b() != ret.func_77973_b() || !ItemStack.func_77970_a((ItemStack)stack, ret))) continue;
            if (simulate) {
                stack = stack.func_77946_l();
            }
            int maxDamage = DamageHandler.getMaxDamage(stack);
            while (amount > 0 && stack.field_77994_a > 0) {
                int currentAmount = Math.min(amount, maxDamage - DamageHandler.getDamage(stack));
                DamageHandler.damage(stack, currentAmount, src);
                damageApplied += currentAmount;
                amount -= currentAmount;
                if (DamageHandler.getDamage(stack) >= maxDamage) {
                    --stack.field_77994_a;
                    DamageHandler.setDamage(stack, 0);
                }
                if (ret != null) continue;
                ret = stack.func_77946_l();
            }
            if (stack.field_77994_a != 0 || simulate) continue;
            this.put(i, null);
        }
        if (ret != null) {
            int max = DamageHandler.getMaxDamage(ret);
            ret.field_77994_a = damageApplied / max;
            DamageHandler.setDamage(ret, damageApplied % max);
        }
        return ret;
    }
}

