/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.block.generator.container.ContainerSolarGenerator;
import ic2.core.block.generator.gui.GuiSolarGenerator;
import ic2.core.block.generator.tileentity.TileEntityBaseGenerator;
import ic2.core.init.MainConfig;
import ic2.core.util.ConfigUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenDesert;

public class TileEntitySolarGenerator
extends TileEntityBaseGenerator {
    public final Double solarbasevalue;
    public int ticker = IC2.random.nextInt(this.tickRate());
    public boolean sunIsVisible = false;

    public TileEntitySolarGenerator() {
        super(1, 1, 2);
        this.solarbasevalue = ConfigUtil.getDouble(MainConfig.get(), "balance/energy/generator/solar");
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.updateSunVisibility();
    }

    @Override
    public int gaugeFuelScaled(int i) {
        return i;
    }

    @Override
    public boolean gainEnergy() {
        if (this.ticker++ % this.tickRate() == 0) {
            this.updateSunVisibility();
        }
        if (this.sunIsVisible) {
            this.storage += this.solarbasevalue * (double)((float)TileEntitySolarGenerator.getskylight(this.field_145850_b, this.field_145851_c, this.field_145849_e) / 15.0f);
            return true;
        }
        return false;
    }

    @Override
    public boolean gainFuel() {
        return false;
    }

    private static int getskylight(World world, int x, int z) {
        return world.func_72957_l(x, 255, z);
    }

    public void updateSunVisibility() {
        this.sunIsVisible = TileEntitySolarGenerator.isSunVisible(this.field_145850_b, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
    }

    public static boolean isSunVisible(World world, int x, int y, int z) {
        return TileEntitySolarGenerator.getskylight(world, x, z) > 4 && !world.field_73011_w.field_76576_e && world.func_72937_j(x, y, z) && (world.func_72959_q().func_76935_a(x, z) instanceof BiomeGenDesert || !world.func_72896_J() && !world.func_72911_I());
    }

    @Override
    public boolean needsFuel() {
        return true;
    }

    @Override
    public String func_145825_b() {
        return "Solar Panel";
    }

    public ContainerBase<TileEntitySolarGenerator> getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerSolarGenerator(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiSolarGenerator(new ContainerSolarGenerator(entityPlayer, this));
    }

    public int tickRate() {
        return 128;
    }

    @Override
    public boolean delayActiveUpdate() {
        return true;
    }
}

