/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.compat;

import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import net.dries007.holoInventory.compat.InventoryDecoder;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class InventoryDecoderRegistry {
    private static final Map<Class<? extends IInventory>, InventoryDecoder> CACHE_MAP = new HashMap<Class<? extends IInventory>, InventoryDecoder>();
    private static final List<InventoryDecoder> REGISTERED_INVENTORY_DECODERS = new ArrayList<InventoryDecoder>();
    private static final InventoryDecoder DEFAULT = new InventoryDecoder((Class)IInventory.class){

        @Override
        public NBTTagList toNBT(IInventory inv) {
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null) continue;
                NBTTagCompound tag = stack.func_77955_b(new NBTTagCompound());
                tag.func_74768_a("Count", stack.field_77994_a);
                list.func_74742_a((NBTBase)tag);
            }
            return list;
        }
    };

    private InventoryDecoderRegistry() {
    }

    public static void init() {
        if (Loader.isModLoaded((String)"StorageDrawers")) {
            REGISTERED_INVENTORY_DECODERS.add(new InventoryDecoder((Class)IDrawerGroup.class){

                @Override
                public NBTTagList toNBT(IInventory inv) {
                    IDrawerGroup drawerGroup = (IDrawerGroup)inv;
                    NBTTagList list = new NBTTagList();
                    for (int i = 0; i < drawerGroup.getDrawerCount(); ++i) {
                        ItemStack stack = drawerGroup.getDrawer(i).getStoredItemCopy();
                        if (stack == null) continue;
                        NBTTagCompound tag = stack.func_77955_b(new NBTTagCompound());
                        tag.func_74768_a("Count", stack.field_77994_a);
                        list.func_74742_a((NBTBase)tag);
                    }
                    return list;
                }
            });
        }
        if (Loader.isModLoaded((String)"JABBA")) {
            REGISTERED_INVENTORY_DECODERS.add(new InventoryDecoder((Class)TileEntityBarrel.class){

                @Override
                public NBTTagList toNBT(IInventory inv) {
                    NBTTagList list = new NBTTagList();
                    ItemStack stack = inv.func_70301_a(1);
                    if (stack != null) {
                        NBTTagCompound tag = stack.func_77955_b(new NBTTagCompound());
                        int item_amount = ((TileEntityBarrel)inv).getStorage().getAmount();
                        tag.func_74768_a("Count", item_amount);
                        list.func_74742_a((NBTBase)tag);
                    }
                    return list;
                }
            });
        }
    }

    public static NBTTagList toNBT(IInventory inv) {
        Class<?> teClass = inv.getClass();
        InventoryDecoder decoder = CACHE_MAP.get(teClass);
        if (decoder == null) {
            for (InventoryDecoder possibleDecoder : REGISTERED_INVENTORY_DECODERS) {
                if (!possibleDecoder.matches(inv)) continue;
                decoder = possibleDecoder;
                break;
            }
            if (decoder == null) {
                decoder = DEFAULT;
            }
            CACHE_MAP.put(teClass, decoder);
        }
        return decoder.toNBT(inv);
    }
}

