/*
 * Decompiled with CFR 0.152.
 */
package gregtech.loaders.postload;

import com.google.common.base.Stopwatch;
import cpw.mods.fml.common.ProgressManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SubTag;
import gregtech.api.util.GT_CLS_Compat;
import gregtech.api.util.GT_Forestry_Compat;
import gregtech.api.util.GT_Log;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeRegistrator;
import gregtech.api.util.GT_Utility;
import gregtech.common.items.GT_MetaGenerated_Tool_01;
import gregtech.common.items.behaviors.Behaviour_DataOrb;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_Massfabricator;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeOutput;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class GT_PostLoad {
    public static void activateOreDictHandler() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        GT_Mod.gregtechproxy.activateOreDictHandler();
        GT_Mod.GT_FML_LOGGER.info("Congratulations, you have been waiting long enough (" + stopwatch.stop() + "). Have a Cake.");
        GT_Log.out.println("GT_Mod: List of Lists of Tool Recipes: " + GT_ModHandler.sSingleNonBlockDamagableRecipeList_list.toString());
        GT_Log.out.println("GT_Mod: Vanilla Recipe List -> Outputs null or stackSize <=0: " + GT_ModHandler.sVanillaRecipeList_warntOutput.toString());
        GT_Log.out.println("GT_Mod: Single Non Block Damageable Recipe List -> Outputs null or stackSize <=0: " + GT_ModHandler.sSingleNonBlockDamagableRecipeList_warntOutput.toString());
    }

    public static void removeIc2Recipes(Map<IRecipeInput, RecipeOutput> aMaceratorRecipeList, Map<IRecipeInput, RecipeOutput> aCompressorRecipeList, Map<IRecipeInput, RecipeOutput> aExtractorRecipeList, Map<IRecipeInput, RecipeOutput> aOreWashingRecipeList, Map<IRecipeInput, RecipeOutput> aThermalCentrifugeRecipeList) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ItemStack iridiumOre = GT_ModHandler.getIC2Item("iridiumOre", 1L);
        aCompressorRecipeList.entrySet().parallelStream().filter(e -> ((IRecipeInput)e.getKey()).getInputs().size() == 1 && ((ItemStack)((IRecipeInput)e.getKey()).getInputs().get(0)).func_77969_a(iridiumOre)).findAny().ifPresent(e -> aCompressorRecipeList.remove(e.getKey()));
        GT_ModHandler.addIC2RecipesToGT(aMaceratorRecipeList, GT_Recipe.GT_Recipe_Map.sMaceratorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(aCompressorRecipeList, GT_Recipe.GT_Recipe_Map.sCompressorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(aExtractorRecipeList, GT_Recipe.GT_Recipe_Map.sExtractorRecipes, true, true, true);
        GT_ModHandler.addIC2RecipesToGT(aOreWashingRecipeList, GT_Recipe.GT_Recipe_Map.sOreWasherRecipes, false, true, true);
        GT_ModHandler.addIC2RecipesToGT(aThermalCentrifugeRecipeList, GT_Recipe.GT_Recipe_Map.sThermalCentrifugeRecipes, true, true, true);
        GT_Mod.GT_FML_LOGGER.info("IC2 Removal (" + stopwatch.stop() + "). Have a Cake.");
    }

    public static void registerFluidCannerRecipes() {
        ItemStack iSData0 = new ItemStack((Item)Items.field_151068_bn, 1, 0);
        ItemStack iLData0 = ItemList.Bottle_Empty.get(1L, new Object[0]);
        for (FluidContainerRegistry.FluidContainerData tData : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (tData.filledContainer.func_77973_b() == Items.field_151068_bn && tData.filledContainer.func_77960_j() == 0) {
                GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{iLData0}, new ItemStack[]{iSData0}, null, new FluidStack[]{Materials.Water.getFluid(250L)}, null, 4, 1, 0);
                GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{iSData0}, new ItemStack[]{iLData0}, null, null, null, 4, 1, 0);
                continue;
            }
            GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{tData.emptyContainer}, new ItemStack[]{tData.filledContainer}, null, new FluidStack[]{tData.fluid}, null, tData.fluid.amount / 62, 1, 0);
            GT_Recipe.GT_Recipe_Map.sFluidCannerRecipes.addRecipe(true, new ItemStack[]{tData.filledContainer}, new ItemStack[]{GT_Utility.getContainerItem(tData.filledContainer, true)}, null, null, new FluidStack[]{tData.fluid}, tData.fluid.amount / 62, 1, 0);
        }
    }

    public static void addFakeRecipes() {
        GT_Log.out.println("GT_Mod: Adding Fake Recipes for NEI");
        if (Mods.Forestry.isModLoaded()) {
            GT_Forestry_Compat.populateFakeNeiRecipes();
        }
        if (ItemList.IC2_Crop_Seeds.get(1L, new Object[0]) != null) {
            GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.IC2_Crop_Seeds.getWildcard(1L, new Object[0])}, new ItemStack[]{ItemList.IC2_Crop_Seeds.getWithName(1L, "Scanned Seeds", new Object[0])}, null, null, null, 160, 8, 0);
        }
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{new ItemStack(Items.field_151164_bB, 1, Short.MAX_VALUE)}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Book Data", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 128, 30, 0);
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{new ItemStack((Item)Items.field_151098_aY, 1, Short.MAX_VALUE)}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Map Data", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 128, 30, 0);
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Tool_DataOrb.getWithName(1L, "Orb to overwrite", new Object[0])}, new ItemStack[]{ItemList.Tool_DataOrb.getWithName(1L, "Copy of the Orb", new Object[0])}, ItemList.Tool_DataOrb.getWithName(0L, "Orb to copy", new Object[0]), null, null, 512, 30, 0);
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Stick to overwrite", new Object[0])}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Copy of the Stick", new Object[0])}, ItemList.Tool_DataStick.getWithName(0L, "Stick to copy", new Object[0]), null, null, 128, 30, 0);
        GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Raw Prospection Data", new Object[0])}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Analyzed Prospection Data", new Object[0])}, null, null, null, 1000, 30, 0);
        if (Mods.GalacticraftCore.isModLoaded()) {
            GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftCore.ID, "item.schematic", 1L, Short.MAX_VALUE)).func_151001_c("Any Schematic")}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 36000, 480, 0);
            if (Mods.GalacticraftMars.isModLoaded()) {
                GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{Objects.requireNonNull(GT_ModHandler.getModItem(Mods.GalacticraftMars.ID, "item.schematic", 1L, Short.MAX_VALUE)).func_151001_c("Any Schematic")}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 36000, 480, 0);
            }
            if (Mods.GalaxySpace.isModLoaded()) {
                for (int i = 4; i < 9; ++i) {
                    GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, new ItemStack[]{GT_ModHandler.getModItem(Mods.GalaxySpace.ID, "item.SchematicTier" + i, 1L).func_151001_c("Any Schematic")}, new ItemStack[]{ItemList.Tool_DataStick.getWithName(1L, "Scanned Schematic", new Object[0])}, ItemList.Tool_DataStick.getWithName(1L, "Stick to save it to", new Object[0]), null, null, 36000, 480, 0);
                }
            }
        }
        Materials.getMaterialsMap().values().forEach(tMaterial -> {
            if (tMaterial.mElement != null && !tMaterial.mElement.mIsIsotope && tMaterial != Materials.Magic && tMaterial.getMass() > 0L) {
                ItemStack tOutput = ItemList.Tool_DataOrb.get(1L, new Object[0]);
                Behaviour_DataOrb.setDataTitle(tOutput, "Elemental-Scan");
                Behaviour_DataOrb.setDataName(tOutput, tMaterial.mElement.name());
                ItemStack tInput = GT_OreDictUnificator.get(OrePrefixes.dust, tMaterial, 1L);
                ItemStack[] iSMat0 = new ItemStack[]{tInput};
                ItemStack[] iSMat1 = new ItemStack[]{tOutput};
                if (tInput != null) {
                    GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, iSMat0, iSMat1, ItemList.Tool_DataOrb.get(1L, new Object[0]), null, null, (int)(tMaterial.getMass() * 8192L), 30, 0);
                    GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.addFakeRecipe(false, null, iSMat0, iSMat1, new FluidStack[]{Materials.UUMatter.getFluid(tMaterial.getMass())}, null, (int)(tMaterial.getMass() * 512L), (int)GT_Values.VP[1], 0);
                    return;
                }
                tInput = GT_OreDictUnificator.get(OrePrefixes.cell, tMaterial, 1L);
                iSMat0 = new ItemStack[]{tInput};
                if (tInput != null) {
                    GT_Recipe.GT_Recipe_Map.sScannerFakeRecipes.addFakeRecipe(false, iSMat0, iSMat1, ItemList.Tool_DataOrb.get(1L, new Object[0]), null, null, (int)(tMaterial.getMass() * 8192L), 30, 0);
                    GT_Recipe.GT_Recipe_Map.sReplicatorFakeRecipes.addFakeRecipe(false, null, iSMat0, iSMat1, new FluidStack[]{Materials.UUMatter.getFluid(tMaterial.getMass())}, null, (int)(tMaterial.getMass() * 512L), (int)GT_Values.VP[1], 0);
                }
            }
        });
        if (!GT_MetaTileEntity_Massfabricator.sRequiresUUA) {
            GT_Recipe.GT_Recipe_Map.sMassFabFakeRecipes.addFakeRecipe(false, null, null, null, null, new FluidStack[]{Materials.UUMatter.getFluid(1L)}, GT_MetaTileEntity_Massfabricator.sDurationMultiplier, 256, 0);
        }
        GT_Recipe.GT_Recipe_Map.sMassFabFakeRecipes.addFakeRecipe(false, new ItemStack[]{GT_Utility.getIntegratedCircuit(1)}, null, null, new FluidStack[]{Materials.UUAmplifier.getFluid(GT_MetaTileEntity_Massfabricator.sUUAperUUM)}, new FluidStack[]{Materials.UUMatter.getFluid(1L)}, GT_MetaTileEntity_Massfabricator.sDurationMultiplier / GT_MetaTileEntity_Massfabricator.sUUASpeedBonus, 256, 0);
        GT_Recipe.GT_Recipe_Map.sRockBreakerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Display_ITS_FREE.getWithName(1L, "IT'S FREE! Place Lava on Side", new Object[0])}, new ItemStack[]{new ItemStack(Blocks.field_150347_e, 1)}, null, null, null, 16, 30, 0);
        GT_Recipe.GT_Recipe_Map.sRockBreakerFakeRecipes.addFakeRecipe(false, new ItemStack[]{ItemList.Display_ITS_FREE.getWithName(1L, "IT'S FREE! Place Lava on Top", new Object[0])}, new ItemStack[]{new ItemStack(Blocks.field_150348_b, 1)}, null, null, null, 16, 30, 0);
        GT_Recipe.GT_Recipe_Map.sRockBreakerFakeRecipes.addFakeRecipe(false, new ItemStack[]{GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Redstone, 1L), GT_Utility.getIntegratedCircuit(1)}, new ItemStack[]{new ItemStack(Blocks.field_150343_Z, 1)}, null, null, null, 128, 30, 0);
    }

    public static void nerfVanillaTools() {
        if (GT_Mod.gregtechproxy.mNerfedVanillaTools) {
            GT_Log.out.println("GT_Mod: Nerfing Vanilla Tool Durability");
            Items.field_151041_m.func_77656_e(12);
            Items.field_151039_o.func_77656_e(12);
            Items.field_151038_n.func_77656_e(12);
            Items.field_151053_p.func_77656_e(12);
            Items.field_151017_I.func_77656_e(12);
            Items.field_151052_q.func_77656_e(48);
            Items.field_151050_s.func_77656_e(48);
            Items.field_151051_r.func_77656_e(48);
            Items.field_151049_t.func_77656_e(48);
            Items.field_151018_J.func_77656_e(48);
            Items.field_151040_l.func_77656_e(256);
            Items.field_151035_b.func_77656_e(256);
            Items.field_151037_a.func_77656_e(256);
            Items.field_151036_c.func_77656_e(256);
            Items.field_151019_K.func_77656_e(256);
            Items.field_151010_B.func_77656_e(24);
            Items.field_151005_D.func_77656_e(24);
            Items.field_151011_C.func_77656_e(24);
            Items.field_151006_E.func_77656_e(24);
            Items.field_151013_M.func_77656_e(24);
            Items.field_151048_u.func_77656_e(768);
            Items.field_151046_w.func_77656_e(768);
            Items.field_151047_v.func_77656_e(768);
            Items.field_151056_x.func_77656_e(768);
            Items.field_151012_L.func_77656_e(768);
        }
    }

    public static void replaceVanillaMaterials() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        GT_Mod.GT_FML_LOGGER.info("Replacing Vanilla Materials in recipes, please wait.");
        HashSet<Materials> replaceVanillaItemsSet = GT_Mod.gregtechproxy.mUseGreatlyShrukenReplacementList ? Arrays.stream(Materials.values()).filter(GT_RecipeRegistrator::hasVanillaRecipes).collect(Collectors.toSet()) : new HashSet<Materials>(Arrays.asList(Materials.values()));
        ProgressManager.ProgressBar progressBar = ProgressManager.push((String)"Register materials", (int)replaceVanillaItemsSet.size());
        if (GT_Values.cls_enabled) {
            try {
                GT_CLS_Compat.doActualRegistrationCLS(progressBar, replaceVanillaItemsSet);
                GT_CLS_Compat.pushToDisplayProgress();
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                GT_Mod.GT_FML_LOGGER.catching((Throwable)e);
            }
        } else {
            replaceVanillaItemsSet.forEach(m -> {
                progressBar.step(m.mDefaultLocalName);
                GT_PostLoad.doActualRegistration(m);
            });
        }
        ProgressManager.pop((ProgressManager.ProgressBar)progressBar);
        GT_Mod.GT_FML_LOGGER.info("Replaced Vanilla Materials (" + stopwatch.stop() + "). Have a Cake.");
    }

    public static void doActualRegistration(Materials m) {
        boolean noSmash;
        String plateName = OrePrefixes.plate.get(m).toString();
        boolean bl = noSmash = !m.contains(SubTag.NO_SMASHING);
        if ((m.mTypes & 2) != 0) {
            GT_RecipeRegistrator.registerUsagesForMaterials(plateName, noSmash, m.getIngots(1));
        }
        if ((m.mTypes & 4) != 0) {
            GT_RecipeRegistrator.registerUsagesForMaterials(plateName, noSmash, m.getGems(1));
        }
        if (m.getBlocks(1) != null) {
            GT_RecipeRegistrator.registerUsagesForMaterials(null, noSmash, m.getBlocks(1));
        }
    }

    public static void createGTtoolsCreativeTab() {
        new CreativeTabs("GTtools"){

            @SideOnly(value=Side.CLIENT)
            public ItemStack func_151244_d() {
                return ItemList.Tool_Cheat.get(1L, new ItemStack(Blocks.field_150339_S, 1));
            }

            @SideOnly(value=Side.CLIENT)
            public Item func_78016_d() {
                return ItemList.Circuit_Integrated.getItem();
            }

            public void func_78018_a(List<ItemStack> aList) {
                for (int i = 0; i < 32766; i += 2) {
                    if (GT_MetaGenerated_Tool_01.INSTANCE.getToolStats(new ItemStack((Item)GT_MetaGenerated_Tool_01.INSTANCE, 1, i)) == null) continue;
                    ItemStack tStack = new ItemStack((Item)GT_MetaGenerated_Tool_01.INSTANCE, 1, i);
                    GT_MetaGenerated_Tool_01.INSTANCE.isItemStackUsable(tStack);
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Lead, Materials.Lead, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Nickel, Materials.Nickel, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Cobalt, Materials.Cobalt, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Osmium, Materials.Osmium, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Adamantium, Materials.Adamantium, null));
                    aList.add(GT_MetaGenerated_Tool_01.INSTANCE.getToolWithStats(i, 1, Materials.Neutronium, Materials.Neutronium, null));
                }
                super.func_78018_a(aList);
            }
        };
    }

    public static void addSolidFakeLargeBoilerFuels() {
        GT_Recipe.GT_Recipe_Map.sLargeBoilerFakeFuels.addSolidRecipes(GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Charcoal, 1L), GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Charcoal, 1L), GT_OreDictUnificator.get(OrePrefixes.block, Materials.Charcoal, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.block, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.crushed, Materials.Coal, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.gem, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.block, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.crushed, Materials.Lignite, 1L), GT_OreDictUnificator.get(OrePrefixes.log, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.plank, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.stick, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.slab, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Wood, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Sodium, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Lithium, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Caesium, 1L), GT_OreDictUnificator.get(OrePrefixes.dust, Materials.Sulfur, 1L), GT_OreDictUnificator.get(ItemList.Block_SSFUEL.get(1L, new Object[0])), GT_OreDictUnificator.get(ItemList.Block_MSSFUEL.get(1L, new Object[0])), GT_OreDictUnificator.get(OrePrefixes.rod, Materials.Blaze, 1L));
        if (Mods.Thaumcraft.isModLoaded()) {
            GT_Recipe.GT_Recipe_Map.sLargeBoilerFakeFuels.addSolidRecipe(GT_ModHandler.getModItem(Mods.Thaumcraft.ID, "ItemResource", 1L));
        }
    }

    public static void identifyAnySteam() {
        String[] steamCandidates = new String[]{"steam", "ic2steam"};
        String[] superHeatedSteamCandidates = new String[]{"ic2superheatedsteam"};
        GT_ModHandler.sAnySteamFluidIDs = Arrays.stream(steamCandidates).map(FluidRegistry::getFluid).filter(Objects::nonNull).map(FluidRegistry::getFluidID).collect(Collectors.toList());
        GT_ModHandler.sSuperHeatedSteamFluidIDs = Arrays.stream(superHeatedSteamCandidates).map(FluidRegistry::getFluid).filter(Objects::nonNull).map(FluidRegistry::getFluidID).collect(Collectors.toList());
    }
}

