/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.power;

import gregtech.api.enums.GT_Values;
import gregtech.common.power.EUPower;

public class BasicMachineEUPower
extends EUPower {
    protected static final String OC = " (OC)";
    protected boolean wasOverclocked;

    public BasicMachineEUPower(byte tier, int amperage) {
        super(tier, amperage);
    }

    public BasicMachineEUPower(byte tier, int amperage, int specialValue) {
        super(tier, amperage, specialValue);
    }

    @Override
    public void computePowerUsageAndDuration(int euPerTick, int duration) {
        super.computePowerUsageAndDuration(euPerTick, duration);
        if (this.tier == 0) {
            long xMaxProgresstime = (long)duration << 1;
            if (xMaxProgresstime > 0x7FFFFFFEL) {
                this.recipeEuPerTick = 0x7FFFFFFE;
                this.recipeDuration = 0x7FFFFFFE;
            } else {
                this.recipeEuPerTick = euPerTick >> 2;
                this.recipeDuration = (int)xMaxProgresstime;
            }
        } else {
            long xEUt = euPerTick;
            long tempEUt = Math.max(xEUt, GT_Values.V[1]);
            this.recipeDuration = duration;
            while (tempEUt <= GT_Values.V[this.tier - 1] * (long)this.amperage) {
                tempEUt <<= 2;
                this.recipeDuration >>= 1;
                xEUt = this.recipeDuration == 0 ? xEUt >> 1 : xEUt << 2;
            }
            if (xEUt > 0x7FFFFFFEL) {
                this.recipeEuPerTick = 0x7FFFFFFE;
                this.recipeDuration = 0x7FFFFFFE;
            } else {
                this.recipeEuPerTick = (int)xEUt;
                if (this.recipeEuPerTick == 0) {
                    this.recipeEuPerTick = 1;
                }
                if (this.recipeDuration == 0) {
                    this.recipeDuration = 1;
                }
            }
        }
        this.wasOverclocked = this.checkIfOverclocked();
    }

    @Override
    public String getPowerUsageString() {
        return this.decorateWithOverclockLabel(super.getPowerUsageString());
    }

    protected String decorateWithOverclockLabel(String s) {
        if (this.wasOverclocked) {
            s = s + OC;
        }
        return s;
    }

    protected boolean checkIfOverclocked() {
        return this.originalVoltage != this.computeVoltageForEuRate(this.recipeEuPerTick);
    }
}

