/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.modularui.widget;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.widget.Interactable;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.gui.modularui.GT_UITextures;
import org.lwjgl.opengl.GL11;

public class CoverCycleButtonWidget
extends CycleButtonWidget {
    private static final UITexture BUTTON_NORMAL_NOT_PRESSED = GT_UITextures.BUTTON_COVER_NORMAL.getSubArea(0.0f, 0.0f, 1.0f, 0.5f);
    private static final UITexture BUTTON_NORMAL_PRESSED = GT_UITextures.BUTTON_COVER_NORMAL.getSubArea(0.0f, 0.5f, 1.0f, 1.0f);
    private static final UITexture BUTTON_HOVERED_NOT_PRESSED = GT_UITextures.BUTTON_COVER_NORMAL_HOVERED.getSubArea(0.0f, 0.0f, 1.0f, 0.5f);
    private static final UITexture BUTTON_HOVERED_PRESSED = GT_UITextures.BUTTON_COVER_NORMAL_HOVERED.getSubArea(0.0f, 0.5f, 1.0f, 1.0f);
    private boolean clickPressed;
    private static final int TOOLTIP_DELAY = 5;

    public CoverCycleButtonWidget() {
        this.setSize(16, 16);
        this.setTooltipShowUpDelay(5);
    }

    public Interactable.ClickResult onClick(int buttonId, boolean doubleClick) {
        this.updateState();
        if (!this.canClick()) {
            return Interactable.ClickResult.REJECT;
        }
        this.clickPressed = true;
        return Interactable.ClickResult.SUCCESS;
    }

    public boolean onClickReleased(int buttonId) {
        this.clickPressed = false;
        this.updateState();
        if (!this.isHovering() || !this.canClick()) {
            return false;
        }
        return this.onClickImpl(buttonId);
    }

    protected boolean onClickImpl(int buttonId) {
        super.onClick(buttonId, false);
        return true;
    }

    protected boolean canClick() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected void updateState() {
    }

    public boolean isClickPressed() {
        return this.clickPressed;
    }

    public void drawBackground(float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        super.drawBackground(partialTicks);
    }

    public IDrawable[] getBackground() {
        if (this.isHovering()) {
            if (this.clickPressed) {
                return new IDrawable[]{BUTTON_HOVERED_PRESSED};
            }
            return new IDrawable[]{BUTTON_HOVERED_NOT_PRESSED};
        }
        if (this.clickPressed) {
            return new IDrawable[]{BUTTON_NORMAL_PRESSED};
        }
        return new IDrawable[]{BUTTON_NORMAL_NOT_PRESSED};
    }
}

