/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.redstone;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.GT_MetaGenerated_Tool;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_MultiBlockBase;
import gregtech.api.util.ISerializableObject;
import gregtech.common.covers.GT_Cover_NeedMaintainance;
import gregtech.common.covers.redstone.GT_Cover_AdvancedRedstoneTransmitterBase;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class GT_Cover_WirelessMaintenanceDetector
extends GT_Cover_AdvancedRedstoneTransmitterBase<MaintenanceTransmitterData> {
    private static final String[] extraTexts = new String[]{"No Issues", ">= 1 Issue", ">= 2 Issues", ">= 3 Issues", ">= 4 Issues", ">= 5 Issues", "Rotor < 80%", "Rotor < 100%"};

    public GT_Cover_WirelessMaintenanceDetector(ITexture coverTexture) {
        super(MaintenanceTransmitterData.class, coverTexture);
    }

    @Override
    public MaintenanceTransmitterData createDataObject() {
        return new MaintenanceTransmitterData();
    }

    @Override
    public MaintenanceTransmitterData createDataObject(int aLegacyData) {
        return this.createDataObject();
    }

    private static byte computeSignalBasedOnMaintenance(MaintenanceTransmitterData coverVariable, ICoverable tileEntity) {
        IMetaTileEntity metaTE;
        boolean signal = false;
        if (tileEntity instanceof IGregTechTileEntity && (metaTE = ((IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof GT_MetaTileEntity_MultiBlockBase) {
            GT_MetaTileEntity_MultiBlockBase multiTE = (GT_MetaTileEntity_MultiBlockBase)metaTE;
            int ideal = multiTE.getIdealStatus();
            int real = multiTE.getRepairStatus();
            switch (coverVariable.mode) {
                case NO_ISSUE: {
                    signal = ideal == real;
                    break;
                }
                case ONE_ISSUE: 
                case TWO_ISSUES: 
                case THREE_ISSUES: 
                case FOUR_ISSUES: 
                case FIVE_ISSUES: {
                    signal = ideal - real >= coverVariable.mode.ordinal();
                    break;
                }
                case ROTOR_80: 
                case ROTOR_100: {
                    ItemStack rotor = multiTE.getRealInventory()[1];
                    if (GT_Cover_NeedMaintainance.isRotor(rotor)) {
                        long max = GT_MetaGenerated_Tool.getToolMaxDamage(rotor);
                        long current = GT_MetaGenerated_Tool.getToolDamage(rotor);
                        if (coverVariable.mode == MaintenanceMode.ROTOR_80) {
                            signal = current >= max * 8L / 10L;
                            break;
                        }
                        long expectedDamage = Math.round(Math.min((double)multiTE.mEUt / (double)multiTE.damageFactorLow, Math.pow(multiTE.mEUt, multiTE.damageFactorHigh)));
                        signal = current + expectedDamage * 2L >= max;
                        break;
                    }
                    signal = true;
                }
            }
        }
        if (coverVariable.invert) {
            signal = !signal;
        }
        return (byte)(signal ? 15 : 0);
    }

    @Override
    public MaintenanceTransmitterData doCoverThingsImpl(ForgeDirection side, byte aInputRedstone, int aCoverID, MaintenanceTransmitterData aCoverVariable, ICoverable aTileEntity, long aTimer) {
        byte signal = GT_Cover_WirelessMaintenanceDetector.computeSignalBasedOnMaintenance(aCoverVariable, aTileEntity);
        long hash = GT_Cover_WirelessMaintenanceDetector.hashCoverCoords(aTileEntity, side);
        GT_Cover_WirelessMaintenanceDetector.setSignalAt(aCoverVariable.getUuid(), aCoverVariable.getFrequency(), hash, signal);
        return aCoverVariable;
    }

    @Override
    public boolean letsRedstoneGoOutImpl(ForgeDirection side, int aCoverID, MaintenanceTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    protected boolean manipulatesSidedRedstoneOutputImpl(ForgeDirection side, int aCoverID, MaintenanceTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return true;
    }

    @Override
    public int getTickRateImpl(ForgeDirection side, int aCoverID, MaintenanceTransmitterData aCoverVariable, ICoverable aTileEntity) {
        return 60;
    }

    @Override
    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        return new WirelessMaintenanceDetectorUIFactory(buildContext).createWindow();
    }

    public static class MaintenanceTransmitterData
    extends GT_Cover_AdvancedRedstoneTransmitterBase.TransmitterData {
        private MaintenanceMode mode;

        public MaintenanceTransmitterData(int frequency, UUID uuid, boolean invert, MaintenanceMode mode) {
            super(frequency, uuid, invert);
            this.mode = mode;
        }

        public MaintenanceTransmitterData() {
            this.mode = MaintenanceMode.ONE_ISSUE;
        }

        @Override
        @Nonnull
        public ISerializableObject copy() {
            return new MaintenanceTransmitterData(this.frequency, this.uuid, this.invert, this.mode);
        }

        @Override
        @Nonnull
        public NBTBase saveDataToNBT() {
            NBTTagCompound tag = (NBTTagCompound)super.saveDataToNBT();
            tag.func_74768_a("mode", this.mode.ordinal());
            return tag;
        }

        @Override
        public void writeToByteBuf(ByteBuf aBuf) {
            super.writeToByteBuf(aBuf);
            aBuf.writeInt(this.mode.ordinal());
        }

        @Override
        public void loadDataFromNBT(NBTBase aNBT) {
            super.loadDataFromNBT(aNBT);
            NBTTagCompound tag = (NBTTagCompound)aNBT;
            this.mode = MaintenanceMode.values()[tag.func_74762_e("mode")];
        }

        @Override
        @Nonnull
        public ISerializableObject readFromPacket(ByteArrayDataInput aBuf, EntityPlayerMP aPlayer) {
            super.readFromPacket(aBuf, aPlayer);
            this.mode = MaintenanceMode.values()[aBuf.readInt()];
            return this;
        }
    }

    public static enum MaintenanceMode {
        NO_ISSUE,
        ONE_ISSUE,
        TWO_ISSUES,
        THREE_ISSUES,
        FOUR_ISSUES,
        FIVE_ISSUES,
        ROTOR_80,
        ROTOR_100;

    }

    private class WirelessMaintenanceDetectorUIFactory
    extends GT_Cover_AdvancedRedstoneTransmitterBase.AdvancedRedstoneTransmitterBaseUIFactory {
        public WirelessMaintenanceDetectorUIFactory(GT_CoverUIBuildContext buildContext) {
            super(GT_Cover_WirelessMaintenanceDetector.this, buildContext);
        }

        @Override
        protected int getGUIHeight() {
            return 143;
        }

        @Override
        protected int getFrequencyRow() {
            return 0;
        }

        @Override
        protected int getButtonRow() {
            return 1;
        }

        @Override
        protected void addUIWidgets(ModularWindow.Builder builder) {
            super.addUIWidgets(builder);
            for (int i = 0; i < 8; ++i) {
                builder.widget(new TextWidget(extraTexts[i]).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(10 + 18 * (i % 2 == 0 ? 1 : 7), 29 + 18 * (2 + i / 2)));
            }
        }

        protected void addUIForDataController(CoverDataControllerWidget<MaintenanceTransmitterData> controller) {
            super.addUIForDataController(controller);
            int i = 0;
            while (i < 8) {
                int index = i++;
                controller.addFollower((Widget)CoverDataFollower_ToggleButtonWidget.ofDisableable(), coverData -> ((MaintenanceTransmitterData)coverData).mode == MaintenanceMode.values()[index], (coverData, state) -> {
                    ((MaintenanceTransmitterData)coverData).mode = MaintenanceMode.values()[index];
                    return coverData;
                }, widget -> widget.setToggleTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_CHECKMARK, (IDrawable)GT_UITextures.TRANSPARENT).setPos(18 * (index % 2 == 0 ? 0 : 6), 18 * (2 + index / 2)));
            }
        }
    }
}

