/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_LanguageManager;
import gregtech.api.util.GT_RenderingWorld;
import gregtech.common.blocks.GT_Block_Casings_Abstract;
import gregtech.common.blocks.GT_Item_Casings8;
import gregtech.common.blocks.GT_Material_Casings;
import gregtech.common.tileentities.machines.multi.GT_MetaTileEntity_LargeTurbine;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

public class GT_Block_Casings8
extends GT_Block_Casings_Abstract {
    public static boolean mConnectedMachineTextures = true;

    public GT_Block_Casings8() {
        super(GT_Item_Casings8.class, "gt.blockcasings8", GT_Material_Casings.INSTANCE, 15);
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".0.name", "Chemically Inert Machine Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".1.name", "PTFE Pipe Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".2.name", "Mining Neutronium Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".3.name", "Mining Black Plutonium Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".4.name", "Extreme Engine Intake Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".5.name", "Europium Reinforced Radiation Proof Machine Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".6.name", "Advanced Rhodium Plated Palladium Machine Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".7.name", "Advanced Iridium Plated Machine Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".8.name", "Magical Machine Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".9.name", "HSS-S Turbine Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".10.name", "Radiant Naquadah Alloy Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".11.name", "Basic Photolithographic Framework Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".12.name", "Reinforced Photolithographic Framework Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".13.name", "Radiation Proof Photolithographic Framework Casing");
        GT_LanguageManager.addStringLocalization(this.func_149739_a() + ".14.name", "Infinity Cooled Casing");
        ItemList.Casing_Chemically_Inert.set(new ItemStack((Block)this, 1, 0));
        ItemList.Casing_Pipe_Polytetrafluoroethylene.set(new ItemStack((Block)this, 1, 1));
        ItemList.Casing_MiningNeutronium.set(new ItemStack((Block)this, 1, 2));
        ItemList.Casing_MiningBlackPlutonium.set(new ItemStack((Block)this, 1, 3));
        ItemList.Casing_ExtremeEngineIntake.set(new ItemStack((Block)this, 1, 4));
        ItemList.Casing_AdvancedRadiationProof.set(new ItemStack((Block)this, 1, 5));
        ItemList.Casing_Advanced_Rhodium_Palladium.set(new ItemStack((Block)this, 1, 6));
        ItemList.Casing_Advanced_Iridium.set(new ItemStack((Block)this, 1, 7));
        ItemList.Casing_Magical.set(new ItemStack((Block)this, 1, 8));
        ItemList.Casing_TurbineGasAdvanced.set(new ItemStack((Block)this, 1, 9));
        ItemList.RadiantNaquadahAlloyCasing.set(new ItemStack((Block)this, 1, 10));
        ItemList.BasicPhotolithographicFrameworkCasing.set(new ItemStack((Block)this, 1, 11));
        ItemList.ReinforcedPhotolithographicFrameworkCasing.set(new ItemStack((Block)this, 1, 12));
        ItemList.RadiationProofPhotolithographicFrameworkCasing.set(new ItemStack((Block)this, 1, 13));
        ItemList.InfinityCooledCasing.set(new ItemStack((Block)this, 1, 14));
    }

    @Override
    public int getTextureIndex(int aMeta) {
        return 0x80 | aMeta + 48;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        IIcon iIcon;
        switch (aMeta) {
            case 0: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_CHEMICALLY_INERT.getIcon();
                break;
            }
            case 1: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_PIPE_POLYTETRAFLUOROETHYLENE.getIcon();
                break;
            }
            case 2: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_MINING_NEUTRONIUM.getIcon();
                break;
            }
            case 3: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_MINING_BLACKPLUTONIUM.getIcon();
                break;
            }
            case 4: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_EXTREME_ENGINE_INTAKE.getIcon();
                break;
            }
            case 5: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_ADVANCEDRADIATIONPROOF.getIcon();
                break;
            }
            case 6: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_RHODIUM_PALLADIUM.getIcon();
                break;
            }
            case 7: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_IRIDIUM.getIcon();
                break;
            }
            case 8: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_MAGICAL.getIcon();
                break;
            }
            case 9: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_ADVANCEDGAS.getIcon();
                break;
            }
            case 10: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_RADIANT_NAQUADAH_ALLOY.getIcon();
                break;
            }
            case 11: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_PCB_TIER_1.getIcon();
                break;
            }
            case 12: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_PCB_TIER_2.getIcon();
                break;
            }
            case 13: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_PCB_TIER_3.getIcon();
                break;
            }
            case 14: {
                iIcon = Textures.BlockIcons.INFINITY_COOLED_CASING.getIcon();
                break;
            }
            default: {
                iIcon = Textures.BlockIcons.MACHINE_CASING_ROBUST_TUNGSTENSTEEL.getIcon();
            }
        }
        return iIcon;
    }

    @Deprecated
    public IIcon getTurbineCasing(int meta, int iconIndex, boolean active) {
        IIcon iIcon;
        switch (meta) {
            case 9: {
                if (active) {
                    iIcon = Textures.BlockIcons.TURBINE_ADVGASACTIVE[iconIndex].getIcon();
                    break;
                }
                iIcon = Textures.BlockIcons.TURBINEADVGAS[iconIndex].getIcon();
                break;
            }
            default: {
                iIcon = active ? Textures.BlockIcons.TURBINE_ACTIVE[iconIndex].getIcon() : Textures.BlockIcons.TURBINE[iconIndex].getIcon();
            }
        }
        return iIcon;
    }

    public IIcon getTurbineCasing(int meta, int iconIndex, boolean active, boolean hasTurbine) {
        IIcon iIcon;
        switch (meta) {
            case 9: {
                if (active) {
                    iIcon = Textures.BlockIcons.TURBINE_ADVGASACTIVE[iconIndex].getIcon();
                    break;
                }
                if (hasTurbine) {
                    iIcon = Textures.BlockIcons.TURBINEADVGAS[iconIndex].getIcon();
                    break;
                }
                iIcon = Textures.BlockIcons.TURBINE_ADVGASEMPTY[iconIndex].getIcon();
                break;
            }
            default: {
                iIcon = active ? Textures.BlockIcons.TURBINE_ACTIVE[iconIndex].getIcon() : (hasTurbine ? Textures.BlockIcons.TURBINE[iconIndex].getIcon() : Textures.BlockIcons.TURBINE_EMPTY[iconIndex].getIcon());
            }
        }
        return iIcon;
    }

    private static int isTurbineControllerWithSide(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (!(tTileEntity instanceof IGregTechTileEntity)) {
            return 0;
        }
        IGregTechTileEntity tTile = (IGregTechTileEntity)tTileEntity;
        IMetaTileEntity iMetaTileEntity = tTile.getMetaTileEntity();
        if (iMetaTileEntity instanceof GT_MetaTileEntity_LargeTurbine) {
            GT_MetaTileEntity_LargeTurbine turbine = (GT_MetaTileEntity_LargeTurbine)iMetaTileEntity;
            if (tTile.getFrontFacing().ordinal() == ordinalSide) {
                if (turbine.isNewStyleRendering()) {
                    return 0;
                }
                if (tTile.isActive()) {
                    return 1;
                }
                return turbine.hasTurbine() ? 2 : 3;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess aWorld, int xCoord, int yCoord, int zCoord, int ordinalSide) {
        int tMeta = (aWorld = GT_RenderingWorld.getInstance(aWorld)).func_72805_g(xCoord, yCoord, zCoord);
        if (tMeta != 9 || !mConnectedMachineTextures) {
            return this.func_149691_a(ordinalSide, tMeta);
        }
        int tInvertLeftRightMod = ordinalSide % 2 * 2 - 1;
        switch (ordinalSide / 2) {
            case 0: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = GT_Block_Casings8.isTurbineControllerWithSide(aWorld, xCoord + j, yCoord, zCoord + i, ordinalSide)) == 0) continue;
                        return this.getTurbineCasing(tMeta, 4 - i * 3 - j, tState == 1, tState == 2);
                    }
                }
                break;
            }
            case 1: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = GT_Block_Casings8.isTurbineControllerWithSide(aWorld, xCoord + j, yCoord + i, zCoord, ordinalSide)) == 0) continue;
                        return this.getTurbineCasing(tMeta, 4 + i * 3 - j * tInvertLeftRightMod, tState == 1, tState == 2);
                    }
                }
                break;
            }
            case 2: {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        int tState;
                        if (i == 0 && j == 0 || (tState = GT_Block_Casings8.isTurbineControllerWithSide(aWorld, xCoord, yCoord + i, zCoord + j, ordinalSide)) == 0) continue;
                        return this.getTurbineCasing(tMeta, 4 + i * 3 + j * tInvertLeftRightMod, tState == 1, tState == 2);
                    }
                }
                break;
            }
        }
        return Textures.BlockIcons.MACHINE_CASING_SOLID_STEEL.getIcon();
    }
}

