/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregtech.api.enums.GT_Values;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.common.tileentities.machines.basic.GT_MetaTileEntity_MonsterRepellent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class GT_SpawnEventHandler {
    public static volatile List<int[]> mobReps = new CopyOnWriteArrayList<int[]>();

    public GT_SpawnEventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static int getPoweredRepellentRange(int aTier) {
        return 16 + 48 * aTier;
    }

    public static int getUnpoweredRepellentRange(int aTier) {
        return 4 + 12 * aTier;
    }

    @SubscribeEvent
    public void denyMobSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        if (event.entityLiving instanceof EntitySlime && ((EntitySlime)event.entityLiving).func_94057_bL().length() <= 0 && event.getResult() == Event.Result.ALLOW) {
            event.setResult(Event.Result.DEFAULT);
        }
        if (event.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (event.entityLiving.isCreatureType(EnumCreatureType.monster, false)) {
            double maxRangeCheck = Math.pow(GT_SpawnEventHandler.getUnpoweredRepellentRange(GT_Values.V.length - 1), 2.0);
            for (int[] rep : mobReps) {
                int r;
                TileEntity tTile;
                double dy;
                double dz;
                double dx;
                double check;
                if (rep[3] != event.entity.field_70170_p.field_73011_w.field_76574_g || !event.entity.field_70170_p.func_72899_e(rep[0], rep[1], rep[2]) || (check = (dx = (double)((float)rep[0] + 0.5f) - event.entity.field_70165_t) * dx + (dz = (double)((float)rep[2] + 0.5f) - event.entity.field_70161_v) * dz + (dy = (double)((float)rep[1] + 0.5f) - event.entity.field_70163_u) * dy) > maxRangeCheck || !((tTile = event.entity.field_70170_p.func_147438_o(rep[0], rep[1], rep[2])) instanceof BaseMetaTileEntity) || !(((BaseMetaTileEntity)tTile).getMetaTileEntity() instanceof GT_MetaTileEntity_MonsterRepellent) || !(check <= Math.pow(r = ((GT_MetaTileEntity_MonsterRepellent)((BaseMetaTileEntity)tTile).getMetaTileEntity()).mRange, 2.0))) continue;
                if (event.entityLiving instanceof EntitySlime) {
                    ((EntitySlime)event.entityLiving).func_94058_c("DoNotSpawnSlimes");
                }
                event.setResult(Event.Result.DENY);
                return;
            }
        }
    }
}

