/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.check;

import gregtech.api.util.GT_Recipe;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FindRecipeResult {
    @Nonnull
    private final State state;
    @Nullable
    private final GT_Recipe recipe;
    public static final FindRecipeResult NOT_FOUND = new FindRecipeResult(State.NOT_FOUND, null);
    public static final FindRecipeResult EXPLODE = new FindRecipeResult(State.EXPLODE, null);
    public static final FindRecipeResult ON_FIRE = new FindRecipeResult(State.ON_FIRE, null);

    private FindRecipeResult(@Nonnull State state, @Nullable GT_Recipe recipe) {
        this.state = state;
        this.recipe = recipe;
    }

    @Nonnull
    public State getState() {
        return this.state;
    }

    public boolean isSuccessful() {
        return this.state.success;
    }

    @Nullable
    public GT_Recipe getRecipe() {
        return this.recipe;
    }

    @Nonnull
    public GT_Recipe getRecipeNonNull() {
        return Objects.requireNonNull(this.recipe);
    }

    public static FindRecipeResult ofSuccess(@Nonnull GT_Recipe recipe) {
        return new FindRecipeResult(State.FOUND, Objects.requireNonNull(recipe));
    }

    public static FindRecipeResult ofInsufficientVoltage(@Nonnull GT_Recipe recipe) {
        return new FindRecipeResult(State.INSUFFICIENT_VOLTAGE, Objects.requireNonNull(recipe));
    }

    public static enum State {
        FOUND(true),
        INSUFFICIENT_VOLTAGE(false),
        NOT_FOUND(false),
        EXPLODE(false),
        ON_FIRE(false);

        private final boolean success;

        private State(boolean success) {
            this.success = success;
        }
    }
}

