/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import gregtech.api.GregTech_API;
import gregtech.api.objects.GT_ItemStack;
import gregtech.api.util.GT_Utility;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class GT_HashSet<E extends GT_ItemStack>
extends AbstractSet<E> {
    private static final Object OBJECT = new Object();
    private final transient HashMap<GT_ItemStack, Object> map;

    public GT_HashSet() {
        this.map = new HashMap();
        GregTech_API.sItemStackMappings.add(this.map);
    }

    public GT_HashSet(Collection<? extends E> c) {
        this.map = new HashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
        GregTech_API.sItemStackMappings.add(this.map);
    }

    public GT_HashSet(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
        GregTech_API.sItemStackMappings.add(this.map);
    }

    public GT_HashSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
        GregTech_API.sItemStackMappings.add(this.map);
    }

    GT_HashSet(int initialCapacity, float loadFactor, boolean dummy) {
        this.map = new LinkedHashMap<GT_ItemStack, Object>(initialCapacity, loadFactor);
        GregTech_API.sItemStackMappings.add(this.map);
    }

    public Map<GT_ItemStack, Object> getMap() {
        return this.map;
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    @Override
    public boolean add(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack)) {
            return false;
        }
        return this.map.put(new GT_ItemStack(aStack), OBJECT) == null;
    }

    @Override
    public boolean add(E e) {
        return this.map.put((GT_ItemStack)e, OBJECT) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) == OBJECT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

