/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity.implementations;

import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GT_UIInfos;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_BasicTank;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.common.GT_Pollution;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class GT_MetaTileEntity_BasicGenerator
extends GT_MetaTileEntity_BasicTank {
    public GT_MetaTileEntity_BasicGenerator(int aID, String aName, String aNameRegional, int aTier, String aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicGenerator(int aID, String aName, String aNameRegional, int aTier, String[] aDescription, ITexture ... aTextures) {
        super(aID, aName, aNameRegional, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicGenerator(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    public GT_MetaTileEntity_BasicGenerator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        ITexture[][][] rTextures = new ITexture[10][17][];
        for (byte i = -1; i < 16; i = (byte)(i + 1)) {
            rTextures[0][i + 1] = this.getFront(i);
            rTextures[1][i + 1] = this.getBack(i);
            rTextures[2][i + 1] = this.getBottom(i);
            rTextures[3][i + 1] = this.getTop(i);
            rTextures[4][i + 1] = this.getSides(i);
            rTextures[5][i + 1] = this.getFrontActive(i);
            rTextures[6][i + 1] = this.getBackActive(i);
            rTextures[7][i + 1] = this.getBottomActive(i);
            rTextures[8][i + 1] = this.getTopActive(i);
            rTextures[9][i + 1] = this.getSidesActive(i);
        }
        return rTextures;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        return this.mTextures[(active ? 5 : 0) + (side == facingDirection ? 0 : (side == facingDirection.getOpposite() ? 1 : (side == ForgeDirection.DOWN ? 2 : (side == ForgeDirection.UP ? 3 : 4))))][colorIndex + 1];
    }

    @Override
    public String[] getDescription() {
        String[] desc = new String[this.mDescriptionArray.length + 1];
        System.arraycopy(this.mDescriptionArray, 0, desc, 0, this.mDescriptionArray.length);
        desc[this.mDescriptionArray.length] = "Fuel Efficiency: " + this.getEfficiency() + "%";
        return desc;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        GT_UIInfos.openGTTileEntityUI(aBaseMetaTileEntity, aPlayer);
        return true;
    }

    public ITexture[] getFront(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBack(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getBottom(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getTop(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getSides(byte aColor) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][aColor + 1]};
    }

    public ITexture[] getFrontActive(byte aColor) {
        return this.getFront(aColor);
    }

    public ITexture[] getBackActive(byte aColor) {
        return this.getBack(aColor);
    }

    public ITexture[] getBottomActive(byte aColor) {
        return this.getBottom(aColor);
    }

    public ITexture[] getTopActive(byte aColor) {
        return this.getTop(aColor);
    }

    public ITexture[] getSidesActive(byte aColor) {
        return this.getSides(aColor);
    }

    @Override
    public boolean isFacingValid(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isSimpleMachine() {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return aIndex < 2;
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public long maxEUOutput() {
        return this.getBaseMetaTileEntity().isAllowedToWork() ? GT_Values.V[this.mTier] : 0L;
    }

    @Override
    public long maxEUStore() {
        return Math.max(this.getEUVar(), GT_Values.V[this.mTier] * 80L + this.getMinimumStoredEU());
    }

    @Override
    public boolean doesFillContainers() {
        return this.getBaseMetaTileEntity().isAllowedToWork();
    }

    @Override
    public boolean doesEmptyContainers() {
        return this.getBaseMetaTileEntity().isAllowedToWork();
    }

    @Override
    public boolean canTankBeFilled() {
        return this.getBaseMetaTileEntity().isAllowedToWork();
    }

    @Override
    public boolean canTankBeEmptied() {
        return this.getBaseMetaTileEntity().isAllowedToWork();
    }

    @Override
    public boolean displaysItemStack() {
        return true;
    }

    @Override
    public boolean displaysStackSize() {
        return false;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return this.getFuelValue(aFluid) > 0;
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return false;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide() && aBaseMetaTileEntity.isAllowedToWork() && aTick % 10L == 0L) {
            long tFuelValue;
            if (this.mFluid != null) {
                long tFluidAmountToUse;
                tFuelValue = this.getFuelValue(this.mFluid);
                long tConsumed = this.consumedFluidPerOperation(this.mFluid);
                if (tFuelValue > 0L && tConsumed > 0L && (long)this.mFluid.amount >= tConsumed && (tFluidAmountToUse = Math.min((long)this.mFluid.amount / tConsumed, (this.maxEUStore() - aBaseMetaTileEntity.getUniversalEnergyStored()) / tFuelValue)) > 0L && aBaseMetaTileEntity.increaseStoredEnergyUnits(tFluidAmountToUse * tFuelValue, true)) {
                    GT_Pollution.addPollution(this.getBaseMetaTileEntity(), this.getPollution() / 2);
                    this.mFluid.amount = (int)((long)this.mFluid.amount - tFluidAmountToUse * tConsumed);
                }
            }
            if (this.mInventory[this.getInputSlot()] != null && aBaseMetaTileEntity.getUniversalEnergyStored() < this.maxEUOutput() * 20L + this.getMinimumStoredEU() && (GT_Utility.getFluidForFilledItem(this.mInventory[this.getInputSlot()], true) != null || this.solidFuelOverride(this.mInventory[this.getInputSlot()]))) {
                tFuelValue = this.getFuelValue(this.mInventory[this.getInputSlot()]);
                if (tFuelValue <= 0L) {
                    tFuelValue = this.getFuelValue(this.mInventory[this.getInputSlot()], true);
                }
                if (tFuelValue > 0L) {
                    ItemStack tEmptyContainer = this.getEmptyContainer(this.mInventory[this.getInputSlot()]);
                    if (aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot(), tEmptyContainer)) {
                        aBaseMetaTileEntity.increaseStoredEnergyUnits(tFuelValue, true);
                        aBaseMetaTileEntity.func_70298_a(this.getInputSlot(), 1);
                        GT_Pollution.addPollution(this.getBaseMetaTileEntity(), this.getPollution() / 2);
                    }
                }
            }
        }
        if (aBaseMetaTileEntity.isServerSide()) {
            aBaseMetaTileEntity.setActive(aBaseMetaTileEntity.isAllowedToWork() && aBaseMetaTileEntity.getUniversalEnergyStored() >= this.maxEUOutput() + this.getMinimumStoredEU());
        }
    }

    public boolean solidFuelOverride(ItemStack stack) {
        ItemData association = GT_OreDictUnificator.getAssociation(stack);
        if (association != null) {
            return !OrePrefixes.CELL_TYPES.contains((Object)association.mPrefix) && !GT_Utility.areStacksEqual(ItemList.VOLUMETRIC_FLASK.get(1L, new Object[0]), stack, true);
        }
        return stack != null && stack.func_77973_b() != null && !(stack.func_77973_b() instanceof IFluidContainerItem) && !(stack.func_77973_b() instanceof IFluidHandler) && !stack.func_77973_b().func_77658_a().contains("bucket");
    }

    public abstract int getPollution();

    public abstract GT_Recipe.GT_Recipe_Map getRecipes();

    public abstract int getEfficiency();

    public int consumedFluidPerOperation(FluidStack aLiquid) {
        return 1;
    }

    public int getFuelValue(FluidStack aLiquid) {
        long value = this.getFuelValue(aLiquid, true);
        return value > Integer.MAX_VALUE ? 0 : (int)value;
    }

    public long getFuelValue(FluidStack aLiquid, boolean aLong) {
        GT_Recipe.GT_Recipe_Map tRecipes = this.getRecipes();
        if (aLiquid == null || !(tRecipes instanceof GT_Recipe.GT_Recipe_Map_Fuel)) {
            return 0L;
        }
        GT_Recipe.GT_Recipe_Map_Fuel tFuels = (GT_Recipe.GT_Recipe_Map_Fuel)tRecipes;
        GT_Recipe tFuel = tFuels.findFuel(aLiquid);
        if (tFuel == null) {
            return 0L;
        }
        return (long)tFuel.mSpecialValue * (long)this.getEfficiency() * (long)this.consumedFluidPerOperation(aLiquid) / 100L;
    }

    public int getFuelValue(ItemStack aStack) {
        long value = this.getFuelValue(aStack, true);
        return value > Integer.MAX_VALUE ? 0 : (int)value;
    }

    public long getFuelValue(ItemStack aStack, boolean aLong) {
        if (GT_Utility.isStackInvalid(aStack) || this.getRecipes() == null) {
            return 0L;
        }
        GT_Recipe tFuel = this.getRecipes().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, aStack);
        if (tFuel == null) {
            return 0L;
        }
        long liters = 10L;
        return (long)tFuel.mSpecialValue * liters * (long)this.getEfficiency();
    }

    public ItemStack getEmptyContainer(ItemStack aStack) {
        if (GT_Utility.isStackInvalid(aStack) || this.getRecipes() == null) {
            return null;
        }
        GT_Recipe tFuel = this.getRecipes().findRecipe((IHasWorldObjectAndCoords)this.getBaseMetaTileEntity(), false, Long.MAX_VALUE, null, aStack);
        if (tFuel != null) {
            return GT_Utility.copyOrNull(tFuel.getOutput(0));
        }
        return GT_Utility.getContainerItem(aStack, true);
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStack(aBaseMetaTileEntity, aIndex, side, aStack) && (this.getFuelValue(aStack, true) > 0L || this.getFuelValue(GT_Utility.getFluidForFilledItem(aStack, true), true) > 0L);
    }

    @Override
    public int getCapacity() {
        return 16000;
    }

    @Override
    public int getTankPressure() {
        return -100;
    }

    @Override
    public boolean useModularUI() {
        return true;
    }
}

