/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.logic;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PowerLogic {
    public static int NONE = 0;
    public static int RECEIVER = 1;
    public static int EMITTER = 2;
    public static int BOTH = RECEIVER | EMITTER;
    private long storedEnergy = 0L;
    private long energyCapacity = 0L;
    private long voltage = 0L;
    private long amperage = 0L;
    private int type = 0;
    private boolean canUseLaser = false;

    public PowerLogic setMaxVoltage(long voltage) {
        this.voltage = voltage;
        return this;
    }

    public PowerLogic setEnergyCapacity(long energyCapacity) {
        this.energyCapacity = energyCapacity;
        return this;
    }

    public PowerLogic setAmperage(long amperage) {
        this.amperage = amperage;
        return this;
    }

    public PowerLogic setType(int type) {
        this.type = type;
        return this;
    }

    public PowerLogic disableLaser() {
        this.canUseLaser = false;
        return this;
    }

    public PowerLogic enableLaser() {
        this.canUseLaser = true;
        return this;
    }

    public boolean addEnergyUnsafe(long totalEUAdded) {
        if (this.storedEnergy + totalEUAdded >= this.energyCapacity) {
            return false;
        }
        this.storedEnergy += totalEUAdded;
        return true;
    }

    public boolean addEnergy(long voltage, long amperage) {
        if (voltage > this.voltage) {
            return false;
        }
        return this.addEnergyUnsafe(voltage * amperage);
    }

    public boolean addEnergy(long voltage) {
        return this.addEnergy(voltage, 1L);
    }

    public long injectEnergy(long voltage, long availableAmperage) {
        long usedAmperes;
        for (usedAmperes = 0L; this.addEnergy(voltage, 1L) && usedAmperes < this.amperage; ++usedAmperes) {
        }
        return usedAmperes;
    }

    public boolean removeEnergyUnsafe(long totalEURemoved) {
        if (this.storedEnergy - totalEURemoved < 0L) {
            return false;
        }
        this.storedEnergy -= totalEURemoved;
        return true;
    }

    public boolean removeEnergy(long voltage, long amperage) {
        if (voltage > this.voltage) {
            return false;
        }
        return this.removeEnergyUnsafe(voltage * amperage);
    }

    public boolean removeEnergy(long voltage) {
        return this.removeEnergy(voltage, 1L);
    }

    public long getCapacity() {
        return this.energyCapacity;
    }

    public long getVoltage() {
        return this.voltage;
    }

    public long getStoredEnergy() {
        return this.storedEnergy;
    }

    public boolean isEnergyReceiver() {
        return (this.type & RECEIVER) > 0;
    }

    public boolean isEnergyEmitter() {
        return (this.type & EMITTER) > 0;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound powerLogic = new NBTTagCompound();
        powerLogic.func_74772_a("gt.pow.energy.cap", this.energyCapacity);
        powerLogic.func_74772_a("gt.pow.energy", this.storedEnergy);
        powerLogic.func_74772_a("gt.pow.amp", this.amperage);
        powerLogic.func_74772_a("gt.pow.volt", this.voltage);
        powerLogic.func_74768_a("gt.pow.type", this.type);
        nbt.func_74782_a("gt.pow.logic", (NBTBase)powerLogic);
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        NBTTagCompound powerLogic = nbt.func_74775_l("gt.pow.logic");
        this.energyCapacity = powerLogic.func_74763_f("gt.pow.energy.cap");
        this.storedEnergy = powerLogic.func_74763_f("gt.pow.energy");
        this.amperage = powerLogic.func_74763_f("gt.pow.amp");
        this.voltage = powerLogic.func_74763_f("gt.pow.volt");
        this.type = powerLogic.func_74762_e("gt.pow.type");
    }

    public boolean canUseLaser() {
        return this.canUseLaser;
    }
}

