/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import com.google.common.collect.ImmutableList;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.util.IGT_HatchAdder;
import java.util.List;

class HatchElementEither<T>
implements IHatchElement<T> {
    private final IHatchElement<? super T> first;
    private final IHatchElement<? super T> second;
    private ImmutableList<? extends Class<? extends IMetaTileEntity>> mMteClasses;
    private String name;

    HatchElementEither(IHatchElement<? super T> first, IHatchElement<? super T> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
        if (this.mMteClasses == null) {
            this.mMteClasses = ImmutableList.builder().addAll(this.first.mteClasses()).addAll(this.second.mteClasses()).build();
        }
        return this.mMteClasses;
    }

    @Override
    public IGT_HatchAdder<? super T> adder() {
        return (t, te, i) -> this.first.adder().apply(t, te, i) || this.second.adder().apply(t, te, i);
    }

    @Override
    public String name() {
        if (this.name == null) {
            this.name = this.first.name() + " or " + this.second.name();
        }
        return this.name;
    }

    @Override
    public long count(T t) {
        return this.first.count(t) + this.second.count(t);
    }
}

