/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import codechicken.nei.api.API;
import codechicken.nei.api.INEIGuiAdapter;
import codechicken.nei.api.INEIGuiHandler;
import gregtech.api.enums.GT_Values;
import gregtech.api.gui.GT_GUIContainerMetaTile_Machine;
import gregtech.api.gui.widgets.GT_GuiTabLine;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GT_Packet_GtTileEntityGuiRequest;
import java.awt.Rectangle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GT_GuiCoverTabLine
extends GT_GuiTabLine {
    private static final String[] SIDES = new String[]{"GT5U.interface.coverTabs.down", "GT5U.interface.coverTabs.up", "GT5U.interface.coverTabs.north", "GT5U.interface.coverTabs.south", "GT5U.interface.coverTabs.west", "GT5U.interface.coverTabs.east"};
    private final String[] translatedSides;
    private final IGregTechTileEntity tile;
    private final int colorization;

    public GT_GuiCoverTabLine(GT_GUIContainerMetaTile_Machine gui, int tabLineLeft, int tabLineTop, int tabHeight, int tabWidth, int tabSpacing, GT_GuiTabLine.DisplayStyle xDir, GT_GuiTabLine.DisplayStyle yDir, GT_GuiTabLine.DisplayStyle displayMode, GT_GuiTabLine.GT_GuiTabIconSet tabBackground, IGregTechTileEntity tile, int colorization) {
        super(gui, 6, tabLineLeft, tabLineTop, tabHeight, tabWidth, tabSpacing, xDir, yDir, displayMode, tabBackground);
        this.tile = tile;
        this.colorization = colorization;
        this.translatedSides = new String[6];
        this.setupTabs();
    }

    private void setupTabs() {
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            ItemStack cover = this.tile.getCoverItemAtSide(side);
            if (cover == null) continue;
            this.addCoverToTabs(side, cover);
        }
    }

    @Override
    protected void drawBackground(float parTicks, int mouseX, int mouseY) {
        GL11.glColor3ub((byte)((byte)(this.colorization >> 16 & 0xFF)), (byte)((byte)(this.colorization >> 8 & 0xFF)), (byte)((byte)(this.colorization & 0xFF)));
        super.drawBackground(parTicks, mouseX, mouseY);
    }

    @Override
    protected void tabClicked(int tabId, int mouseButton) {
        if (mouseButton == 0 && this.mTabs[tabId].enabled) {
            GT_Values.NW.sendToServer(new GT_Packet_GtTileEntityGuiRequest(this.tile.getXCoord(), this.tile.getYCoord(), this.tile.getZCoord(), tabId + 10, this.tile.getWorld().field_73011_w.field_76574_g, Minecraft.func_71410_x().field_71439_g.func_145782_y(), 0));
        }
    }

    private void addCoverToTabs(ForgeDirection side, ItemStack cover) {
        boolean enabled = this.tile.getCoverBehaviorAtSideNew(side).hasCoverGUI();
        int ordinalSide = side.ordinal();
        this.setTab(ordinalSide, cover, null, this.getTooltipForCoverTab(side, cover, enabled));
        this.setTabEnabled(ordinalSide, enabled);
    }

    private String[] getTooltipForCoverTab(ForgeDirection side, ItemStack cover, boolean enabled) {
        List tooltip = cover.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, true);
        tooltip.set(0, (enabled ? EnumChatFormatting.UNDERLINE : EnumChatFormatting.DARK_GRAY) + this.getSideDescription(side) + (enabled ? EnumChatFormatting.RESET + ": " : ": " + EnumChatFormatting.RESET) + (String)tooltip.get(0));
        return tooltip.toArray(new String[0]);
    }

    private String getSideDescription(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        if (ordinalSide < SIDES.length) {
            if (this.translatedSides[ordinalSide] == null) {
                this.translatedSides[ordinalSide] = StatCollector.func_74838_a((String)SIDES[ordinalSide]);
            }
            return this.translatedSides[ordinalSide];
        }
        return null;
    }

    static {
        API.registerNEIGuiHandler((INEIGuiHandler)new CoverTabLineNEIHandler());
    }

    static class CoverTabLineNEIHandler
    extends INEIGuiAdapter {
        CoverTabLineNEIHandler() {
        }

        public boolean hideItemPanelSlot(GuiContainer gui, int x, int y, int w, int h) {
            Rectangle neiSlotArea = new Rectangle(x, y, w, h);
            if (gui instanceof GT_GUIContainerMetaTile_Machine) {
                GT_GuiCoverTabLine tabLine = ((GT_GUIContainerMetaTile_Machine)gui).coverTabs;
                if (!tabLine.visible) {
                    return false;
                }
                for (int i = 0; i < tabLine.mTabs.length; ++i) {
                    if (tabLine.mTabs[i] == null || !tabLine.mTabs[i].getBounds().intersects(neiSlotArea)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

