/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.modularui;

import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import gregtech.api.enums.SteamVariant;
import gregtech.api.gui.modularui.SteamTexture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;

public class FallbackableSteamTexture {
    private final SteamTexture candidate;
    private final Object fallback;
    private final Map<SteamVariant, Boolean> useFallbackMap = new HashMap<SteamVariant, Boolean>();
    private static final List<FallbackableSteamTexture> ALL_INSTANCES = new ArrayList<FallbackableSteamTexture>();

    public FallbackableSteamTexture(SteamTexture candidate, SteamTexture fallback) {
        this(candidate, (Object)fallback);
    }

    public FallbackableSteamTexture(SteamTexture candidate, FallbackableSteamTexture fallback) {
        this(candidate, (Object)fallback);
    }

    public FallbackableSteamTexture(SteamTexture fallback) {
        this(null, fallback);
    }

    private FallbackableSteamTexture(SteamTexture candidate, Object fallback) {
        this.candidate = candidate;
        this.fallback = fallback;
        ALL_INSTANCES.add(this);
    }

    public UITexture get(SteamVariant steamVariant) {
        this.verifyCandidate(steamVariant);
        if (this.useFallbackMap.get((Object)steamVariant).booleanValue()) {
            return this.castFallback(steamVariant);
        }
        return this.candidate.get(steamVariant);
    }

    private void verifyCandidate(SteamVariant steamVariant) {
        if (this.useFallbackMap.get((Object)steamVariant) == null) {
            boolean useFallback;
            if (NetworkUtils.isDedicatedClient()) {
                if (this.candidate == null) {
                    useFallback = true;
                } else {
                    try {
                        Minecraft.func_71410_x().func_110442_L().func_110536_a(this.candidate.get((SteamVariant)steamVariant).location);
                        useFallback = false;
                    }
                    catch (IOException e) {
                        useFallback = true;
                    }
                }
            } else {
                useFallback = true;
            }
            this.useFallbackMap.put(steamVariant, useFallback);
        }
    }

    private UITexture castFallback(SteamVariant steamVariant) {
        if (this.fallback instanceof SteamTexture) {
            return ((SteamTexture)this.fallback).get(steamVariant);
        }
        if (this.fallback instanceof FallbackableSteamTexture) {
            return ((FallbackableSteamTexture)this.fallback).get(steamVariant);
        }
        throw new RuntimeException("Unexpected type found for fallback: " + this.fallback.getClass());
    }

    public static void reload() {
        for (FallbackableSteamTexture t : ALL_INSTANCES) {
            t.useFallbackMap.clear();
        }
    }
}

