/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import gregtech.api.GregTech_API;
import gregtech.api.util.ColorsMetadataSection;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;

public class GT_GUIColorOverride {
    private static final Object NOT_FOUND = new Object();
    private static final LoadingCache<ResourceLocation, Object> cache = CacheBuilder.newBuilder().softValues().build((CacheLoader)new CacheLoader<ResourceLocation, Object>(){

        public Object load(@Nonnull ResourceLocation key) throws Exception {
            IResource ir = Minecraft.func_71410_x().func_110442_L().func_110536_a(key);
            if (ir.func_110528_c()) {
                return ir.func_110526_a("colors");
            }
            return NOT_FOUND;
        }
    });
    private static final GT_GUIColorOverride FALLBACK = new GT_GUIColorOverride();
    private ColorsMetadataSection cmSection;

    public static GT_GUIColorOverride get(String fullLocation) {
        if (FMLLaunchHandler.side() != Side.CLIENT) {
            return FALLBACK;
        }
        return new GT_GUIColorOverride(new ResourceLocation(fullLocation));
    }

    public static GT_GUIColorOverride get(ResourceLocation path) {
        if (FMLLaunchHandler.side() != Side.CLIENT) {
            return FALLBACK;
        }
        return new GT_GUIColorOverride(path);
    }

    private GT_GUIColorOverride() {
        this.cmSection = null;
    }

    @Deprecated
    public GT_GUIColorOverride(String guiTexturePath) {
        this(new ResourceLocation(guiTexturePath));
    }

    private GT_GUIColorOverride(ResourceLocation resourceLocation) {
        try {
            Object metadata = cache.get((Object)resourceLocation);
            if (metadata != NOT_FOUND) {
                this.cmSection = (ColorsMetadataSection)metadata;
            }
        }
        catch (UncheckedExecutionException | ExecutionException ignore) {
            cache.invalidate((Object)resourceLocation);
        }
    }

    public int getTextColorOrDefault(String textType, int defaultColor) {
        return this.sLoaded() ? this.cmSection.getTextColorOrDefault(textType, defaultColor) : defaultColor;
    }

    public int getGuiTintOrDefault(String key, int defaultColor) {
        return this.sLoaded() ? this.cmSection.getGuiTintOrDefault(key, defaultColor) : defaultColor;
    }

    public boolean sGuiTintingEnabled() {
        return this.sLoaded() ? this.cmSection.sGuiTintingEnabled() : GregTech_API.sColoredGUI;
    }

    public boolean sLoaded() {
        return this.cmSection != null;
    }

    public static void onResourceManagerReload() {
        cache.invalidateAll();
    }
}

