/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.graphs.consumers;

import cofh.api.energy.IEnergyReceiver;
import gregtech.GT_Mod;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.SoundResource;
import gregtech.api.graphs.consumers.ConsumerNode;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.WorldSpawnedEventBuilder;
import gregtech.common.GT_Pollution;
import java.util.ArrayList;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class NodeEnergyReceiver
extends ConsumerNode {
    int mRestRF = 0;

    public NodeEnergyReceiver(int aNodeValue, IEnergyReceiver aTileEntity, ForgeDirection side, ArrayList<ConsumerNode> aConsumers) {
        super(aNodeValue, (TileEntity)aTileEntity, side, aConsumers);
    }

    @Override
    public int injectEnergy(long aVoltage, long aMaxAmps) {
        ForgeDirection tDirection = this.mSide;
        int rfOut = GT_Utility.safeInt(aVoltage * (long)GregTech_API.mEUtoRF / 100L);
        int ampsUsed = 0;
        if (this.mRestRF < rfOut) {
            this.mRestRF += rfOut;
            ampsUsed = 1;
        }
        if (((IEnergyReceiver)this.mTileEntity).receiveEnergy(tDirection, this.mRestRF, true) > 0) {
            int consumed = ((IEnergyReceiver)this.mTileEntity).receiveEnergy(tDirection, this.mRestRF, false);
            this.mRestRF -= consumed;
            return ampsUsed;
        }
        if (GregTech_API.mRFExplosions && GregTech_API.sMachineExplosions && (long)((IEnergyReceiver)this.mTileEntity).getMaxEnergyStored(tDirection) < (long)rfOut * 600L) {
            this.explode(rfOut);
        }
        return 0;
    }

    private void explode(int aRfOut) {
        if ((long)aRfOut > 32L * (long)GregTech_API.mEUtoRF / 100L) {
            float tStrength = GT_Values.getExplosionPowerForVoltage(aRfOut);
            int tX = this.mTileEntity.field_145851_c;
            int tY = this.mTileEntity.field_145848_d;
            int tZ = this.mTileEntity.field_145849_e;
            World tWorld = this.mTileEntity.func_145831_w();
            GT_Utility.sendSoundToPlayers(tWorld, SoundResource.IC2_MACHINES_MACHINE_OVERLOAD, 1.0f, -1.0f, tX, tY, tZ);
            tWorld.func_147449_b(tX, tY, tZ, Blocks.field_150350_a);
            if (GregTech_API.sMachineExplosions && GT_Mod.gregtechproxy.mPollution) {
                GT_Pollution.addPollution(tWorld.func_72938_d(tX, tZ), GT_Mod.gregtechproxy.mPollutionOnExplosion);
            }
            new WorldSpawnedEventBuilder.ExplosionEffectEventBuilder().setStrength(tStrength).setSmoking(true).setPosition((double)tX + 0.5, (double)tY + 0.5, (double)tZ + 0.5).setWorld(tWorld).run();
        }
    }
}

