/*
 * Decompiled with CFR 0.152.
 */
package net.glease.ggfab.mte;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.CycleButtonWidget;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import gregtech.api.enums.ItemList;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_InputBus;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.glease.ggfab.GGConstants;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.util.ForgeDirection;

public class MTE_LinkedInputBus
extends GT_MetaTileEntity_Hatch_InputBus {
    public static final int SIZE_INVENTORY = 18;
    private SharedInventory mRealInventory;
    private final ItemStackHandlerProxy handler = new ItemStackHandlerProxy();
    private String mChannel;
    private boolean mPrivate;
    private State mState;
    private WorldSave save;

    public MTE_LinkedInputBus(int id, String name, String nameRegional, int tier) {
        super(id, name, nameRegional, tier, 1, new String[]{"18 slot input bus linked together wirelessly", "Link does not cross world boundary", "Left/right click with data stick to copy/paste configuration", GGConstants.GGMARK_TOOLTIP});
    }

    public MTE_LinkedInputBus(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures);
    }

    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTE_LinkedInputBus(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    public int getCircuitSlot() {
        return 0;
    }

    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new TextFieldWidget().setSynced(true, true).setGetter(() -> this.mChannel == null ? "" : this.mChannel).setSetter(this::setChannel).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD}).setGTTooltip(() -> this.mTooltipCache.getData("ggfab.tooltip.linked_input_bus.change_freq_warn", new Object[0])).setSize(60, 18).setPos(48, 3))).widget(new CycleButtonWidget().setToggle(this::isPrivate, this::setPrivate).setTextureGetter(i -> i == 1 ? GT_UITextures.OVERLAY_BUTTON_CHECKMARK : GT_UITextures.OVERLAY_BUTTON_CROSS).setVariableBackground(new UITexture[]{GT_UITextures.BUTTON_STANDARD_TOGGLE}).setSynced(true, true).setGTTooltip(() -> this.mTooltipCache.getData("ggfab.tooltip.linked_input_bus.private", new Object[0])).setSize(18, 18).setPos(150, 3))).widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.handler, (int)9).startFromSlot(0).endAtSlot(17).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).slotCreator(i -> new BaseSlot((IItemHandlerModifiable)this.handler, (int)i, false){

            public ItemStack func_75211_c() {
                return this.isEnabled() ? super.func_75211_c() : null;
            }

            public boolean isEnabled() {
                return MTE_LinkedInputBus.this.mChannel != null;
            }
        }).build().setPos(7, 24))).widget(new TextWidget(new Text("Private")).setPos(110, 3).setSize(43, 20))).widget(new TextWidget(new Text("Channel")).setPos(5, 3).setSize(43, 20));
    }

    public int getCircuitSlotX() {
        return 152;
    }

    public ItemStack func_70301_a(int aIndex) {
        if (aIndex == this.getCircuitSlot()) {
            return super.func_70301_a(aIndex);
        }
        if (this.mState != State.Blocked && this.mChannel != null && this.mRealInventory != null && aIndex > 0 && aIndex <= 18) {
            return this.mRealInventory.stacks[aIndex - 1];
        }
        return null;
    }

    public void func_70299_a(int aIndex, ItemStack aStack) {
        if (aIndex == this.getCircuitSlot()) {
            this.mInventory[0] = GT_Utility.copyAmount((long)0L, (Object[])new Object[]{aStack});
            this.func_70296_d();
        } else if (this.mState != State.Blocked && this.mChannel != null && this.mRealInventory != null && aIndex > 0 && aIndex <= 18) {
            ((SharedInventory)this.mRealInventory).stacks[aIndex - 1] = aStack;
            this.getWorldSave().func_76185_a();
        }
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return super.getTexturesActive(aBaseTexture);
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return super.getTexturesInactive(aBaseTexture);
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.isValidSlot(aIndex) && aStack != null && this.mChannel != null && this.mRealInventory != null && aIndex > this.getCircuitSlot() && aIndex < 19 && (this.mRealInventory.stacks[aIndex - 1] == null || GT_Utility.areStacksEqual((ItemStack)aStack, (ItemStack)this.mRealInventory.stacks[aIndex - 1])) && this.allowPutStack(this.getBaseMetaTileEntity(), aIndex, ForgeDirection.getOrientation((int)ordinalSide), aStack);
    }

    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return !(side != this.getBaseMetaTileEntity().getFrontFacing() || aIndex == this.getCircuitSlot() || this.mRecipeMap != null && !this.disableFilter && !this.mRecipeMap.containsInput(aStack) || !this.mRealInventory.disableLimited && !this.limitedAllowPutStack(aIndex, aStack));
    }

    protected boolean limitedAllowPutStack(int aIndex, ItemStack aStack) {
        for (int i = 0; i < 18; ++i) {
            if (!GT_Utility.areStacksEqual((ItemStack)GT_OreDictUnificator.get_nocopy((ItemStack)aStack), (ItemStack)this.mRealInventory.stacks[i])) continue;
            return i == aIndex - 1;
        }
        return this.mRealInventory.stacks[aIndex - 1] == null;
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int aSide) {
        return false;
    }

    public int func_70302_i_() {
        if (this.mState != State.Blocked && this.mChannel != null && this.mRealInventory != null) {
            return 19;
        }
        return 1;
    }

    public void startRecipeProcessing() {
        if (this.mRealInventory == null) {
            return;
        }
        if (this.mRealInventory.used) {
            this.mState = State.Blocked;
        } else {
            this.mRealInventory.used = true;
            this.mState = State.Activated;
        }
    }

    public void endRecipeProcessing() {
        if (this.mState == State.Activated) {
            assert (this.mRealInventory != null);
            this.mRealInventory.used = false;
        }
        this.mState = State.Default;
    }

    public void updateSlots() {
        if (this.mChannel == null || this.mRealInventory == null) {
            return;
        }
        for (int i = 0; i < this.mRealInventory.stacks.length; ++i) {
            if (this.mRealInventory.stacks[i] == null || this.mRealInventory.stacks[i].func_77973_b() != null && ((SharedInventory)this.mRealInventory).stacks[i].field_77994_a > 0) continue;
            ((SharedInventory)this.mRealInventory).stacks[i] = null;
        }
        if (!this.mRealInventory.disableSort) {
            this.fillStacksIntoFirstSlots();
        }
        this.func_70296_d();
        this.getWorldSave().func_76185_a();
    }

    protected void fillStacksIntoFirstSlots() {
        if (this.mRealInventory == null) {
            return;
        }
        int L = 18;
        HashMap<GT_Utility.ItemId, Integer> slots = new HashMap<GT_Utility.ItemId, Integer>(18);
        HashMap<GT_Utility.ItemId, ItemStack> stacks = new HashMap<GT_Utility.ItemId, ItemStack>(18);
        ArrayList<GT_Utility.ItemId> order = new ArrayList<GT_Utility.ItemId>(18);
        ArrayList<Integer> validSlots = new ArrayList<Integer>(18);
        for (int i = 0; i < 18; ++i) {
            validSlots.add(i);
            ItemStack s = this.mRealInventory.stacks[i];
            if (s == null) continue;
            GT_Utility.ItemId sID = GT_Utility.ItemId.createNoCopy((ItemStack)s);
            slots.merge(sID, s.field_77994_a, Integer::sum);
            if (!stacks.containsKey(sID)) {
                stacks.put(sID, s);
            }
            order.add(sID);
            ((SharedInventory)this.mRealInventory).stacks[i] = null;
        }
        int slotindex = 0;
        for (GT_Utility.ItemId sID : order) {
            int toSet = (Integer)slots.get(sID);
            if (toSet == 0) continue;
            int slot = (Integer)validSlots.get(slotindex);
            ++slotindex;
            ((SharedInventory)this.mRealInventory).stacks[slot] = ((ItemStack)stacks.get(sID)).func_77946_l();
            ((SharedInventory)this.mRealInventory).stacks[slot].field_77994_a = toSet = Math.min(toSet, this.mRealInventory.stacks[slot].func_77976_d());
            slots.merge(sID, toSet, (a, b) -> a - b);
        }
    }

    private void dropItems(ItemStack[] aStacks) {
        for (ItemStack stack : aStacks) {
            if (!GT_Utility.isStackValid((Object)stack)) continue;
            EntityItem ei = new EntityItem(this.getBaseMetaTileEntity().getWorld(), (double)this.getBaseMetaTileEntity().getOffsetX(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, (double)this.getBaseMetaTileEntity().getOffsetY(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, (double)this.getBaseMetaTileEntity().getOffsetZ(this.getBaseMetaTileEntity().getFrontFacing(), 1) + 0.5, stack);
            ei.field_70179_y = 0.0;
            ei.field_70181_x = 0.0;
            ei.field_70159_w = 0.0;
            this.getBaseMetaTileEntity().getWorld().func_72838_d((Entity)ei);
        }
    }

    public boolean shouldDropItemAt(int index) {
        return this.mRealInventory != null && this.mRealInventory.ref <= 1;
    }

    public void onBlockDestroyed() {
        super.onBlockDestroyed();
        if (this.mRealInventory != null && --this.mRealInventory.ref <= 0) {
            this.getWorldSave().remove(this.mChannel);
        }
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        if (this.mChannel != null) {
            aNBT.func_74778_a("channel", this.mChannel);
        }
        aNBT.func_74757_a("private", this.mPrivate);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        String channel = aNBT.func_74779_i("channel");
        if ("".equals(channel)) {
            channel = null;
        }
        this.mChannel = channel;
        this.mPrivate = aNBT.func_74767_n("private");
    }

    public String getChannel() {
        return this.mChannel;
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        if (this.mChannel != null) {
            this.mRealInventory = this.getWorldSave().get(this.getRealChannel());
            this.handler.set(this.mRealInventory.stacks);
        }
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverBehaviorAtSideNew(side).isGUIClickable(side, this.getBaseMetaTileEntity().getCoverIDAtSide(side), this.getBaseMetaTileEntity().getComplexCoverDataAtSide(side), (ICoverable)this.getBaseMetaTileEntity())) {
            return;
        }
        if (aPlayer.func_70093_af()) {
            if (this.mRealInventory == null) {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.no_channel", new Object[0]));
                return;
            }
            if (this.mRealInventory.disableSort) {
                this.mRealInventory.disableSort = false;
            } else if (this.mRealInventory.disableLimited) {
                this.mRealInventory.disableLimited = false;
            } else {
                this.mRealInventory.disableSort = true;
                this.mRealInventory.disableLimited = true;
            }
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)(StatCollector.func_74838_a((String)("GT5U.hatch.disableSort." + this.mRealInventory.disableSort)) + "   " + StatCollector.func_74838_a((String)("GT5U.hatch.disableLimited." + this.mRealInventory.disableLimited))));
        } else {
            this.disableFilter = !this.disableFilter;
            GT_Utility.sendChatToPlayer((EntityPlayer)aPlayer, (String)StatCollector.func_74838_a((String)("GT5U.hatch.disableFilter." + this.disableFilter)));
        }
    }

    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        UUID owner;
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        ItemStack stick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual((Object)stick, false, true)) {
            return super.onRightclick(aBaseMetaTileEntity, aPlayer, side, aX, aY, aZ);
        }
        if (!stick.func_77942_o() || !"linkedinputbus".equals(stick.field_77990_d.func_74779_i("ggfab.type"))) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.no_data", new Object[0]));
            return true;
        }
        ItemStack circuit = GT_Utility.loadItem((NBTTagCompound)stick.field_77990_d, (String)"circuit");
        String channel = stick.field_77990_d.func_74779_i("channel");
        if (GT_Utility.isStackInvalid((Object)circuit)) {
            circuit = null;
        }
        if ("".equals(channel)) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.no_data", new Object[0]));
            return true;
        }
        if (circuit != null) {
            if (this.getConfigurationCircuits().stream().noneMatch(arg_0 -> ((ItemStack)circuit).func_77969_a(arg_0))) {
                aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.invalid_circuit", new Object[0]));
                return true;
            }
        }
        UUID uUID = owner = stick.field_77990_d.func_74764_b("owner1") ? new UUID(stick.field_77990_d.func_74763_f("owner1"), stick.field_77990_d.func_74763_f("owner2")) : null;
        if (owner != null && !owner.equals(this.getBaseMetaTileEntity().getOwnerUuid())) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.not_owned", new Object[0]));
            return true;
        }
        this.setPrivate(owner != null);
        this.setChannel(channel);
        this.func_70299_a(this.getCircuitSlot(), circuit);
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.data_pasted", new Object[]{channel}));
        return true;
    }

    public void onLeftclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        if (!(aPlayer instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack stick = aPlayer.field_71071_by.func_70448_g();
        if (!ItemList.Tool_DataStick.isStackEqual((Object)stick, false, true)) {
            return;
        }
        if (this.getChannel() == null) {
            aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.no_channel", new Object[0]));
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("ggfab.type", "linkedinputbus");
        tag.func_74778_a("channel", this.getChannel());
        tag.func_74782_a("circuit", (NBTBase)GT_Utility.saveItem((ItemStack)this.func_70301_a(this.getCircuitSlot())));
        if (this.isPrivate()) {
            tag.func_74772_a("owner1", this.getBaseMetaTileEntity().getOwnerUuid().getMostSignificantBits());
            tag.func_74772_a("owner2", this.getBaseMetaTileEntity().getOwnerUuid().getLeastSignificantBits());
        }
        aPlayer.func_145747_a((IChatComponent)new ChatComponentTranslation("ggfab.info.linked_input_bus.data_copied", new Object[]{this.getChannel()}));
        stick.field_77990_d = tag;
        stick.func_151001_c("Linked Input Bus configuration");
        GT_Utility.ItemNBT.setBookTitle((ItemStack)stick, (String)("Channel: " + this.getChannel()));
        if (this.getBaseMetaTileEntity().getOwnerName() != null) {
            GT_Utility.ItemNBT.setBookAuthor((ItemStack)stick, (String)this.getBaseMetaTileEntity().getOwnerName());
        }
    }

    private String getRealChannel() {
        if (this.mChannel == null) {
            return null;
        }
        if (this.mPrivate) {
            return this.getBaseMetaTileEntity().getOwnerUuid() + this.mChannel;
        }
        return new UUID(0L, 0L) + this.mChannel;
    }

    public boolean isPrivate() {
        return this.mPrivate;
    }

    public void setPrivate(boolean aPrivate) {
        if (aPrivate == this.mPrivate) {
            return;
        }
        if (this.getBaseMetaTileEntity().isClientSide()) {
            this.mPrivate = aPrivate;
            return;
        }
        if (this.mChannel == null) {
            this.mPrivate = aPrivate;
            return;
        }
        this.getWorldSave().func_76185_a();
        if (--this.mRealInventory.ref <= 0) {
            this.dropItems(this.mRealInventory.stacks);
            this.getWorldSave().remove(this.getRealChannel());
        }
        this.mPrivate = aPrivate;
        this.mRealInventory = this.getWorldSave().get(this.getRealChannel());
        this.handler.set(this.mRealInventory.stacks);
        this.mRealInventory.ref++;
        this.getWorldSave().func_76185_a();
    }

    public void setChannel(String aChannel) {
        if ("".equals(aChannel)) {
            aChannel = null;
        }
        if (this.getBaseMetaTileEntity().isClientSide()) {
            this.mChannel = aChannel;
            return;
        }
        if (Objects.equals(this.mChannel, aChannel)) {
            return;
        }
        if (this.mChannel != null && --this.mRealInventory.ref <= 0) {
            this.dropItems(this.mRealInventory.stacks);
            this.getWorldSave().remove(this.getRealChannel());
        }
        if (aChannel == null) {
            this.mChannel = null;
            this.mRealInventory = null;
            this.handler.setFake();
        } else {
            this.mChannel = aChannel;
            this.mRealInventory = this.getWorldSave().get(this.getRealChannel());
            this.handler.set(this.mRealInventory.stacks);
            this.mRealInventory.ref++;
        }
        this.getWorldSave().func_76185_a();
    }

    private WorldSave getWorldSave() {
        if (this.save == null) {
            WorldSave save = (WorldSave)this.getBaseMetaTileEntity().getWorld().func_72943_a(WorldSave.class, "LinkedInputBusses");
            if (save == null) {
                save = new WorldSave("LinkedInputBusses");
                this.getBaseMetaTileEntity().getWorld().func_72823_a(save.field_76190_i, (WorldSavedData)save);
            }
            this.save = save;
        }
        return this.save;
    }

    private static class ItemStackHandlerProxy
    extends ItemStackHandler {
        private static final ItemStack[] EMPTY = new ItemStack[18];
        private boolean fake = true;

        public ItemStackHandlerProxy() {
            super(EMPTY);
        }

        public void setFake() {
            this.set(EMPTY);
            this.fake = true;
        }

        public boolean isFake() {
            return this.fake;
        }

        public void set(ItemStack[] stacks) {
            this.stacks = Arrays.asList(stacks);
            this.fake = false;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = super.serializeNBT();
            tag.func_74757_a("fake", this.fake);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound nbt) {
            super.deserializeNBT(nbt);
            this.fake = nbt.func_74767_n("fake");
        }
    }

    public static class WorldSave
    extends WorldSavedData {
        private final Map<String, SharedInventory> data = new HashMap<String, SharedInventory>();

        public WorldSave(String p_i2141_1_) {
            super(p_i2141_1_);
        }

        public void func_76184_a(NBTTagCompound tag) {
            this.data.clear();
            Set set = tag.field_74784_a.entrySet();
            for (Map.Entry e : set) {
                this.data.put((String)e.getKey(), new SharedInventory((NBTTagCompound)e.getValue()));
            }
        }

        public void func_76187_b(NBTTagCompound tag) {
            for (Map.Entry<String, SharedInventory> e : this.data.entrySet()) {
                if (e.getValue().ref <= 0) continue;
                tag.func_74782_a(e.getKey(), (NBTBase)e.getValue().save());
            }
        }

        public SharedInventory get(Object channel) {
            return this.data.computeIfAbsent(channel.toString(), k -> new SharedInventory());
        }

        public void remove(Object channel) {
            this.data.remove(channel.toString());
            this.func_76185_a();
        }
    }

    private static class SharedInventory {
        private final ItemStack[] stacks = new ItemStack[18];
        private final ItemStackHandler inventoryHandler = new ItemStackHandler(this.stacks);
        public boolean disableLimited = true;
        public boolean disableSort;
        private boolean used;
        private int ref;

        public SharedInventory() {
        }

        public SharedInventory(NBTTagCompound tag) {
            for (int i = 0; i < 18; ++i) {
                String key = "" + i;
                if (!tag.func_150297_b(key, 10)) continue;
                this.stacks[i] = ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l(key));
            }
            this.ref = tag.func_74762_e("ref");
            this.disableLimited = tag.func_74767_n("dl");
            this.disableSort = tag.func_74767_n("ds");
        }

        public NBTTagCompound save() {
            NBTTagCompound tag = new NBTTagCompound();
            for (int i = 0; i < 18; ++i) {
                ItemStack stack = this.stacks[i];
                if (stack == null) continue;
                tag.func_74782_a("" + i, (NBTBase)stack.func_77955_b(new NBTTagCompound()));
            }
            tag.func_74768_a("ref", this.ref);
            tag.func_74757_a("ds", this.disableSort);
            tag.func_74757_a("dl", this.disableLimited);
            return tag;
        }
    }

    private static enum State {
        Activated,
        Blocked,
        Default;

    }
}

