/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.entities.ai;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import makeo.gadomancy.common.entities.fake.AdvancedFakePlayer;
import makeo.gadomancy.common.entities.fake.GolemFakePlayer;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.server.management.ItemInWorldManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.common.config.Config;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.Marker;
import thaumcraft.common.lib.utils.InventoryUtils;

public class AIBreakBlock
extends EntityAIBase {
    private static final int BLACKLIST_TICKS = 800;
    private EntityGolemBase golem;
    private AdvancedFakePlayer player;
    private Marker currentMarker;
    private boolean hasValidTool;
    private Map<Marker, Integer> blacklist = new HashMap<Marker, Integer>();
    private int blacklistCount;
    private int count;
    private int clickCount;

    public AIBreakBlock(EntityGolemBase golem) {
        this.golem = golem;
        if (golem.field_70170_p instanceof WorldServer) {
            this.player = new GolemFakePlayer((WorldServer)golem.field_70170_p, golem);
        }
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        if (this.golem.field_70173_aa % Config.golemDelay > 0) {
            return false;
        }
        this.currentMarker = this.getNextMarker();
        if (!this.hasValidTool()) {
            return this.isInHomeRange();
        }
        return this.currentMarker != null;
    }

    public boolean func_75253_b() {
        if (this.hasValidTool) {
            if (!this.hasBlock(this.currentMarker)) {
                return false;
            }
            if (this.distanceSquaredToGolem(this.currentMarker) < 1.0) {
                if (this.golem.getCarried() == null) {
                    this.golem.startActionTimer();
                } else {
                    this.golem.startRightArmTimer();
                }
                if (this.clickCount % (7 - Math.min(6, this.golem.getGolemStrength())) == 0) {
                    this.doLeftClick();
                }
                ++this.clickCount;
                this.golem.func_70671_ap().func_75650_a((double)this.currentMarker.x + 0.5, (double)this.currentMarker.y + 0.5, (double)this.currentMarker.z + 0.5, 30.0f, 30.0f);
                this.count = 0;
            } else {
                if (this.count == 20) {
                    this.count = 0;
                    ForgeDirection dir = ForgeDirection.getOrientation((int)this.currentMarker.side);
                    boolean path = this.golem.func_70661_as().func_75492_a((double)this.currentMarker.x + 0.5 + (double)dir.offsetX, (double)this.currentMarker.y + 0.5 + (double)dir.offsetY, (double)this.currentMarker.z + 0.5 + (double)dir.offsetZ, (double)this.golem.func_70689_ay());
                    if (!path) {
                        if (this.blacklistCount > 10) {
                            this.blacklist.put(this.currentMarker, this.golem.field_70173_aa);
                            return false;
                        }
                        ++this.blacklistCount;
                    }
                }
                ++this.count;
                this.clickCount = 0;
            }
        } else if (this.golem.field_70173_aa % Config.golemDelay > 0) {
            if (this.isInHomeRange()) {
                IInventory homeChest = this.getHomeChest();
                if (homeChest != null) {
                    this.trySwitchTool(homeChest);
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public void func_75251_c() {
        this.currentMarker = null;
        this.blacklistCount = 0;
        this.cancelLeftClick();
    }

    private void doLeftClick() {
        ItemStack tool = this.golem.getCarried();
        this.player.setHeldItem(tool);
        this.player.field_71134_c.func_73075_a();
        if (this.player.field_71134_c.field_73094_o == -1 || !this.player.field_71134_c.field_73088_d) {
            this.player.field_71134_c.func_73074_a(this.currentMarker.x, this.currentMarker.y, this.currentMarker.z, (int)this.currentMarker.side);
        } else if (this.player.field_71134_c.field_73094_o >= 9) {
            this.player.field_71134_c.func_73082_a(this.currentMarker.x, this.currentMarker.y, this.currentMarker.z);
            this.player.field_71134_c.field_73094_o = -1;
            if (tool != null) {
                Block block = this.golem.field_70170_p.func_147439_a(this.currentMarker.x, this.currentMarker.y, this.currentMarker.z);
                tool.func_77973_b().func_150894_a(tool, this.golem.field_70170_p, block, this.currentMarker.x, this.currentMarker.y, this.currentMarker.z, (EntityLivingBase)this.player);
            }
        }
        this.hasValidTool();
        this.golem.updateCarried();
    }

    private void cancelLeftClick() {
        ItemInWorldManager manager = this.player.field_71134_c;
        if (manager.field_73088_d) {
            this.player.field_71134_c.func_73073_c(manager.field_73086_f, manager.field_73087_g, manager.field_73099_h);
        }
    }

    private Marker getNextMarker() {
        ArrayList markers = this.golem.getMarkers();
        markers.sort(Comparator.comparingDouble(this::distanceSquaredToGolem));
        for (Marker marker : markers) {
            if (!this.isValid(marker)) continue;
            return marker;
        }
        return null;
    }

    private double distanceSquaredToGolem(Marker marker) {
        return this.distanceSquaredToGolem(marker.x, marker.y, marker.z, marker.side);
    }

    private double distanceSquaredToGolem(double x, double y, double z, int facing) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
        return this.golem.func_70092_e(x + 0.5 + 0.5 * (double)dir.offsetX, y + 0.5 + 0.5 * (double)dir.offsetY, z + 0.5 + 0.5 * (double)dir.offsetZ);
    }

    private boolean isInHomeRange() {
        ChunkCoordinates home = this.golem.func_110172_bL();
        return this.golem.func_70092_e((double)home.field_71574_a + 0.5, (double)home.field_71572_b + 0.5, (double)home.field_71573_c + 0.5) < 3.0;
    }

    private boolean hasBlock(Marker marker) {
        return marker != null && !this.golem.field_70170_p.func_147437_c(marker.x, marker.y, marker.z);
    }

    private boolean isValid(Marker marker) {
        if (marker == null) {
            return false;
        }
        if (this.blacklist.containsKey(marker)) {
            if (this.blacklist.get(marker) + 800 >= this.golem.field_70173_aa) {
                return false;
            }
            this.blacklist.remove(marker);
        }
        float range = this.golem.getRange();
        if (this.golem.func_110172_bL().func_71569_e(marker.x, marker.y, marker.z) > range * range) {
            return false;
        }
        Block block = this.golem.field_70170_p.func_147439_a(marker.x, marker.y, marker.z);
        if (!block.isAir((IBlockAccess)this.golem.field_70170_p, marker.x, marker.y, marker.z)) {
            ItemStack blockStack = new ItemStack(Item.func_150898_a((Block)block));
            boolean empty = true;
            for (int slot = 0; slot < this.golem.inventory.slotCount; ++slot) {
                ItemStack stack = this.golem.inventory.inventory[slot];
                if (stack == null || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150350_a) continue;
                empty = false;
                if (marker.color != -1 && marker.color != this.golem.colors[slot] || !InventoryUtils.areItemStacksEqual((ItemStack)blockStack, (ItemStack)stack, (boolean)this.golem.checkOreDict(), (boolean)this.golem.ignoreDamage(), (boolean)this.golem.ignoreNBT())) continue;
                return true;
            }
            return empty;
        }
        return false;
    }

    private IInventory getHomeChest() {
        ChunkCoordinates coords = this.golem.func_110172_bL();
        ForgeDirection facing = ForgeDirection.getOrientation((int)this.golem.homeFacing);
        TileEntity tile = this.golem.field_70170_p.func_147438_o(coords.field_71574_a - facing.offsetX, coords.field_71572_b - facing.offsetY, coords.field_71573_c - facing.offsetZ);
        if (tile instanceof IInventory) {
            return (IInventory)tile;
        }
        return null;
    }

    private void trySwitchTool(IInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            ItemStack stack = inv.func_70301_a(slot);
            ItemStack current = this.golem.getCarried();
            if (current != null) {
                if ((current = InventoryUtils.insertStack((IInventory)inv, (ItemStack)current, (int)this.golem.homeFacing, (boolean)true)) != null) {
                    return;
                }
                this.golem.setCarried(null);
                if (this.hasValidTool()) {
                    this.hasValidTool = true;
                    return;
                }
            }
            if (stack == null || !this.isValidTool(stack)) continue;
            stack = stack.func_77946_l();
            stack.field_77994_a = 1;
            if ((stack = InventoryUtils.extractStack((IInventory)inv, (ItemStack)stack, (int)this.golem.homeFacing, (boolean)false, (boolean)false, (boolean)false, (boolean)true)) == null) continue;
            this.golem.setCarried(stack);
            this.golem.updateCarried();
            this.player.setHeldItem(stack);
            this.hasValidTool = true;
            break;
        }
    }

    private boolean hasValidTool() {
        this.hasValidTool = this.isValidTool(this.golem.getCarried());
        return this.hasValidTool;
    }

    private boolean isValidTool(ItemStack tool) {
        if (tool == null || Block.func_149634_a((Item)tool.func_77973_b()) == Blocks.field_150350_a) {
            boolean empty = true;
            for (int slot = 0; slot < this.golem.inventory.slotCount; ++slot) {
                ItemStack stack = this.golem.inventory.inventory[slot];
                if (stack == null || Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150350_a || this.currentMarker != null && this.golem.colors[slot] != -1 && this.currentMarker.color != -1 && this.golem.colors[slot] != this.currentMarker.color) continue;
                empty = false;
                if (tool == null) {
                    return false;
                }
                if (!InventoryUtils.areItemStacksEqual((ItemStack)tool, (ItemStack)stack, (boolean)this.golem.checkOreDict(), (boolean)this.golem.ignoreDamage(), (boolean)this.golem.ignoreNBT())) continue;
                return true;
            }
            return empty && tool == null;
        }
        return false;
    }
}

