/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import makeo.gadomancy.client.events.ClientHandler;
import makeo.gadomancy.common.blocks.tiles.SynchronizedTileEntity;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketAnimationAbsorb;
import makeo.gadomancy.common.registration.RegisteredBlocks;
import makeo.gadomancy.common.registration.RegisteredItems;
import makeo.gadomancy.common.utils.ExplosionHelper;
import makeo.gadomancy.common.utils.Injector;
import makeo.gadomancy.common.utils.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.WorldCoordinates;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.client.fx.ParticleEngine;
import thaumcraft.client.fx.bolt.FXLightningBolt;
import thaumcraft.client.fx.particles.FXEssentiaTrail;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.network.fx.PacketFXEssentiaSource;
import thaumcraft.common.tiles.TilePedestal;
import tuhljin.automagy.api.essentia.IAspectContainerWithMax;
import tuhljin.automagy.api.essentia.IEssentiaLocusReadable;

@Optional.InterfaceList(value={@Optional.Interface(iface="tuhljin.automagy.api.essentia.IEssentiaLocusReadable", modid="Automagy"), @Optional.Interface(iface="tuhljin.automagy.api.essentia.IAspectContainerWithMax", modid="Automagy")})
public class TileEssentiaCompressor
extends SynchronizedTileEntity
implements IEssentiaTransport,
IEssentiaLocusReadable,
IAspectContainerWithMax {
    public static final int MAX_SIZE = 8;
    public static final int MAX_ASPECT_STORAGE = 3000;
    public static final int STD_ASPECT_STORAGE = 200;
    private static Injector injEssentiaHandler = new Injector(EssentiaHandler.class);
    private static int multiblockIDCounter;
    private boolean isMasterTile;
    private int multiblockYIndex = -1;
    private int multiblockId = -1;
    private boolean isMultiblockPresent;
    private int incSize;
    private Vector3 coordPedestal;
    private int consumeTick;
    private AspectList al = new AspectList();
    private int ticksExisted;
    private boolean prevFound;
    float tr = 1.0f;
    float tri;
    float tg = 1.0f;
    float tgi;
    float tb = 1.0f;
    float tbi;
    public float cr = 1.0f;
    public float cg = 1.0f;
    public float cb = 1.0f;
    public Aspect displayAspect;

    public void func_145845_h() {
        super.func_145845_h();
        ++this.ticksExisted;
        if (!this.field_145850_b.field_72995_K) {
            if (this.isMultiblockFormed()) {
                this.checkMultiblock();
            }
            if (!this.isMultiblockFormed()) {
                return;
            }
            if (this.isMasterTile() && (this.prevFound || this.ticksExisted % 100 == 0)) {
                List<WorldCoordinates> coords = this.searchAndGetSources();
                this.prevFound = coords == null || coords.isEmpty() ? false : this.searchForEssentia(coords);
            }
            if (this.isMasterTile() && (this.incSize < 8 && this.ticksExisted % 40 == 0 || this.coordPedestal != null)) {
                this.consumeElements();
            }
        } else if (this.isMasterTile() && this.isMultiblockFormed()) {
            this.playLightningEffects();
            this.playVortexEffects();
            if (this.al.visSize() > 0) {
                this.playEssentiaEffects();
            }
        }
        if (this.isMasterTile() && this.isMultiblockFormed()) {
            this.vortexEntities();
        }
    }

    @Optional.Method(modid="Automagy")
    public AspectList getAspectsBase() {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return null;
            }
            return master.al;
        }
        return this.al;
    }

    private void consumeElements() {
        if (this.coordPedestal != null) {
            if (!this.checkPedestal(this.coordPedestal)) {
                this.consumeTick = 0;
                this.coordPedestal = null;
                return;
            }
            ++this.consumeTick;
            if (this.consumeTick <= 400) {
                PacketAnimationAbsorb absorb = new PacketAnimationAbsorb(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.coordPedestal.getBlockX(), this.coordPedestal.getBlockY() + 1, this.coordPedestal.getBlockZ(), 5, Block.func_149682_b((Block)ConfigBlocks.blockCosmeticSolid), 1);
                PacketHandler.INSTANCE.sendToAllAround((IMessage)absorb, new NetworkRegistry.TargetPoint(this.func_145831_w().field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 16.0));
            } else {
                TilePedestal te = (TilePedestal)this.field_145850_b.func_147438_o(this.coordPedestal.getBlockX(), this.coordPedestal.getBlockY(), this.coordPedestal.getBlockZ());
                te.func_70299_a(0, null);
                te.func_70296_d();
                this.field_145850_b.func_147471_g(this.coordPedestal.getBlockX(), this.coordPedestal.getBlockY(), this.coordPedestal.getBlockZ());
                this.consumeTick = 0;
                this.coordPedestal = null;
                ++this.incSize;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
            }
        } else {
            for (int xx = -3; xx <= 3; ++xx) {
                for (int zz = -3; zz <= 3; ++zz) {
                    Vector3 offset = new Vector3(this.field_145851_c + xx, this.field_145848_d, this.field_145849_e + zz);
                    if (!this.checkPedestal(offset)) continue;
                    this.coordPedestal = offset;
                    this.consumeTick = 0;
                    return;
                }
            }
            this.coordPedestal = null;
            this.consumeTick = 0;
        }
    }

    private boolean checkPedestal(Vector3 coordPedestal) {
        Block at = this.field_145850_b.func_147439_a(coordPedestal.getBlockX(), coordPedestal.getBlockY(), coordPedestal.getBlockZ());
        int md = this.field_145850_b.func_72805_g(coordPedestal.getBlockX(), coordPedestal.getBlockY(), coordPedestal.getBlockZ());
        TileEntity te = this.field_145850_b.func_147438_o(coordPedestal.getBlockX(), coordPedestal.getBlockY(), coordPedestal.getBlockZ());
        if (at == null || te == null || md != 1) {
            return false;
        }
        if (!at.equals((Object)RegisteredBlocks.blockStoneMachine) || !(te instanceof TilePedestal)) {
            return false;
        }
        ItemStack st = ((TilePedestal)te).func_70301_a(0);
        if (st == null || st.func_77973_b() == null) {
            return false;
        }
        return st.func_77973_b().equals((Object)RegisteredItems.itemElement) && st.func_77960_j() == 0;
    }

    private boolean searchForEssentia(List<WorldCoordinates> coordinates) {
        if (this.ticksExisted % 10 != 0) {
            return this.prevFound;
        }
        for (Aspect a : Aspect.aspects.values()) {
            if (!this.doDrain(a, coordinates)) continue;
            this.al.add(a, 1);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
            return true;
        }
        return false;
    }

    private boolean doDrain(Aspect a, List<WorldCoordinates> coordinates) {
        for (WorldCoordinates coordinate : coordinates) {
            IAspectSource as;
            AspectList contains;
            TileEntity sourceTile = this.field_145850_b.func_147438_o(coordinate.x, coordinate.y, coordinate.z);
            if (!(sourceTile instanceof IAspectSource) || sourceTile instanceof TileEssentiaCompressor || (contains = (as = (IAspectSource)sourceTile).getAspects()) == null || contains.visSize() > this.al.visSize() || !this.canAccept(a) || !as.takeFromContainer(a, 1)) continue;
            thaumcraft.common.lib.network.PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketFXEssentiaSource(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, (byte)(this.field_145851_c - coordinate.x), (byte)(this.field_145848_d - coordinate.y + 1), (byte)(this.field_145849_e - coordinate.z), a.getColor()), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)(this.field_145848_d + 1), (double)this.field_145849_e, 32.0));
            return true;
        }
        return false;
    }

    private int currentStorageSize() {
        return 200 + this.incSize * 350;
    }

    private boolean canAccept(Aspect a) {
        int max;
        int current = this.al.getAmount(a);
        return current < (max = this.currentStorageSize());
    }

    public int getSizeStage() {
        return this.incSize;
    }

    @SideOnly(value=Side.CLIENT)
    private void playEssentiaEffects() {
        if (ClientHandler.ticks % 20 == 0 && this.al.size() > 0) {
            this.displayAspect = this.al.getAspects()[ClientHandler.ticks / 20 % this.al.size()];
            Color c = new Color(this.displayAspect.getColor());
            this.tr = (float)c.getRed() / 255.0f;
            this.tg = (float)c.getGreen() / 255.0f;
            this.tb = (float)c.getBlue() / 255.0f;
            this.tri = (this.cr - this.tr) / 20.0f;
            this.tgi = (this.cg - this.tg) / 20.0f;
            this.tbi = (this.cb - this.tb) / 20.0f;
        }
        if (this.displayAspect == null) {
            this.tb = 1.0f;
            this.tg = 1.0f;
            this.tr = 1.0f;
            this.tbi = 0.0f;
            this.tgi = 0.0f;
            this.tri = 0.0f;
        } else {
            this.cr -= this.tri;
            this.cg -= this.tgi;
            this.cb -= this.tbi;
        }
        int count = 1;
        this.cr = Math.min(1.0f, Math.max(0.0f, this.cr));
        this.cg = Math.min(1.0f, Math.max(0.0f, this.cg));
        this.cb = Math.min(1.0f, Math.max(0.0f, this.cb));
        FXEssentiaTrail essentiaTrail = new FXEssentiaTrail(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.4, (double)this.field_145849_e + 0.5, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, count, new Color(this.cr, this.cg, this.cb).getRGB(), 0.8f);
        essentiaTrail.field_70145_X = true;
        essentiaTrail.field_70181_x = 0.01f + MathHelper.func_76126_a((float)((float)count / 3.0f)) * 0.001f;
        essentiaTrail.field_70159_w = (double)(MathHelper.func_76126_a((float)((float)count / 10.0f)) * 0.01f) + this.field_145850_b.field_73012_v.nextGaussian() * 0.01;
        essentiaTrail.field_70179_y = (double)(MathHelper.func_76126_a((float)((float)count / 10.0f)) * 0.01f) + this.field_145850_b.field_73012_v.nextGaussian() * 0.01;
        ParticleEngine.instance.addEffect(this.field_145850_b, (EntityFX)essentiaTrail);
        essentiaTrail = new FXEssentiaTrail(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 2.6, (double)this.field_145849_e + 0.5, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, count, new Color(this.cr, this.cg, this.cb).getRGB(), 0.8f);
        essentiaTrail.field_70145_X = true;
        essentiaTrail.field_70181_x = -(0.01f + MathHelper.func_76126_a((float)((float)count / 3.0f)) * 0.001f);
        essentiaTrail.field_70159_w = (double)(MathHelper.func_76126_a((float)((float)count / 10.0f)) * 0.01f) + this.field_145850_b.field_73012_v.nextGaussian() * 0.01;
        essentiaTrail.field_70179_y = (double)(MathHelper.func_76126_a((float)((float)count / 10.0f)) * 0.01f) + this.field_145850_b.field_73012_v.nextGaussian() * 0.01;
        ParticleEngine.instance.addEffect(this.field_145850_b, (EntityFX)essentiaTrail);
    }

    private List<WorldCoordinates> searchAndGetSources() {
        WorldCoordinates thisCoordinates = new WorldCoordinates((TileEntity)this);
        HashMap<WorldCoordinates, List<WorldCoordinates>> teSources = new HashMap<WorldCoordinates, List<WorldCoordinates>>();
        this.getSourcesField(teSources);
        if (!teSources.containsKey(thisCoordinates)) {
            this.searchSources();
            this.getSourcesField(teSources);
            if (teSources.containsKey(thisCoordinates)) {
                return this.searchAndGetSources();
            }
            return new ArrayList<WorldCoordinates>();
        }
        List result = (List)teSources.get(thisCoordinates);
        ((Map)injEssentiaHandler.getField("sources")).remove(thisCoordinates);
        return result;
    }

    private void searchSources() {
        WorldCoordinates thisCoord = new WorldCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
        LinkedList<WorldCoordinates> coords = new LinkedList<WorldCoordinates>();
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            this.unsafe_search(thisCoord, direction, coords);
        }
        ((Map)injEssentiaHandler.getField("sources")).put(thisCoord, coords);
    }

    private void unsafe_search(WorldCoordinates coord, ForgeDirection direction, List<WorldCoordinates> out) {
        ((HashMap)injEssentiaHandler.getField("sourcesDelay")).remove(coord);
        injEssentiaHandler.invokeMethod("getSources", new Class[]{World.class, WorldCoordinates.class, ForgeDirection.class, Integer.TYPE}, new Object[]{this.field_145850_b, coord, direction, 5});
        List coords = (List)((Map)injEssentiaHandler.getField("sources")).get(coord);
        if (coords != null) {
            out.addAll((Collection)((Map)injEssentiaHandler.getField("sources")).get(coord));
            ((Map)injEssentiaHandler.getField("sources")).remove(coord);
        }
    }

    private void getSourcesField(Map<WorldCoordinates, List<WorldCoordinates>> out) {
        out.clear();
        out.putAll((Map)injEssentiaHandler.getField("sources"));
    }

    private void playVortexEffects() {
        for (int a = 0; a < Thaumcraft.proxy.particleCount(1); ++a) {
            Vec3 v2;
            Vec3 v1;
            MovingObjectPosition mop;
            int tz;
            int tx = this.field_145851_c + this.field_145850_b.field_73012_v.nextInt(4) - this.field_145850_b.field_73012_v.nextInt(4);
            int ty = this.field_145848_d + 1 + this.field_145850_b.field_73012_v.nextInt(4) - this.field_145850_b.field_73012_v.nextInt(4);
            if (ty > this.field_145850_b.func_72976_f(tx, tz = this.field_145849_e + this.field_145850_b.field_73012_v.nextInt(4) - this.field_145850_b.field_73012_v.nextInt(4))) {
                ty = this.field_145850_b.func_72976_f(tx, tz);
            }
            if ((mop = ThaumcraftApiHelper.rayTraceIgnoringSource((World)this.field_145850_b, (Vec3)(v1 = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.5))), (Vec3)(v2 = Vec3.func_72443_a((double)((double)tx + 0.5), (double)((double)ty + 0.5), (double)((double)tz + 0.5))), (boolean)true, (boolean)false, (boolean)false)) == null || !(this.func_145835_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) < 16.0)) continue;
            tx = mop.field_72311_b;
            ty = mop.field_72312_c;
            tz = mop.field_72309_d;
            Block bi = this.field_145850_b.func_147439_a(tx, ty, tz);
            int md = this.field_145850_b.func_72805_g(tx, ty, tz);
            if (bi.isAir((IBlockAccess)this.field_145850_b, tx, ty, tz)) continue;
            Thaumcraft.proxy.hungryNodeFX(this.field_145850_b, tx, ty, tz, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, bi, md);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void playLightningEffects() {
        if (this.incSize < 6 && (this.incSize < 2 ? this.field_145850_b.field_73012_v.nextInt(6) != 0 : this.field_145850_b.field_73012_v.nextBoolean())) {
            return;
        }
        double originX = (double)this.field_145851_c + 0.5;
        double originY = (double)this.field_145848_d + 1.5;
        double originZ = (double)this.field_145849_e + 0.5;
        double targetX = (double)this.field_145851_c + 0.4 + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.2;
        double targetY = (double)this.field_145848_d + 0.4 + (this.field_145850_b.field_73012_v.nextBoolean() ? 2.2 : 0.0);
        double targetZ = (double)this.field_145849_e + 0.4 + (double)this.field_145850_b.field_73012_v.nextFloat() * 0.2;
        FXLightningBolt bolt = new FXLightningBolt((World)Minecraft.func_71410_x().field_71441_e, originX, originY, originZ, targetX, targetY, targetZ, Minecraft.func_71410_x().field_71441_e.field_73012_v.nextLong(), 10, 4.0f, 5);
        bolt.defaultFractal();
        bolt.setType(5);
        bolt.finalizeBolt();
    }

    private void vortexEntities() {
        if (this.incSize <= 0) {
            return;
        }
        List entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)((double)this.field_145848_d - 0.5), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(4.0, 4.0, 4.0));
        for (Object o : entities) {
            if (o == null || !(o instanceof Entity) || ((Entity)o).field_70128_L) continue;
            this.applyMovementVectors((Entity)o);
        }
    }

    private void applyMovementVectors(Entity entity) {
        double mult = (double)this.incSize * 0.125;
        double var3 = ((double)this.field_145851_c + 0.5 - entity.field_70165_t) / 8.0;
        double var5 = ((double)this.field_145848_d + 1.5 - entity.field_70163_u) / 8.0;
        double var7 = ((double)this.field_145849_e + 0.5 - entity.field_70161_v) / 8.0;
        double var9 = Math.sqrt(var3 * var3 + var5 * var5 + var7 * var7);
        double var11 = 1.0 - var9;
        if (var11 > 0.0) {
            var11 *= var11;
            entity.field_70159_w += var3 / var9 * var11 * (0.08 * mult);
            entity.field_70181_x += var5 / var9 * var11 * (0.11 * mult);
            entity.field_70179_y += var7 / var9 * var11 * (0.08 * mult);
        }
    }

    public void checkMultiblock() {
        if (this.isMasterTile) {
            boolean canSustain = this.isMultiblockableBlock(1);
            if (!this.isMultiblockableBlock(2)) {
                canSustain = false;
            }
            if (!canSustain) {
                this.breakMultiblock();
                this.isMultiblockPresent = false;
            }
        } else {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master != null) {
                if (!master.isMultiblockPresent) {
                    this.breakMultiblock();
                }
            } else {
                this.breakMultiblock();
            }
        }
    }

    public TileEssentiaCompressor tryFindMasterTile() {
        if (!this.isMultiblockFormed()) {
            return null;
        }
        if (this.isMasterTile()) {
            return this;
        }
        Block down = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - this.multiblockYIndex, this.field_145849_e);
        if (!down.equals(RegisteredBlocks.blockEssentiaCompressor)) {
            return null;
        }
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.multiblockYIndex, this.field_145849_e);
        if (!(te instanceof TileEssentiaCompressor)) {
            return null;
        }
        TileEssentiaCompressor compressor = (TileEssentiaCompressor)te;
        if (compressor.multiblockId != this.multiblockId || !compressor.isMasterTile()) {
            return null;
        }
        return compressor;
    }

    private boolean isMultiblockableBlock(int yOffset) {
        Block block = this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + yOffset, this.field_145849_e);
        TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + yOffset, this.field_145849_e);
        if (!block.equals(RegisteredBlocks.blockEssentiaCompressor)) {
            return false;
        }
        if (!(te instanceof TileEssentiaCompressor)) {
            return false;
        }
        TileEssentiaCompressor compressor = (TileEssentiaCompressor)te;
        return compressor.multiblockId == this.multiblockId;
    }

    public void breakMultiblock() {
        this.doExplosion();
        this.multiblockId = -1;
        this.isMasterTile = false;
        this.multiblockYIndex = -1;
        this.al = new AspectList();
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void doExplosion() {
        AspectList al = this.getAspects();
        if (al.visSize() > 0) {
            ExplosionHelper.taintplosion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, true, 2, 2.0f, 4, 20);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            ExplosionHelper.taintplosion(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false, 0, 2.0f, 4, 20);
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public static int getAndIncrementNewMultiblockId() {
        return ++multiblockIDCounter;
    }

    public void setInMultiblock(boolean isMaster, int yIndex, int multiblockId) {
        this.multiblockId = multiblockId;
        this.isMasterTile = isMaster;
        this.multiblockYIndex = yIndex;
        if (isMaster) {
            this.isMultiblockPresent = true;
        }
        this.al = new AspectList();
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isMultiblockFormed() {
        return this.multiblockId != -1;
    }

    public boolean isMasterTile() {
        return this.isMasterTile;
    }

    public int getMultiblockYIndex() {
        return this.multiblockYIndex;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.multiblockYIndex = compound.func_74762_e("multiblockYIndex");
        this.isMasterTile = compound.func_74767_n("isMasterTile");
        this.multiblockId = compound.func_74762_e("multiblockId");
        this.isMultiblockPresent = compound.func_74767_n("multiblockPresent");
        this.incSize = compound.func_74762_e("sizeInc");
        AspectList al = new AspectList();
        NBTTagCompound cmp = compound.func_74775_l("aspects");
        for (Object tag : cmp.func_150296_c()) {
            String strTag = (String)tag;
            int amt = cmp.func_74762_e(strTag);
            al.add(Aspect.getAspect((String)strTag), amt);
        }
        this.al = al;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74757_a("isMasterTile", this.isMasterTile);
        compound.func_74768_a("multiblockId", this.multiblockId);
        compound.func_74768_a("multiblockYIndex", this.multiblockYIndex);
        compound.func_74757_a("multiblockPresent", this.isMasterTile);
        compound.func_74768_a("sizeInc", this.incSize);
        NBTTagCompound aspects = new NBTTagCompound();
        for (Aspect a : this.al.aspects.keySet()) {
            aspects.func_74768_a(a.getTag(), ((Integer)this.al.aspects.get(a)).intValue());
        }
        compound.func_74782_a("aspects", (NBTBase)aspects);
    }

    public AspectList getAspects() {
        if (!this.isMultiblockFormed()) {
            return new AspectList();
        }
        if (this.isMasterTile()) {
            return this.al;
        }
        TileEssentiaCompressor master = this.tryFindMasterTile();
        if (master == null) {
            return new AspectList();
        }
        return master.getAspects();
    }

    public void setAspects(AspectList list) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return this.isMultiblockFormed() && this.multiblockYIndex == 1 && this.canAccept(aspect);
    }

    public int addToContainer(Aspect aspect, int i) {
        if (this.doesContainerAccept(aspect) && this.canAccept(aspect)) {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return 0;
            }
            int diff = master.currentStorageSize() - master.al.getAmount(aspect);
            if (diff <= 0) {
                return 0;
            }
            i = master.currentStorageSize() >= master.al.getAmount(aspect) + i ? i : diff;
            master.al.add(aspect, i);
            this.field_145850_b.func_147471_g(master.field_145851_c, master.field_145848_d, master.field_145849_e);
            this.func_70296_d();
            return i;
        }
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return false;
            }
            boolean couldTake = master.al.reduce(aspect, i);
            master.al.remove(aspect, 0);
            this.field_145850_b.func_147471_g(master.field_145851_c, master.field_145848_d, master.field_145849_e);
            this.func_70296_d();
            return couldTake;
        }
        return false;
    }

    @Deprecated
    public boolean takeFromContainer(AspectList list) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return false;
            }
            return master.al.getAmount(aspect) >= i;
        }
        return false;
    }

    @Deprecated
    public boolean doesContainerContain(AspectList list) {
        return false;
    }

    public int containerContains(Aspect aspect) {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return 0;
            }
            return master.al.getAmount(aspect);
        }
        return 0;
    }

    public boolean isConnectable(ForgeDirection direction) {
        return false;
    }

    public boolean canInputFrom(ForgeDirection direction) {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            return direction == ForgeDirection.SOUTH || direction == ForgeDirection.NORTH || direction == ForgeDirection.EAST || direction == ForgeDirection.WEST;
        }
        return false;
    }

    public boolean canOutputTo(ForgeDirection direction) {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            return direction == ForgeDirection.SOUTH || direction == ForgeDirection.NORTH || direction == ForgeDirection.EAST || direction == ForgeDirection.WEST;
        }
        return false;
    }

    public void setSuction(Aspect aspect, int i) {
    }

    public Aspect getSuctionType(ForgeDirection direction) {
        return null;
    }

    public int getSuctionAmount(ForgeDirection direction) {
        if (this.canInputFrom(direction)) {
            return 16;
        }
        return 0;
    }

    public int takeEssentia(Aspect aspect, int i, ForgeDirection direction) {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            if (!this.canOutputTo(direction)) {
                return 0;
            }
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return 0;
            }
            int amt = master.al.getAmount(aspect);
            int taken = amt - master.al.remove(aspect, i).getAmount(aspect);
            this.field_145850_b.func_147471_g(master.field_145851_c, master.field_145848_d, master.field_145849_e);
            this.func_70296_d();
            return taken;
        }
        return 0;
    }

    public int addEssentia(Aspect aspect, int i, ForgeDirection direction) {
        if (this.canInputFrom(direction) && this.canAccept(aspect)) {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return 0;
            }
            int diff = master.currentStorageSize() - master.al.getAmount(aspect);
            if (diff <= 0) {
                return 0;
            }
            i = master.currentStorageSize() >= master.al.getAmount(aspect) + i ? i : diff;
            master.al.add(aspect, i);
            this.field_145850_b.func_147471_g(master.field_145851_c, master.field_145848_d, master.field_145849_e);
            this.func_70296_d();
            return i;
        }
        return 0;
    }

    public Aspect getEssentiaType(ForgeDirection direction) {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return null;
            }
            return (Aspect)new ArrayList(master.al.aspects.keySet()).get(this.field_145850_b.field_73012_v.nextInt(master.al.size()));
        }
        return null;
    }

    public int getEssentiaAmount(ForgeDirection direction) {
        if (this.isMultiblockFormed() && this.multiblockYIndex == 1) {
            TileEssentiaCompressor master = this.tryFindMasterTile();
            if (master == null) {
                return 0;
            }
            return master.al.visSize();
        }
        return 0;
    }

    public int getMinimumSuction() {
        return 0;
    }

    public boolean renderExtendedTube() {
        return false;
    }
}

