/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.itemfinder;

import com.gtnh.findit.service.blockfinder.BlockFoundResponse;
import com.gtnh.findit.service.itemfinder.ClientItemFindService;
import com.gtnh.findit.util.ProtoUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class HighlightSlotsPacket
implements IMessage {
    private int windowId;
    private ItemStack targetStack;
    private List<Integer> targetSlots;

    public HighlightSlotsPacket(int windowId, ItemStack targetStack, List<Integer> targetSlots) {
        this.windowId = windowId;
        this.targetStack = targetStack;
        this.targetSlots = targetSlots;
    }

    public HighlightSlotsPacket() {
    }

    public void fromBytes(ByteBuf buf) {
        this.windowId = buf.readInt();
        this.targetStack = ProtoUtils.readItemStack(buf);
        int slotCount = buf.readInt();
        this.targetSlots = new ArrayList<Integer>(slotCount);
        for (int i = 0; i < slotCount; ++i) {
            this.targetSlots.add(Integer.valueOf(buf.readShort()));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.windowId);
        ProtoUtils.writeItemStack(buf, this.targetStack);
        buf.writeInt(this.targetSlots.size());
        this.targetSlots.forEach(arg_0 -> ((ByteBuf)buf).writeShort(arg_0));
    }

    public int getWindowId() {
        return this.windowId;
    }

    public ItemStack getTargetStack() {
        return this.targetStack;
    }

    public List<Integer> getTargetSlots() {
        return this.targetSlots;
    }

    public static class Handler
    implements IMessageHandler<HighlightSlotsPacket, BlockFoundResponse> {
        public BlockFoundResponse onMessage(HighlightSlotsPacket message, MessageContext ctx) {
            if (message.getTargetStack() != null) {
                ClientItemFindService.getInstance().handleSlotHighlight(message);
            }
            return null;
        }
    }
}

