/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.texture;

import cpw.mods.fml.client.FMLClientHandler;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.util.ResourceLocation;

public abstract class TextureDerived
extends TextureAtlasSprite {
    private final String baseIcon;
    private final String basePath;
    private final TextureMapType type;
    public static DirectColorModel rgbBase = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
    protected DirectColorModel rgb = rgbBase;

    public TextureDerived(String p_i1282_1_, String baseIcon, TextureMapType type) {
        super(p_i1282_1_);
        this.baseIcon = baseIcon;
        this.type = type;
        this.basePath = type.basePath;
    }

    public int getLuminosity(int col) {
        return this.getLuminosity(this.rgb.getRed(col), this.rgb.getGreen(col), this.rgb.getBlue(col));
    }

    public int getLuminosity(int r, int g, int b) {
        return (int)((float)r * 0.2126f + (float)g * 0.7152f + (float)b * 0.0722f);
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public abstract BufferedImage processImage(BufferedImage var1, AnimationMetadataSection var2);

    public boolean load(IResourceManager manager, ResourceLocation oldlocation) {
        ResourceLocation location = new ResourceLocation(this.baseIcon);
        location = this.completeResourceLocation(location);
        try {
            int mipmapLevels = Minecraft.func_71410_x().field_71474_y.field_151442_I;
            int anisotropicFiltering = Minecraft.func_71410_x().field_71474_y.field_151443_J;
            IResource iresource = manager.func_110536_a(location);
            BufferedImage[] abufferedimage = new BufferedImage[1 + mipmapLevels];
            abufferedimage[0] = ImageIO.read(iresource.func_110527_b());
            AnimationMetadataSection animationmetadatasection = (AnimationMetadataSection)iresource.func_110526_a("animation");
            abufferedimage[0] = this.processImage(abufferedimage[0], animationmetadatasection);
            this.func_147964_a(abufferedimage, animationmetadatasection, (float)anisotropicFiltering > 1.0f);
        }
        catch (RuntimeException runtimeexception) {
            FMLClientHandler.instance().trackBrokenTexture(location, runtimeexception.getMessage());
            return true;
        }
        catch (IOException ioexception1) {
            FMLClientHandler.instance().trackMissingTexture(location);
            return true;
        }
        return false;
    }

    private ResourceLocation completeResourceLocation(ResourceLocation p_147634_1_) {
        return new ResourceLocation(p_147634_1_.func_110624_b(), String.format("%s/%s%s", this.basePath, p_147634_1_.func_110623_a(), ".png"));
    }

    public static enum TextureMapType {
        BLOCK(0, "textures/blocks"),
        ITEM(1, "textures/items");

        public final int textureMapType;
        public final String basePath;

        private TextureMapType(int textureMapType, String basePath) {
            this.textureMapType = textureMapType;
            this.basePath = basePath;
        }
    }
}

