/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.google.common.base.Throwables;
import com.google.common.collect.ObjectArrays;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import org.apache.logging.log4j.Level;

public class EnderRegistryUtils {
    private static Method getMain;
    private static Method registerItem;
    private static Method registerBlock;

    public static void registerItem(Item item, String modid, String name) {
        try {
            registerItem.invoke(getMain.invoke(null, new Object[0]), item, modid + ":" + name, -1);
        }
        catch (Exception e) {
            Throwables.propagate((Throwable)e);
        }
    }

    public static void registerBlock(Block block, String modid, String name) {
        EnderRegistryUtils.registerBlock(block, null, modid, name, new Object[0]);
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemclass, String modid, String name, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning((String)"The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", (Object[])new Object[]{Loader.instance().activeModContainer()});
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            ItemBlock i = null;
            if (itemclass != null) {
                Class[] ctorArgClasses = new Class[itemCtorArgs.length + 1];
                ctorArgClasses[0] = Block.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = itemCtorArgs[idx - 1].getClass();
                }
                Constructor<? extends ItemBlock> itemCtor = itemclass.getConstructor(ctorArgClasses);
                i = itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            registerBlock.invoke(getMain.invoke(null, new Object[0]), block, modid + ":" + name, -1);
            if (i != null) {
                EnderRegistryUtils.registerItem((Item)i, modid, name);
            }
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Caught an exception during block registration", (Object[])new Object[0]);
            throw new LoaderException((Throwable)e);
        }
    }

    static {
        try {
            getMain = GameData.class.getDeclaredMethod("getMain", new Class[0]);
            getMain.setAccessible(true);
            registerItem = GameData.class.getDeclaredMethod("registerItem", Item.class, String.class, Integer.TYPE);
            registerItem.setAccessible(true);
            registerBlock = GameData.class.getDeclaredMethod("registerBlock", Block.class, String.class, Integer.TYPE);
            registerBlock.setAccessible(true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

