/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.client.gui.widget;

import com.enderio.core.api.client.gui.IHideable;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

public class GuiToolTip
implements IHideable {
    private static final long DELAY = 0L;
    protected Rectangle bounds;
    private long mouseOverStart;
    protected final List<String> text;
    private int lastMouseX = -1;
    private int lastMouseY = -1;
    private boolean visible = true;

    public GuiToolTip(Rectangle bounds, String ... lines) {
        this.bounds = bounds;
        if (lines != null) {
            this.text = new ArrayList<String>(lines.length);
            for (String line : lines) {
                this.text.add(line);
            }
        } else {
            this.text = new ArrayList<String>();
        }
    }

    public GuiToolTip(Rectangle bounds, List<String> lines) {
        this.bounds = bounds;
        this.text = lines == null ? new ArrayList<String>() : new ArrayList<String>(lines);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.bounds = bounds;
    }

    public void onTick(int mouseX, int mouseY) {
        if (this.lastMouseX != mouseX || this.lastMouseY != mouseY) {
            this.mouseOverStart = 0L;
        }
        if (this.bounds.contains(mouseX, mouseY)) {
            if (this.mouseOverStart == 0L) {
                this.mouseOverStart = System.currentTimeMillis();
            }
        } else {
            this.mouseOverStart = 0L;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    public boolean shouldDraw() {
        if (!this.visible) {
            return false;
        }
        this.updateText();
        if (this.mouseOverStart == 0L) {
            return false;
        }
        return System.currentTimeMillis() - this.mouseOverStart >= 0L;
    }

    protected void updateText() {
    }

    public void setToolTipText(String ... txt) {
        this.text.clear();
        if (txt != null) {
            for (String line : txt) {
                this.text.add(line);
            }
        }
    }

    public List<String> getToolTipText() {
        return this.text;
    }
}

