/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.render;

import com.caedis.duradisplay.config.DuraDisplayConfig;
import net.minecraft.client.gui.FontRenderer;
import org.lwjgl.opengl.GL11;

public abstract class ItemStackOverlay {
    public boolean isFull;
    public int color;
    public String value;

    public abstract int getColor();

    public abstract int getLocation();

    public void Render(FontRenderer fontRenderer, int xPosition, int yPosition, float zLevel) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(zLevel + 1000.0f));
        GL11.glBlendFunc((int)770, (int)771);
        int stringWidth = fontRenderer.func_78256_a(this.value);
        int x = this.getX(xPosition, stringWidth);
        int y = this.getY(yPosition);
        fontRenderer.func_78276_b(this.value, x + 1, y, 0);
        fontRenderer.func_78276_b(this.value, x - 1, y, 0);
        fontRenderer.func_78276_b(this.value, x, y + 1, 0);
        fontRenderer.func_78276_b(this.value, x, y - 1, 0);
        fontRenderer.func_78276_b(this.value, x, y, this.getColor());
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2929);
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        GL11.glPopMatrix();
    }

    private int getX(int xPosition, int stringWidth) {
        switch (this.getLocation()) {
            case 1: 
            case 4: 
            case 7: {
                return xPosition * 2 + 2;
            }
            default: {
                return (xPosition + 8) * 2 + 1 + stringWidth / 2 - stringWidth;
            }
            case 3: 
            case 6: 
            case 9: 
        }
        return (xPosition + 20) * 2 - stringWidth - 10;
    }

    private int getY(int yPosition) {
        switch (this.getLocation()) {
            case 7: 
            case 8: 
            case 9: {
                return yPosition * 2 + 2;
            }
            case 4: 
            case 5: 
            case 6: {
                return yPosition * 2 + 11;
            }
        }
        return yPosition * 2 + 22;
    }

    public static class ChargeOverlay
    extends ItemStackOverlay {
        @Override
        public void Render(FontRenderer fontRenderer, int xPosition, int yPosition, float zLevel) {
            if (!DuraDisplayConfig.ChargeConfig.ShowWhenFull && this.isFull) {
                return;
            }
            super.Render(fontRenderer, xPosition, yPosition, zLevel);
        }

        @Override
        public int getColor() {
            return -11141121;
        }

        @Override
        public int getLocation() {
            return DuraDisplayConfig.ChargeConfig.Position;
        }
    }

    public static class DurabilityOverlay
    extends ItemStackOverlay {
        @Override
        public void Render(FontRenderer fontRenderer, int xPosition, int yPosition, float zLevel) {
            if (!DuraDisplayConfig.DurabilityConfig.ShowWhenFull && this.isFull) {
                return;
            }
            super.Render(fontRenderer, xPosition, yPosition, zLevel);
        }

        @Override
        public int getColor() {
            return this.color;
        }

        @Override
        public int getLocation() {
            return DuraDisplayConfig.DurabilityConfig.Position;
        }
    }
}

