/*
 * Decompiled with CFR 0.152.
 */
package com.caedis.duradisplay.render;

import cofh.api.energy.IEnergyContainerItem;
import com.caedis.duradisplay.config.DuraDisplayConfig;
import com.caedis.duradisplay.render.ItemStackOverlay;
import com.caedis.duradisplay.utils.GTToolsInfo;
import com.caedis.duradisplay.utils.NBTUtils;
import crazypants.enderio.item.darksteel.IDarkSteelItem;
import gregtech.api.items.GT_MetaBase_Item;
import gregtech.api.items.GT_RadioactiveCell_Item;
import ic2.api.item.ElectricItem;
import ic2.api.item.ICustomDamageItem;
import ic2.api.item.IElectricItem;
import ic2.core.item.armor.ItemArmorFluidTank;
import java.awt.Color;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.weaponry.AmmoItem;
import vazkii.botania.common.item.brew.ItemBrewBase;

public class DurabilityRenderer {
    public static boolean Execute = true;
    private static final Map<Class<?>, ItemHandler> itemHandlers = new LinkedHashMap();
    private static final NumberFormat nf = NumberFormat.getNumberInstance();

    public static void Render(FontRenderer fontRenderer, ItemStack stack, int xPosition, int yPosition, float zLevel) {
        if (fontRenderer == null && (fontRenderer = Minecraft.func_71410_x().field_71466_p) == null) {
            return;
        }
        assert (stack.func_77973_b() != null);
        ItemStackOverlay.DurabilityOverlay durabilityOverlay = null;
        ItemStackOverlay.ChargeOverlay chargeOverlay = null;
        Optional<Class> key = itemHandlers.keySet().stream().filter(clazz -> clazz.isInstance(stack.func_77973_b())).findFirst();
        if (!key.isPresent()) {
            return;
        }
        List<ItemStackOverlay> list = itemHandlers.get(key.get()).apply(stack);
        if (list != null) {
            for (ItemStackOverlay overlay : list) {
                ItemStackOverlay.ChargeOverlay cOverlay;
                if (overlay instanceof ItemStackOverlay.DurabilityOverlay) {
                    ItemStackOverlay.DurabilityOverlay dOverlay;
                    durabilityOverlay = dOverlay = (ItemStackOverlay.DurabilityOverlay)overlay;
                    continue;
                }
                if (!(overlay instanceof ItemStackOverlay.ChargeOverlay)) continue;
                chargeOverlay = cOverlay = (ItemStackOverlay.ChargeOverlay)overlay;
            }
        }
        if (durabilityOverlay != null) {
            durabilityOverlay.Render(fontRenderer, xPosition, yPosition, zLevel);
        }
        if (chargeOverlay != null) {
            chargeOverlay.Render(fontRenderer, xPosition, yPosition, zLevel);
        }
    }

    public static int getRGBDurabilityForDisplay(double dur) {
        if (!DuraDisplayConfig.DurabilityConfig.UseColorThreshold) {
            return Color.HSBtoRGB(Math.max(0.0f, (float)dur) / 3.0f, 1.0f, 1.0f);
        }
        double durability = dur * 100.0;
        if (durability <= DuraDisplayConfig.DurabilityConfig.ColorThreshold[0]) {
            return 0xFF0000;
        }
        if (durability >= DuraDisplayConfig.DurabilityConfig.ColorThreshold[DuraDisplayConfig.DurabilityConfig.ColorThreshold.length - 1]) {
            return 0x55FF00;
        }
        return 16766208;
    }

    private static List<ItemStackOverlay> handleDefault(@NotNull ItemStack stack) {
        Item item = stack.func_77973_b();
        assert (item != null);
        if (!DuraDisplayConfig.DurabilityConfig.Enabled || !item.func_77645_m() || !DuraDisplayConfig.DurabilityConfig.ShowWhenFull && !item.isDamaged(stack)) {
            return null;
        }
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        ItemStackOverlay.DurabilityOverlay durabilityOverlay = new ItemStackOverlay.DurabilityOverlay();
        double durability = 1.0 - item.getDurabilityForDisplay(stack);
        if (Double.isNaN(durability)) {
            return null;
        }
        durabilityOverlay.color = DurabilityRenderer.getRGBDurabilityForDisplay(durability);
        durabilityOverlay.isFull = (durability *= 100.0) == 100.0;
        durabilityOverlay.value = nf.format(durability) + "%";
        overlays.add(durabilityOverlay);
        return overlays;
    }

    private static List<ItemStackOverlay> handleGregTech(@NotNull ItemStack stack) {
        Long[] elecStats;
        if (!stack.func_77942_o()) {
            return null;
        }
        GT_MetaBase_Item gtItem = (GT_MetaBase_Item)stack.func_77973_b();
        assert (gtItem != null);
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        if (DuraDisplayConfig.ChargeConfig.Enabled && (elecStats = gtItem.getElectricStats(stack)) != null) {
            ItemStackOverlay.ChargeOverlay chargeOverlay = new ItemStackOverlay.ChargeOverlay();
            double charge = (double)gtItem.getRealCharge(stack) / (double)Math.abs(elecStats[0]) * 100.0;
            if (!Double.isNaN(charge)) {
                chargeOverlay.isFull = charge == 100.0;
                chargeOverlay.value = nf.format(charge) + "%";
                overlays.add(chargeOverlay);
            }
        }
        if (DuraDisplayConfig.DurabilityConfig.Enabled) {
            ItemStackOverlay.DurabilityOverlay durabilityOverlay = new ItemStackOverlay.DurabilityOverlay();
            GTToolsInfo gti = NBTUtils.getToolInfo(stack);
            if (gti.getRemainingPaint() > 0L) {
                durabilityOverlay.color = 0xFFFFFF;
                durabilityOverlay.value = nf.format(gti.getRemainingPaint());
                durabilityOverlay.isFull = (double)gti.getRemainingPaint() / (double)gti.getMaxPaint() == 100.0;
                overlays.add(durabilityOverlay);
            } else if (gti.getMaxDamage() > 0L) {
                double durability = 1.0 - (double)gti.getDamage() / (double)gti.getMaxDamage();
                if (Double.isNaN(durability)) {
                    return null;
                }
                durabilityOverlay.color = DurabilityRenderer.getRGBDurabilityForDisplay(durability);
                durabilityOverlay.isFull = (durability *= 100.0) == 100.0;
                durabilityOverlay.value = nf.format(durability) + "%";
                overlays.add(durabilityOverlay);
            }
        }
        return overlays;
    }

    private static List<ItemStackOverlay> handleToolCore(@NotNull ItemStack stack) {
        List<ItemStackOverlay> defaultOverlays;
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("InfiTool")) {
            return null;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        if (tags.func_74764_b("Unbreaking") && tags.func_74762_e("Unbreaking") < 10 && (defaultOverlays = DurabilityRenderer.handleDefault(stack)) != null) {
            overlays.addAll(defaultOverlays);
        }
        if (!DuraDisplayConfig.ChargeConfig.Enabled || !stack.func_77978_p().func_74764_b("Energy")) {
            return overlays;
        }
        IEnergyContainerItem eci = (IEnergyContainerItem)stack.func_77973_b();
        assert (eci != null);
        ItemStackOverlay.ChargeOverlay chargeOverlay = new ItemStackOverlay.ChargeOverlay();
        double durability = (double)eci.getEnergyStored(stack) / (double)eci.getMaxEnergyStored(stack) * 100.0;
        if (Double.isNaN(durability)) {
            return null;
        }
        chargeOverlay.isFull = durability == 100.0;
        chargeOverlay.value = nf.format(durability) + "%";
        overlays.add(chargeOverlay);
        return overlays;
    }

    private static List<ItemStackOverlay> handleGregTechRadioactiveCell(@NotNull ItemStack stack) {
        if (!DuraDisplayConfig.DurabilityConfig.Enabled) {
            return null;
        }
        GT_RadioactiveCell_Item bei = (GT_RadioactiveCell_Item)stack.func_77973_b();
        assert (bei != null);
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        ItemStackOverlay.DurabilityOverlay overlay = new ItemStackOverlay.DurabilityOverlay();
        double charge = 1.0 - (double)bei.getDamageOfStack(stack) / (double)bei.getMaxDamageEx();
        if (Double.isNaN(charge)) {
            return null;
        }
        overlay.color = DurabilityRenderer.getRGBDurabilityForDisplay(charge);
        overlay.isFull = (charge *= 100.0) == 0.0;
        overlay.value = nf.format(charge) + "%";
        overlays.add(overlay);
        return overlays;
    }

    private static List<ItemStackOverlay> handleIElectricItem(@NotNull ItemStack stack) {
        if (!DuraDisplayConfig.ChargeConfig.Enabled) {
            return null;
        }
        IElectricItem bei = (IElectricItem)stack.func_77973_b();
        assert (bei != null);
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        ItemStackOverlay.ChargeOverlay chargeOverlay = new ItemStackOverlay.ChargeOverlay();
        double charge = ElectricItem.manager.getCharge(stack) / bei.getMaxCharge(stack) * 100.0;
        if (Double.isNaN(charge)) {
            return null;
        }
        chargeOverlay.isFull = charge == 100.0;
        chargeOverlay.value = nf.format(charge) + "%";
        overlays.add(chargeOverlay);
        return overlays;
    }

    private static List<ItemStackOverlay> handleItemArmorFluidTank(@NotNull ItemStack stack) {
        if (!DuraDisplayConfig.DurabilityConfig.Enabled) {
            return null;
        }
        ItemArmorFluidTank bei = (ItemArmorFluidTank)stack.func_77973_b();
        assert (bei != null);
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        ItemStackOverlay.DurabilityOverlay overlay = new ItemStackOverlay.DurabilityOverlay();
        double charge = bei.getCharge(stack) / bei.getMaxCharge(stack);
        if (Double.isNaN(charge)) {
            return null;
        }
        overlay.color = DurabilityRenderer.getRGBDurabilityForDisplay(charge);
        overlay.isFull = (charge *= 100.0) == 100.0;
        overlay.value = nf.format(charge) + "%";
        overlays.add(overlay);
        return overlays;
    }

    private static List<ItemStackOverlay> handleICustomDamageItem(@NotNull ItemStack stack) {
        if (!DuraDisplayConfig.DurabilityConfig.Enabled) {
            return null;
        }
        ICustomDamageItem bei = (ICustomDamageItem)stack.func_77973_b();
        assert (bei != null);
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        ItemStackOverlay.DurabilityOverlay overlay = new ItemStackOverlay.DurabilityOverlay();
        double charge = 1.0 - (double)bei.getCustomDamage(stack) / (double)bei.getMaxCustomDamage(stack);
        if (Double.isNaN(charge)) {
            return null;
        }
        overlay.color = DurabilityRenderer.getRGBDurabilityForDisplay(charge);
        overlay.isFull = (charge *= 100.0) == 0.0;
        overlay.value = nf.format(charge) + "%";
        overlays.add(overlay);
        return overlays;
    }

    private static List<ItemStackOverlay> handleBotaniaBrew(@NotNull ItemStack stack) {
        if (!DuraDisplayConfig.DurabilityConfig.Enabled) {
            return null;
        }
        ItemBrewBase brew = (ItemBrewBase)stack.func_77973_b();
        assert (brew != null);
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        ItemStackOverlay.DurabilityOverlay dOverlay = new ItemStackOverlay.DurabilityOverlay();
        double swigs = brew.getSwigsLeft(stack);
        dOverlay.isFull = swigs == (double)brew.func_77612_l();
        dOverlay.value = nf.format(swigs);
        dOverlay.color = 0xFFFFFF;
        overlays.add(dOverlay);
        return overlays;
    }

    private static List<ItemStackOverlay> handleEnergyContainer(@NotNull ItemStack stack) {
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        List<ItemStackOverlay> defaultOverlays = DurabilityRenderer.handleDefault(stack);
        if (defaultOverlays != null) {
            overlays.addAll(defaultOverlays);
        }
        if (!DuraDisplayConfig.ChargeConfig.Enabled) {
            return overlays;
        }
        IEnergyContainerItem eci = (IEnergyContainerItem)stack.func_77973_b();
        assert (eci != null);
        ItemStackOverlay.ChargeOverlay chargeOverlay = new ItemStackOverlay.ChargeOverlay();
        double durability = (double)eci.getEnergyStored(stack) / (double)eci.getMaxEnergyStored(stack) * 100.0;
        if (Double.isNaN(durability)) {
            return overlays;
        }
        chargeOverlay.isFull = durability == 100.0;
        chargeOverlay.value = nf.format(durability) + "%";
        overlays.add(chargeOverlay);
        return overlays;
    }

    private static List<ItemStackOverlay> handleDarkSteelItems(@NotNull ItemStack stack) {
        Item item = stack.func_77973_b();
        assert (item != null);
        ArrayList<ItemStackOverlay> overlays = new ArrayList<ItemStackOverlay>();
        if (DuraDisplayConfig.DurabilityConfig.Enabled && (!DuraDisplayConfig.DurabilityConfig.ShowWhenFull || stack.func_77960_j() != stack.func_77958_k())) {
            ItemStackOverlay.DurabilityOverlay durabilityOverlay = new ItemStackOverlay.DurabilityOverlay();
            double durability = 1.0 - item.getDurabilityForDisplay(stack);
            if (Double.isNaN(durability)) {
                return null;
            }
            durabilityOverlay.color = DurabilityRenderer.getRGBDurabilityForDisplay(durability);
            durabilityOverlay.isFull = (durability *= 100.0) == 100.0;
            durabilityOverlay.value = nf.format(durability) + "%";
            overlays.add(durabilityOverlay);
        }
        if (!DuraDisplayConfig.ChargeConfig.Enabled || !stack.func_77942_o()) {
            return overlays;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt.func_74764_b("enderio.darksteel.upgrade.energyUpgrade")) {
            NBTTagCompound upgrade = nbt.func_74775_l("enderio.darksteel.upgrade.energyUpgrade");
            int capacity = upgrade.func_74762_e("capacity");
            int energy = upgrade.func_74762_e("energy");
            ItemStackOverlay.ChargeOverlay chargeOverlay = new ItemStackOverlay.ChargeOverlay();
            double durability = (double)energy / (double)capacity * 100.0;
            if (Double.isNaN(durability)) {
                return overlays;
            }
            chargeOverlay.isFull = durability == 100.0;
            chargeOverlay.value = nf.format(durability) + "%";
            overlays.add(chargeOverlay);
        }
        return overlays;
    }

    static {
        nf.setRoundingMode(RoundingMode.FLOOR);
        nf.setMaximumFractionDigits(0);
        itemHandlers.put(GT_MetaBase_Item.class, DurabilityRenderer::handleGregTech);
        itemHandlers.put(GT_RadioactiveCell_Item.class, DurabilityRenderer::handleGregTechRadioactiveCell);
        itemHandlers.put(IDarkSteelItem.class, DurabilityRenderer::handleDarkSteelItems);
        itemHandlers.put(AmmoItem.class, is -> null);
        itemHandlers.put(ToolCore.class, DurabilityRenderer::handleToolCore);
        itemHandlers.put(IElectricItem.class, DurabilityRenderer::handleIElectricItem);
        itemHandlers.put(ItemArmorFluidTank.class, DurabilityRenderer::handleItemArmorFluidTank);
        itemHandlers.put(IEnergyContainerItem.class, DurabilityRenderer::handleEnergyContainer);
        itemHandlers.put(ICustomDamageItem.class, DurabilityRenderer::handleICustomDamageItem);
        itemHandlers.put(ItemBrewBase.class, DurabilityRenderer::handleBotaniaBrew);
        itemHandlers.put(Item.class, DurabilityRenderer::handleDefault);
    }

    @FunctionalInterface
    static interface ItemHandler {
        public List<ItemStackOverlay> apply(ItemStack var1);
    }
}

