/*
 * Decompiled with CFR 0.152.
 */
package com.thecodewarrior.catwalks.util;

import com.thecodewarrior.catwalks.CatwalkMod;
import com.thecodewarrior.catwalks.particle.ParticleCustom;
import com.thecodewarrior.catwalks.render.CatwalkRenderer;
import com.thecodewarrior.catwalks.render.InAndOutRenderer;
import com.thecodewarrior.catwalks.render.LadderRenderer;
import com.thecodewarrior.catwalks.render.SupportRenderer;
import com.thecodewarrior.catwalks.util.CatwalkUtil;
import com.thecodewarrior.catwalks.util.CommonProxy;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class ClientProxy
extends CommonProxy {
    public boolean isBottomOpen = false;
    public ISimpleBlockRenderingHandler catwalkRenderer;
    public ISimpleBlockRenderingHandler ladderRenderer;
    public ISimpleBlockRenderingHandler inAndOutRenderer;
    public ISimpleBlockRenderingHandler supportRenderer;
    boolean debug = true;
    List<String> headers = new ArrayList<String>();
    int headerWidth = 0;
    double maxSpeed = 0.0;

    @Override
    public void spawnCustomParticle(String name, World world, double x, double y, double z) {
        if (!world.field_72995_K) {
            return;
        }
        int index = 0;
        if (name.equals("hitAnother")) {
            index = 0;
        }
        if (name.equals("cantExtend")) {
            index = 3;
        }
        ParticleCustom particle = new ParticleCustom(index, world, x, y, z, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
    }

    @Override
    public void initClient() {
        this.isClient = true;
        this.catwalkRenderer = new CatwalkRenderer();
        RenderingRegistry.registerBlockHandler((int)CatwalkMod.catwalkRenderType, (ISimpleBlockRenderingHandler)this.catwalkRenderer);
        this.ladderRenderer = new LadderRenderer();
        RenderingRegistry.registerBlockHandler((int)CatwalkMod.ladderRenderType, (ISimpleBlockRenderingHandler)this.ladderRenderer);
        this.inAndOutRenderer = new InAndOutRenderer(CatwalkMod.inAndOutRenderType);
        RenderingRegistry.registerBlockHandler((int)CatwalkMod.inAndOutRenderType, (ISimpleBlockRenderingHandler)this.inAndOutRenderer);
        this.supportRenderer = new SupportRenderer(CatwalkMod.supportRenderType);
        RenderingRegistry.registerBlockHandler((int)CatwalkMod.supportRenderType, (ISimpleBlockRenderingHandler)this.supportRenderer);
        this.headers.add("m/t:");
        this.headers.add("m/s:");
        this.headers.add("m/t max:");
        this.headers.add("m/s max:");
        for (int i = 0; i < 5; ++i) {
            this.headers.add("_" + i + ":");
        }
    }

    @Override
    public void postInit() {
        for (String head : this.headers) {
            this.headerWidth = Math.max(Minecraft.func_71410_x().field_71466_p.func_78256_a(head), this.headerWidth);
        }
    }

    @Override
    public EntityPlayer getPlayerLooking(Vec3 start, Vec3 end) {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (!CatwalkUtil.isDev()) {
            return;
        }
        if (event.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().field_71474_y.field_74330_P && Minecraft.func_71410_x().field_71462_r == null) {
            double dZ;
            double dY;
            EntityClientPlayerMP p = Minecraft.func_71410_x().field_71439_g;
            if (p == null) {
                return;
            }
            double dX = Math.abs(p.field_70142_S - p.field_70165_t);
            double speed = Math.sqrt(dX * dX + (dY = Math.abs(p.field_70137_T - p.field_70163_u)) * dY + (dZ = Math.abs(p.field_70136_U - p.field_70161_v)) * dZ);
            if (speed > this.maxSpeed) {
                this.maxSpeed = speed;
            }
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            ArrayList<String> data = new ArrayList<String>();
            int precision = 5;
            String f = "%2." + precision + "f";
            data.add(String.format(f, speed));
            data.add(String.format(f, speed * 20.0));
            data.add(String.format(f, this.maxSpeed));
            data.add(String.format(f, this.maxSpeed * 20.0));
            int lineNum = 0;
            for (String head : this.headers) {
                fr.func_78261_a(head, 5 + this.headerWidth - fr.func_78256_a(head), this.linePos(lineNum), 0xFFFFFF);
                ++lineNum;
            }
            lineNum = 0;
            for (String dat : data) {
                fr.func_78261_a(dat, 8 + this.headerWidth, this.linePos(lineNum), 0xFFFFFF);
                ++lineNum;
            }
        }
    }

    public int linePos(int line) {
        return 5 + (Minecraft.func_71410_x().field_71466_p.field_78288_b + 1) * line;
    }
}

