/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.ISerializable;
import buildcraft.api.core.IZone;
import buildcraft.core.ChunkIndex;
import buildcraft.robotics.ZoneChunk;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ZonePlan
implements IZone,
ISerializable {
    private final HashMap<ChunkIndex, ZoneChunk> chunkMapping = new HashMap();

    public boolean get(int x, int z) {
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        ChunkIndex chunkId = new ChunkIndex(xChunk, zChunk);
        if (!this.chunkMapping.containsKey(chunkId)) {
            return false;
        }
        ZoneChunk property = this.chunkMapping.get(chunkId);
        return property.get(x & 0xF, z & 0xF);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(int x, int z, boolean val) {
        ZoneChunk property;
        int xChunk = x >> 4;
        int zChunk = z >> 4;
        ChunkIndex chunkId = new ChunkIndex(xChunk, zChunk);
        if (!this.chunkMapping.containsKey(chunkId)) {
            if (!val) return;
            property = new ZoneChunk();
            this.chunkMapping.put(chunkId, property);
        } else {
            property = this.chunkMapping.get(chunkId);
        }
        property.set(x & 0xF, z & 0xF, val);
        if (!property.isEmpty()) return;
        this.chunkMapping.remove(chunkId);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<ChunkIndex, ZoneChunk> e : this.chunkMapping.entrySet()) {
            NBTTagCompound subNBT = new NBTTagCompound();
            e.getKey().writeToNBT(subNBT);
            e.getValue().writeToNBT(subNBT);
            list.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("chunkMapping", (NBTBase)list);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("chunkMapping", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound subNBT = list.func_150305_b(i);
            ChunkIndex id = new ChunkIndex();
            id.readFromNBT(subNBT);
            ZoneChunk chunk = new ZoneChunk();
            chunk.readFromNBT(subNBT);
            this.chunkMapping.put(id, chunk);
        }
    }

    @Override
    public double distanceTo(BlockIndex index) {
        return Math.sqrt(this.distanceToSquared(index));
    }

    @Override
    public double distanceToSquared(BlockIndex index) {
        double maxSqrDistance = Double.MAX_VALUE;
        for (Map.Entry<ChunkIndex, ZoneChunk> e : this.chunkMapping.entrySet()) {
            double dx = (e.getKey().x << 12) - index.x;
            double dz = (e.getKey().x << 12) - index.z;
            double sqrDistance = dx * dx + dz * dz;
            if (!(sqrDistance < maxSqrDistance)) continue;
            maxSqrDistance = sqrDistance;
        }
        return maxSqrDistance;
    }

    @Override
    public boolean contains(double x, double y, double z) {
        int xBlock = (int)Math.floor(x);
        int zBlock = (int)Math.floor(z);
        return this.get(xBlock, zBlock);
    }

    @Override
    public BlockIndex getRandomBlockIndex(Random rand) {
        if (this.chunkMapping.size() == 0) {
            return null;
        }
        int chunkId = rand.nextInt(this.chunkMapping.size());
        for (Map.Entry<ChunkIndex, ZoneChunk> e : this.chunkMapping.entrySet()) {
            if (chunkId == 0) {
                BlockIndex i = e.getValue().getRandomBlockIndex(rand);
                i.x = (e.getKey().x << 4) + i.x;
                i.z = (e.getKey().z << 4) + i.z;
                return i;
            }
            --chunkId;
        }
        return null;
    }

    @Override
    public void readData(ByteBuf stream) {
        this.chunkMapping.clear();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            ChunkIndex key = new ChunkIndex();
            ZoneChunk value = new ZoneChunk();
            key.readData(stream);
            value.readData(stream);
            this.chunkMapping.put(key, value);
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeInt(this.chunkMapping.size());
        for (Map.Entry<ChunkIndex, ZoneChunk> e : this.chunkMapping.entrySet()) {
            e.getKey().writeData(stream);
            e.getValue().writeData(stream);
        }
    }
}

