/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.polymeriser;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.PackageGeneticBase;
import binnie.genetics.machine.polymeriser.DnaValidator;
import binnie.genetics.machine.polymeriser.Polymeriser;
import binnie.genetics.machine.polymeriser.PolymeriserComponentFX;
import binnie.genetics.machine.polymeriser.PolymeriserComponentLogic;
import binnie.genetics.machine.polymeriser.PolymerisingBacteriaValidator;
import binnie.genetics.machine.polymeriser.UnfilledSerumSlotValidator;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class PolymeriserPackage
extends PackageGeneticBase
implements IMachineInformation {
    public PolymeriserPackage() {
        super("polymeriser", GeneticsTexture.Polymeriser, 58819, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.Replicator);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot goldSlot = inventory.addSlot(1, "catalyst");
        goldSlot.setValidator(new SlotValidator.Item(new ItemStack(Items.field_151074_bl, 1), ModuleMachine.IconNugget));
        goldSlot.forbidExtraction();
        InventorySlot serumSlot = inventory.addSlot(0, "process");
        serumSlot.setValidator(new UnfilledSerumSlotValidator());
        serumSlot.forbidInteraction();
        serumSlot.setReadOnly();
        for (InventorySlot slot : inventory.addSlotArray(Polymeriser.SLOT_SERUM_RESERVE, "input")) {
            slot.setValidator(new UnfilledSerumSlotValidator());
            slot.forbidExtraction();
        }
        for (InventorySlot slot : inventory.addSlotArray(Polymeriser.SLOT_SERUM_FINISHED, "output")) {
            slot.setReadOnly();
        }
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Polymeriser.SLOT_SERUM_RESERVE, 0, 1);
        transfer.addStorage(0, Polymeriser.SLOT_SERUM_FINISHED, new ComponentInventoryTransfer.Condition(){

            @Override
            public boolean fufilled(ItemStack stack) {
                return !stack.func_77951_h();
            }
        });
        ComponentTankContainer tank = new ComponentTankContainer(machine);
        tank.addTank(0, "input", 1000);
        tank.getTankSlot(0).setValidator(new PolymerisingBacteriaValidator());
        tank.addTank(1, "input", 1000);
        tank.getTankSlot(1).setValidator(new DnaValidator());
        new ComponentChargedSlots(machine).addCharge(1);
        new ComponentPowerReceptor(machine, 8000);
        new PolymeriserComponentLogic(machine);
        new PolymeriserComponentFX(machine);
    }

    @Override
    public TileEntity createTileEntity() {
        return new TileEntityMachine(this);
    }
}

