/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.controls.tab;

import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.core.Control;
import binnie.core.craftgui.controls.core.IControlValue;
import binnie.core.craftgui.controls.tab.ControlTab;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.Position;
import java.util.Collection;

public class ControlTabBar<T>
extends Control
implements IControlValue<T> {
    protected T value;
    protected Position position;

    public ControlTabBar(IWidget parent, float x, float y, float width, float height, Position position) {
        super(parent, x, y, width, height);
        this.position = position;
        this.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                ControlTabBar.this.setValue(event.getValue());
            }
        }.setOrigin(EventHandler.Origin.DirectChild, this));
    }

    public ControlTab<T> createTab(float x, float y, float w, float h, T value) {
        return new ControlTab<T>(this, x, y, w, h, value);
    }

    public void setValues(Collection<T> values) {
        int i = 0;
        while (i < this.getWidgets().size()) {
            this.deleteChild(this.getWidgets().get(0));
        }
        float length = values.size();
        int tabDimension = (int)(this.getSize().y() / length);
        if (this.position == Position.TOP || this.position == Position.BOTTOM) {
            tabDimension = (int)(this.getSize().x() / length);
        }
        int j = 0;
        for (T value : values) {
            if (this.position == Position.TOP || this.position == Position.BOTTOM) {
                this.createTab(j * tabDimension, 0.0f, tabDimension, this.getSize().y(), value);
            } else {
                this.createTab(0.0f, j * tabDimension, this.getSize().x(), tabDimension, value);
            }
            ++j;
        }
        if (this.value == null && !values.isEmpty()) {
            this.setValue(values.iterator().next());
        }
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        boolean change = this.value != value;
        this.value = value;
        if (change) {
            this.callEvent(new EventValueChanged<T>(this, value));
        }
    }

    public Position getDirection() {
        return this.position;
    }
}

