/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui;

import binnie.Binnie;
import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.craftgui.IWidget;
import binnie.core.craftgui.controls.listbox.ControlList;
import binnie.core.craftgui.controls.listbox.ControlListBox;
import binnie.core.craftgui.controls.listbox.ControlTextOption;
import binnie.core.craftgui.controls.tab.ControlTab;
import binnie.core.craftgui.controls.tab.ControlTabBar;
import binnie.core.craftgui.events.EventHandler;
import binnie.core.craftgui.events.EventMouse;
import binnie.core.craftgui.events.EventValueChanged;
import binnie.core.craftgui.geometry.IArea;
import binnie.core.craftgui.geometry.Position;
import binnie.core.craftgui.minecraft.MinecraftGUI;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.control.ControlItemDisplay;
import binnie.core.craftgui.minecraft.control.ControlPlayerInventory;
import binnie.core.craftgui.minecraft.control.ControlTabIcon;
import binnie.core.craftgui.window.Panel;
import binnie.core.genetics.BreedingSystem;
import binnie.core.genetics.Gene;
import binnie.core.util.I18N;
import binnie.genetics.gui.ControlGenesisOption;
import cpw.mods.fml.relauncher.Side;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class WindowGenesis
extends Window {
    private ISpeciesRoot root;
    private IAllele[] template;
    private ControlListBox<Gene> geneList;
    private ControlListBox<Gene> geneOptions;
    private Panel panelPickup;

    public WindowGenesis(EntityPlayer player, IInventory inventory, Side side) {
        super(342.0f, 228.0f, player, inventory, side);
    }

    @Override
    protected AbstractMod getMod() {
        return BinnieCore.instance;
    }

    @Override
    protected String getName() {
        return I18N.localise("binniecore.gui.genesis");
    }

    @Override
    public void initialiseClient() {
        new ControlPlayerInventory(this);
        this.setTitle(this.getName());
        BreedingSystemControlTabBar tabSystems = new BreedingSystemControlTabBar();
        tabSystems.setValues(Binnie.Genetics.getActiveSystems());
        this.root = Binnie.Genetics.getActiveSystems().iterator().next().getSpeciesRoot();
        this.template = this.root.getDefaultTemplate();
        IArea one = new IArea(32.0f, 28.0f, 170.0f, 100.0f);
        IArea two = new IArea(214.0f, 28.0f, 100.0f, 100.0f);
        new Panel(this, one.outset(1), MinecraftGUI.PanelType.Black);
        new Panel(this, two.outset(1), MinecraftGUI.PanelType.Black);
        this.geneList = new ControlListBox<Gene>((IWidget)this, one.x(), one.y(), one.w(), one.h(), 10.0f){

            @Override
            public IWidget createOption(Gene value, int y) {
                return new ControlGenesisOption((ControlList)this.getContent(), value, y);
            }
        };
        this.geneOptions = new ControlListBox<Gene>((IWidget)this, two.x(), two.y(), two.w(), two.h(), 10.0f){

            @Override
            public IWidget createOption(Gene value, int y) {
                return new ControlTextOption<Gene>((ControlList)this.getContent(), value, y);
            }
        };
        tabSystems.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                WindowGenesis.this.root = ((BreedingSystem)event.getValue()).getSpeciesRoot();
                WindowGenesis.access$102(WindowGenesis.this, WindowGenesis.this.root.getDefaultTemplate());
                WindowGenesis.this.refreshTemplate(null);
            }
        }.setOrigin(EventHandler.Origin.Self, tabSystems));
        this.geneList.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                IChromosomeType chromo;
                Map<IChromosomeType, List<IAllele>> map = Binnie.Genetics.getChromosomeMap(WindowGenesis.this.root);
                ArrayList<Gene> opts = new ArrayList<Gene>();
                IChromosomeType iChromosomeType = chromo = event.value != null ? ((Gene)event.value).getChromosome() : null;
                if (chromo != null) {
                    for (IAllele allele : map.get(chromo)) {
                        opts.add(new Gene(allele, chromo, WindowGenesis.this.root));
                    }
                }
                WindowGenesis.this.geneOptions.setOptions(opts);
            }
        }.setOrigin(EventHandler.Origin.Self, this.geneList));
        this.geneOptions.addEventHandler(new EventValueChanged.Handler(){

            @Override
            public void onEvent(EventValueChanged event) {
                if (event.value == null) {
                    return;
                }
                IChromosomeType chromo = ((Gene)event.value).getChromosome();
                ((WindowGenesis)WindowGenesis.this).template[chromo.ordinal()] = ((Gene)event.value).getAllele();
                if (chromo == ((Gene)event.value).getSpeciesRoot().getKaryotypeKey()) {
                    WindowGenesis.access$102(WindowGenesis.this, ((Gene)event.value).getSpeciesRoot().getTemplate(((Gene)event.value).getAllele().getUID()));
                }
                WindowGenesis.this.refreshTemplate(chromo);
            }
        }.setOrigin(EventHandler.Origin.Self, this.geneOptions));
        this.panelPickup = new Panel(this, 16.0f, 140.0f, 60.0f, 42.0f, MinecraftGUI.PanelType.Black);
        this.refreshTemplate(null);
    }

    private void refreshTemplate(IChromosomeType selection) {
        IChromosomeType[] chromos;
        ArrayList<Gene> genes = new ArrayList<Gene>();
        for (IChromosomeType type : chromos = Binnie.Genetics.getChromosomeMap(this.root).keySet().toArray(new IChromosomeType[0])) {
            IAllele allele = this.template[type.ordinal()];
            if (allele == null) {
                throw new NullPointerException("Allele missing for Chromosome " + type.getName());
            }
            genes.add(new Gene(allele, type, this.root));
        }
        this.geneList.setOptions(genes);
        if (selection != null) {
            this.geneList.setValue(new Gene(this.template[selection.ordinal()], selection, this.root));
        } else {
            this.geneOptions.setOptions(new ArrayList());
        }
        this.refreshPickup();
    }

    private void refreshPickup() {
        this.panelPickup.deleteAllChildren();
        int i = 0;
        for (int type : Binnie.Genetics.getSystem(this.root).getActiveTypes()) {
            IIndividual ind = this.root.templateAsIndividual(this.template);
            ind.analyze();
            ItemStack stack = this.root.getMemberStack(ind, type);
            ControlItemDisplay display = new ControlItemDisplay(this.panelPickup, 4 + i % 3 * 18, 4 + i / 3 * 18);
            display.setItemStack(stack);
            display.setTooltip();
            display.addEventHandler(new MouseDownHandler(stack).setOrigin(EventHandler.Origin.Self, display));
            ++i;
        }
    }

    @Override
    public void recieveGuiNBT(Side side, EntityPlayer player, String name, NBTTagCompound nbt) {
        super.recieveGuiNBT(side, player, name, nbt);
        if (side == Side.SERVER && name.equals("genesis")) {
            int fit;
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)nbt);
            InventoryPlayer playerInv = player.field_71071_by;
            if (stack == null) {
                return;
            }
            if (playerInv.func_70445_o() == null) {
                playerInv.func_70437_b(stack);
            } else if (playerInv.func_70445_o().func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)playerInv.func_70445_o(), (ItemStack)stack) && (fit = stack.func_77976_d() - (stack.field_77994_a + playerInv.func_70445_o().field_77994_a)) >= 0) {
                ItemStack itemStack;
                ItemStack rec = itemStack = stack;
                itemStack.field_77994_a += playerInv.func_70445_o().field_77994_a;
                playerInv.func_70437_b(rec);
            }
            player.field_71070_bA.func_75142_b();
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71113_k();
            }
        }
    }

    static /* synthetic */ IAllele[] access$102(WindowGenesis x0, IAllele[] x1) {
        x0.template = x1;
        return x1;
    }

    private class BreedingSystemControlTabBar
    extends ControlTabBar<BreedingSystem> {
        public BreedingSystemControlTabBar() {
            super(WindowGenesis.this, 8.0f, 28.0f, 23.0f, 100.0f, Position.LEFT);
        }

        @Override
        public ControlTab<BreedingSystem> createTab(float x, float y, float w, float h, BreedingSystem value) {
            return new ControlTabIcon<BreedingSystem>((ControlTabBar)this, x, y, w, h, value){

                @Override
                public ItemStack getItemStack() {
                    int type = ((BreedingSystem)this.value).getDefaultType();
                    IIndividual ind = ((BreedingSystem)this.value).getDefaultIndividual();
                    return ((BreedingSystem)this.value).getSpeciesRoot().getMemberStack(ind, type);
                }

                @Override
                public String getName() {
                    return ((BreedingSystem)this.value).getName();
                }

                @Override
                public int getOutlineColor() {
                    return ((BreedingSystem)this.value).getColor();
                }

                @Override
                public boolean hasOutline() {
                    return true;
                }
            };
        }
    }

    private static class MouseDownHandler
    extends EventMouse.Down.Handler {
        private final ItemStack stack;

        public MouseDownHandler(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void onEvent(EventMouse.Down event) {
            NBTTagCompound nbt = new NBTTagCompound();
            this.stack.func_77955_b(nbt);
            ((Window)Window.get(event.getOrigin())).sendClientAction("genesis", nbt);
        }
    }
}

