/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.beebetteratbees.client.gui;

import codechicken.nei.PositionedStack;
import forestry.api.apiculture.IBeeMutation;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import hellfirepvp.beebetteratbees.client.gui.BBABGuiRecipeTreeHandler;
import hellfirepvp.beebetteratbees.client.gui.CachedRecipe;
import hellfirepvp.beebetteratbees.client.util.SimpleBinaryTree;
import hellfirepvp.beebetteratbees.common.ModConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class CachedBeeMutationTree
extends CachedRecipe {
    private static final int MIN_X = 15;
    private static final int MAX_X = 135;
    private static final int X_SEPERATION_THRESHOLD = 7;
    private static final int Y_OFFSET = 0;
    private SimpleBinaryTree<IAllele> mutationTree;
    private List<PositionedMutationNodeStack> evaluatedBeePositions;
    private int evaluatedMaxX;
    public final boolean oversized;
    private PositionedMutationNodeStack rootStack;

    public CachedBeeMutationTree(IBeeMutation parentMutation) {
        this.mutationTree = new SimpleBinaryTree<IAllele>(4, parentMutation.getTemplate()[0], new SimpleBinaryTree.RootProvider<IAllele>(){

            public IAllele[] provideSubNodes(IAllele superNode) {
                List<IBeeMutation> mutations = BBABGuiRecipeTreeHandler.getMutationsWithResult(superNode);
                if (mutations.size() > 0) {
                    IBeeMutation mutation = mutations.get(0);
                    return new IAllele[]{mutation.getAllele0(), mutation.getAllele1()};
                }
                return null;
            }
        });
        if (!ModConfig.showDuplicateTrees) {
            ArrayList<IAllele> foundMutationTrees = new ArrayList<IAllele>();
            this.removeAndReplaceDuplicates(this.mutationTree.getRoot(), foundMutationTrees);
        }
        this.evaluatedBeePositions = new LinkedList<PositionedMutationNodeStack>();
        int iterationDepth = 3;
        int maxTotalDepth = Math.min(iterationDepth, this.mutationTree.getRoot().getMaxFollowingDepth());
        if (maxTotalDepth <= 0) {
            this.oversized = false;
            return;
        }
        int yStep = 110 / maxTotalDepth;
        this.oversized = this.checkSeparationWidth(maxTotalDepth, 7);
        this.evaluatedMaxX = 135;
        int center = (15 + this.evaluatedMaxX) / 2;
        PositionedMutationNodeStack leftChild = this.placeInRenderBuffer(this.mutationTree.getRoot().getLeftNode(), 0 + yStep, yStep, 15, center, iterationDepth - 1);
        PositionedMutationNodeStack rightChild = this.placeInRenderBuffer(this.mutationTree.getRoot().getRightNode(), 0 + yStep, yStep, center, this.evaluatedMaxX, iterationDepth - 1);
        List<IBeeMutation> mutationsToRoot = BBABGuiRecipeTreeHandler.getMutationsWithResult(this.mutationTree.getRoot().getValue());
        float ch = -1.0f;
        LinkedList<String> requirements = new LinkedList();
        if (mutationsToRoot.size() > 0) {
            IBeeMutation mut = mutationsToRoot.get(0);
            ch = mut.getBaseChance();
            try {
                requirements = mut.getSpecialConditions();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.rootStack = new PositionedMutationNodeStack(BBABGuiRecipeTreeHandler.createStack((IAlleleSpecies)this.mutationTree.getRoot().getValue(), 1), (15 + this.evaluatedMaxX) / 2, 0, ch, requirements, leftChild, rightChild, true);
    }

    private void removeAndReplaceDuplicates(SimpleBinaryTree.Node<IAllele> node, List<IAllele> discoveredMutations) {
        if (discoveredMutations.contains(node.getValue())) {
            List<IBeeMutation> mutations = BBABGuiRecipeTreeHandler.getMutationsWithResult(node.getValue());
            if (mutations.size() > 0) {
                node.removeDuplicate();
            }
        } else {
            discoveredMutations.add(node.getValue());
            if (node.getMaxFollowingDepth() > 0) {
                this.removeAndReplaceDuplicates(node.getLeftNode(), discoveredMutations);
                this.removeAndReplaceDuplicates(node.getRightNode(), discoveredMutations);
            }
        }
    }

    private boolean checkSeparationWidth(int maxTotalDepth, int xSeparationThreshold) {
        double maxDivision = Math.pow(2.0, maxTotalDepth + 1);
        int resultingLLWidth = (int)(120.0 / maxDivision);
        return resultingLLWidth < xSeparationThreshold;
    }

    private PositionedMutationNodeStack placeInRenderBuffer(SimpleBinaryTree.Node<IAllele> node, int minY, int yStep, int minX, int maxX, int iterationMaxCount) {
        int center = (minX + maxX) / 2;
        if (--iterationMaxCount < 0 || node.getMaxFollowingDepth() <= 0) {
            List<IBeeMutation> mutationsToRoot = BBABGuiRecipeTreeHandler.getMutationsWithResult(node.getValue());
            float ch = -1.0f;
            Collection<String> requirements = new LinkedList<String>();
            if (mutationsToRoot.size() > 0) {
                IBeeMutation mut = mutationsToRoot.get(0);
                ch = mut.getBaseChance();
                try {
                    requirements = mut.getSpecialConditions();
                }
                catch (Throwable tr) {
                    requirements = new LinkedList();
                }
            }
            PositionedMutationNodeStack leaf = new PositionedMutationNodeStack(BBABGuiRecipeTreeHandler.createStack((IAlleleSpecies)node.getValue(), 0), center, minY, ch, requirements, null, null, node.getMaxFollowingDepth() > 0);
            this.evaluatedBeePositions.add(leaf);
            return leaf;
        }
        List<IBeeMutation> mutations = BBABGuiRecipeTreeHandler.getMutationsWithResult(node.getValue());
        float ch = -1.0f;
        Collection<String> requirements = new LinkedList<String>();
        if (mutations.size() > 0) {
            IBeeMutation mut = mutations.get(0);
            ch = mut.getBaseChance();
            try {
                requirements = mut.getSpecialConditions();
            }
            catch (Throwable tr) {
                requirements = new LinkedList();
            }
        }
        PositionedMutationNodeStack outNode = new PositionedMutationNodeStack(BBABGuiRecipeTreeHandler.createStack((IAlleleSpecies)node.getValue(), 0), center, minY, ch, requirements, node.getLeftNode() != null ? this.placeInRenderBuffer(node.getLeftNode(), minY + yStep, yStep, minX, center, iterationMaxCount) : null, node.getRightNode() != null ? this.placeInRenderBuffer(node.getRightNode(), minY + yStep, yStep, center, maxX, iterationMaxCount) : null, true);
        this.evaluatedBeePositions.add(outNode);
        return outNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CachedBeeMutationTree that = (CachedBeeMutationTree)o;
        return !(this.mutationTree == null ? that.mutationTree != null : !this.mutationTree.equals(that.mutationTree));
    }

    public int hashCode() {
        return this.mutationTree != null ? this.mutationTree.hashCode() : 0;
    }

    @Override
    public PositionedStack getResult() {
        return this.rootStack;
    }

    public PositionedMutationNodeStack getRootStack() {
        return this.rootStack;
    }

    @Override
    public List<PositionedStack> getIngredients() {
        return new ArrayList<PositionedStack>(this.evaluatedBeePositions);
    }

    public static class PositionedMutationNodeStack
    extends PositionedStack {
        public final boolean hasPossibleChildren;
        public final float baseChance;
        public final Collection<String> requirements;
        public final PositionedMutationNodeStack leftChild;
        public final PositionedMutationNodeStack rightChild;

        public PositionedMutationNodeStack(Object object, int x, int y, boolean genPerms, float baseChance, Collection<String> requirementInfo, PositionedMutationNodeStack leftChild, PositionedMutationNodeStack rightChild, boolean hasPossibleChildren) {
            super(object, x, y, genPerms);
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.hasPossibleChildren = hasPossibleChildren;
            this.baseChance = baseChance;
            this.requirements = requirementInfo;
        }

        public PositionedMutationNodeStack(Object object, int x, int y, float baseChance, Collection<String> requirementInfo, PositionedMutationNodeStack leftChild, PositionedMutationNodeStack rightChild, boolean hasPossibleChildren) {
            super(object, x, y);
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.hasPossibleChildren = hasPossibleChildren;
            this.baseChance = baseChance;
            this.requirements = requirementInfo;
        }
    }
}

