/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.network;

import appeng.api.storage.data.IAEFluidStack;
import appeng.util.item.AEFluidStack;
import com.glodblock.github.client.gui.GuiFluidCraftConfirm;
import com.glodblock.github.client.gui.GuiFluidMonitor;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class SPacketMEFluidInvUpdate
implements IMessage {
    private List<IAEFluidStack> list = new ArrayList<IAEFluidStack>();
    private byte ref = 0;
    private boolean resort = true;

    public SPacketMEFluidInvUpdate() {
    }

    public SPacketMEFluidInvUpdate(byte b) {
        this.ref = b;
    }

    public SPacketMEFluidInvUpdate(boolean resort) {
        this.resort = resort;
    }

    public void fromBytes(ByteBuf buf) {
        this.ref = buf.readByte();
        this.resort = buf.readBoolean();
        int amount = buf.readInt();
        this.list = new ArrayList<IAEFluidStack>(amount);
        try {
            for (int i = 0; i < amount; ++i) {
                this.list.add(AEFluidStack.loadFluidStackFromPacket((ByteBuf)buf));
            }
        }
        catch (Exception io) {
            System.out.println("Error handling payload w/ " + amount + " items.");
            io.printStackTrace();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.ref);
        buf.writeBoolean(this.resort);
        buf.writeInt(this.list.size());
        try {
            for (IAEFluidStack is : this.list) {
                is.writeToPacket(buf);
            }
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public void setResort(boolean resort) {
        this.resort = resort;
    }

    public void appendFluid(IAEFluidStack is) {
        this.list.add(is);
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public static class Handler
    implements IMessageHandler<SPacketMEFluidInvUpdate, IMessage> {
        public IMessage onMessage(SPacketMEFluidInvUpdate message, MessageContext ctx) {
            GuiScreen gs = Minecraft.func_71410_x().field_71462_r;
            if (gs instanceof GuiFluidMonitor) {
                ((GuiFluidMonitor)gs).postUpdate(message.list, message.resort);
            } else if (gs instanceof GuiFluidCraftConfirm) {
                ((GuiFluidCraftConfirm)gs).postUpdate(message.list, message.ref);
            }
            return null;
        }
    }
}

