/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.common.item;

import appeng.api.AEApi;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.networking.IGridNode;
import appeng.core.features.AEFeature;
import appeng.core.localization.PlayerMessages;
import appeng.util.Platform;
import baubles.api.BaubleType;
import baubles.api.IBauble;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.common.item.ItemBaseWirelessTerminal;
import com.glodblock.github.common.tabs.FluidCraftingTabs;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.WirelessCraftingTerminalInventory;
import com.glodblock.github.inventory.item.WirelessFluidTerminalInventory;
import com.glodblock.github.inventory.item.WirelessInterfaceTerminalInventory;
import com.glodblock.github.inventory.item.WirelessPatternTerminalExInventory;
import com.glodblock.github.inventory.item.WirelessPatternTerminalInventory;
import com.glodblock.github.loader.IRegister;
import com.glodblock.github.network.CPacketSwitchGuis;
import com.glodblock.github.util.BlockPos;
import com.glodblock.github.util.ModAndClassUtil;
import com.glodblock.github.util.NameConst;
import com.glodblock.github.util.Util;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;

@Optional.Interface(iface="baubles.api.IBauble", modid="Baubles")
public class ItemWirelessUltraTerminal
extends ItemBaseWirelessTerminal
implements IBauble,
IRegister<ItemWirelessUltraTerminal> {
    public static final String MODE = "mode_main";
    private static final List<GuiType> guis = new ArrayList<GuiType>();

    public ItemWirelessUltraTerminal() {
        super(null);
        AEApi.instance().registries().wireless().registerWirelessHandler((IWirelessTermHandler)this);
        this.setFeature(EnumSet.of(AEFeature.WirelessAccessTerminal, AEFeature.PoweredTools));
        this.func_77655_b("wireless_ultra_terminal");
        this.func_111206_d(FluidCraft.resource("wireless_ultra_terminal").toString());
        guis.add(GuiType.WIRELESS_CRAFTING_TERMINAL);
        guis.add(GuiType.WIRELESS_FLUID_PATTERN_TERMINAL);
        guis.add(GuiType.WIRELESS_FLUID_PATTERN_TERMINAL_EX);
        guis.add(GuiType.WIRELESS_FLUID_TERMINAL);
        guis.add(GuiType.WIRELESS_INTERFACE_TERMINAL);
        if (ModAndClassUtil.ThE) {
            guis.add(GuiType.WIRELESS_ESSENTIA_TERMINAL);
        }
    }

    @Override
    public ItemWirelessUltraTerminal register() {
        GameRegistry.registerItem((Item)this, (String)"wireless_ultra_terminal", (String)"ae2fc");
        this.func_77637_a(FluidCraftingTabs.INSTANCE);
        return this;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack stack, EntityPlayer player, List<String> lines, boolean displayMoreInfo) {
        super.addCheckedInformation(stack, player, lines, displayMoreInfo);
        if (GuiScreen.func_146272_n()) {
            lines.add(StatCollector.func_74838_a((String)"ae2fc.tooltip.ultra_terminal"));
            lines.add(StatCollector.func_74838_a((String)("ae2fc.tooltip.ultra_terminal." + (Object)((Object)this.guiGuiType(stack)))));
            lines.add(NameConst.i18n("ae2fc.tooltip.ultra_terminal.tips"));
            lines.addAll(Arrays.asList(NameConst.i18n("ae2fc.tooltip.ultra_terminal.tips.desc").split("\\\\n")));
        } else {
            lines.add(NameConst.i18n("ae2fc.tooltip.shift_for_more"));
        }
    }

    public String func_77653_i(ItemStack stack) {
        return StatCollector.func_74837_a((String)("item.wireless_ultra_terminal." + (Object)((Object)this.guiGuiType(stack)) + ".name"), (Object[])new Object[0]);
    }

    @Override
    public Object getInventory(ItemStack stack, World world, int x, int y, int z, EntityPlayer player) {
        try {
            IGridNode gridNode = Util.getWirelessGrid(stack);
            GuiType gui = Util.GuiHelper.decodeType(y).getLeft() == Util.GuiHelper.GuiType.ITEM && z > 0 ? ItemWirelessUltraTerminal.getGuis().get((Integer)Util.GuiHelper.decodeType(y).getRight()) : ItemWirelessUltraTerminal.readMode(stack);
            if (gui == GuiType.WIRELESS_FLUID_PATTERN_TERMINAL) {
                return new WirelessPatternTerminalInventory(stack, x, gridNode, player);
            }
            if (gui == GuiType.WIRELESS_CRAFTING_TERMINAL) {
                return new WirelessCraftingTerminalInventory(stack, x, gridNode, player);
            }
            if (ModAndClassUtil.ThE && gui == GuiType.WIRELESS_ESSENTIA_TERMINAL) {
                return new WirelessFluidTerminalInventory(stack, x, gridNode, player);
            }
            if (gui == GuiType.WIRELESS_FLUID_TERMINAL) {
                return new WirelessFluidTerminalInventory(stack, x, gridNode, player);
            }
            if (gui == GuiType.WIRELESS_INTERFACE_TERMINAL) {
                return new WirelessInterfaceTerminalInventory(stack, x, gridNode, player);
            }
            if (gui == GuiType.WIRELESS_FLUID_PATTERN_TERMINAL_EX) {
                return new WirelessPatternTerminalExInventory(stack, x, gridNode, player);
            }
            this.setMode(GuiType.WIRELESS_FLUID_TERMINAL, stack);
            return new WirelessFluidTerminalInventory(stack, x, gridNode, player);
        }
        catch (Exception e) {
            player.func_145747_a(PlayerMessages.OutOfRange.get());
            return null;
        }
    }

    @Override
    public ItemStack func_77659_a(ItemStack item, World w, EntityPlayer player) {
        if (player.func_70093_af()) {
            this.setNext(ItemWirelessUltraTerminal.readMode(item), item);
            return item;
        }
        ItemWirelessUltraTerminal.readMode(item);
        return super.func_77659_a(item, w, player);
    }

    public static GuiType readMode(ItemStack stack) {
        NBTTagCompound data = Platform.openNbtData((ItemStack)stack);
        if (data.func_74764_b(MODE)) {
            String GUI = data.func_74779_i(MODE);
            try {
                return GuiType.valueOf(GUI);
            }
            catch (IllegalArgumentException e) {
                return GuiType.WIRELESS_CRAFTING_TERMINAL;
            }
        }
        return GuiType.WIRELESS_CRAFTING_TERMINAL;
    }

    public void setNext(GuiType type, ItemStack stack) {
        boolean f = false;
        for (GuiType g : guis) {
            if (f) {
                this.setMode(g.toString(), stack);
                return;
            }
            if (g != type) continue;
            f = true;
        }
        this.setMode(guis.get(0).toString(), stack);
    }

    public void setMode(String mode, ItemStack stack) {
        NBTTagCompound data = Platform.openNbtData((ItemStack)stack);
        data.func_74778_a(MODE, mode);
    }

    public void setMode(GuiType mode, ItemStack stack) {
        this.setMode(mode.toString(), stack);
    }

    public static void switchTerminal(EntityPlayer player, GuiType guiType) {
        ImmutablePair<Integer, ItemStack> term = Util.getUltraWirelessTerm(player);
        if (term == null) {
            return;
        }
        if (((ItemStack)term.getRight()).func_77973_b() instanceof ItemWirelessUltraTerminal) {
            ((ItemWirelessUltraTerminal)((ItemStack)term.getRight()).func_77973_b()).setMode(guiType, (ItemStack)term.getRight());
        }
        if (Platform.isClient()) {
            FluidCraft.proxy.netHandler.sendToServer((IMessage)new CPacketSwitchGuis(guiType, true));
        } else {
            InventoryHandler.openGui(player, player.field_70170_p, new BlockPos((Integer)term.getLeft(), Util.GuiHelper.encodeType(guis.indexOf((Object)GuiType.valueOf(guiType.toString())), Util.GuiHelper.GuiType.ITEM), 1), ForgeDirection.UNKNOWN, guiType);
        }
    }

    public static List<GuiType> getGuis() {
        return guis;
    }

    @Override
    public GuiType guiGuiType(ItemStack stack) {
        return ItemWirelessUltraTerminal.readMode(stack);
    }

    public BaubleType getBaubleType(ItemStack itemStack) {
        return BaubleType.RING;
    }

    public void onWornTick(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    public void onEquipped(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    public void onUnequipped(ItemStack itemStack, EntityLivingBase entityLivingBase) {
    }

    public boolean canEquip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }

    public boolean canUnequip(ItemStack itemStack, EntityLivingBase entityLivingBase) {
        return true;
    }
}

