/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.network;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import eu.usrv.yamcore.network.client.AbstractClientMessageHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class PacketDispatcher {
    private byte _mPacketId = 0;
    private final SimpleNetworkWrapper dispatcher;

    public PacketDispatcher(String pModID) {
        this.dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel(pModID);
    }

    public abstract void registerPackets();

    protected final <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> handlerClass, Class<REQ> messageClass) {
        Side side = AbstractClientMessageHandler.class.isAssignableFrom(handlerClass) ? Side.CLIENT : Side.SERVER;
        byte by = this._mPacketId;
        this._mPacketId = (byte)(by + 1);
        this.dispatcher.registerMessage(handlerClass, messageClass, (int)by, side);
    }

    protected final void registerMessage(Class pHandlerClass, Class pMessageClass, Side pSide) {
        byte by = this._mPacketId;
        this._mPacketId = (byte)(by + 1);
        this.dispatcher.registerMessage(pHandlerClass, pMessageClass, (int)by, pSide);
    }

    public final void sendTo(IMessage pMessage, EntityPlayerMP pPlayer) {
        this.dispatcher.sendTo(pMessage, pPlayer);
    }

    public final void sendToAllAround(IMessage pMessage, NetworkRegistry.TargetPoint pPoint) {
        this.dispatcher.sendToAllAround(pMessage, pPoint);
    }

    public final void sendToAllAround(IMessage pMessage, int pDimension, double pX, double pY, double pZ, double pRange) {
        this.sendToAllAround(pMessage, new NetworkRegistry.TargetPoint(pDimension, pX, pY, pZ, pRange));
    }

    public final void sendToAllAround(IMessage pMessage, EntityPlayer pPlayer, double pRange) {
        this.sendToAllAround(pMessage, pPlayer.field_70170_p.field_73011_w.field_76574_g, pPlayer.field_70165_t, pPlayer.field_70163_u, pPlayer.field_70161_v, pRange);
    }

    public final void sendToDimension(IMessage pMessage, int pDimensionId) {
        this.dispatcher.sendToDimension(pMessage, pDimensionId);
    }

    public final void sendToAll(IMessage pMessage) {
        this.dispatcher.sendToAll(pMessage);
    }

    public final void sendToServer(IMessage pMessage) {
        this.dispatcher.sendToServer(pMessage);
    }
}

