/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.items;

import eu.usrv.yamcore.YAMCore;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.auxiliary.enums.ItemRecipeBehaviorEnum;
import eu.usrv.yamcore.iface.IExtendedItemProperties;
import eu.usrv.yamcore.items.ItemBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;

public class ModSimpleBaseItem {
    private final String _mName;
    private String _mTextureOverride;
    private final ItemBase _mItemInstance;
    private String _mCreativeTab;
    private LogHelper _mLog = YAMCore.instance.getLogger();
    private boolean _mFullyPopulated = false;

    public ModSimpleBaseItem(String pItemName, String pCustomTextureName, String pCreativeTabName) {
        this._mName = pItemName;
        this._mCreativeTab = pCreativeTabName;
        this._mTextureOverride = pCustomTextureName;
        this._mItemInstance = new ItemBase();
        this._mItemInstance.func_77655_b(this._mName);
    }

    public ModSimpleBaseItem(IExtendedItemProperties pItemProperties, String pCreativeTabName) {
        this._mName = pItemProperties.getItemName();
        this._mCreativeTab = pCreativeTabName;
        this._mTextureOverride = pItemProperties.getCustomTextureName();
        this._mItemInstance = new ItemBase(pItemProperties.getItemRecipeBehavior());
        this._mItemInstance.func_77655_b(pItemProperties.getUnlocalizedName());
        if (pItemProperties.getItemRecipeBehavior() == ItemRecipeBehaviorEnum.NoConsume || pItemProperties.getItemRecipeBehavior() == ItemRecipeBehaviorEnum.NoConsumeLeaveInGrid) {
            this._mItemInstance.func_77642_a(this._mItemInstance);
        }
    }

    public ModSimpleBaseItem(String pItemName, String pCreativeTabName) {
        this(pItemName, "", pCreativeTabName);
    }

    public void setModIDName(String pModID) {
        String tTextureName = "";
        tTextureName = this._mTextureOverride.length() < 1 ? String.format("%s:item%s", pModID, this._mName) : String.format("%s:%s", pModID, this._mTextureOverride);
        this._mItemInstance.func_111206_d(tTextureName);
        this._mFullyPopulated = true;
    }

    public Item getConstructedItem() {
        if (!this._mFullyPopulated) {
            this._mLog.error("Item is not fully prepared yet and can't be registered at this point!");
            return null;
        }
        return this._mItemInstance;
    }

    public void setCreativeTab(CreativeTabs pTab) {
        this._mItemInstance.func_77637_a(pTab);
    }

    public String getCreativeTabName() {
        return this._mCreativeTab;
    }

    public String getUnlocItemName() {
        return this._mName;
    }
}

