/*
 * Decompiled with CFR 0.152.
 */
package alkalus.main.core.recipe.fixes;

import alkalus.main.core.WitcheryExtras;
import alkalus.main.core.util.Utils;
import com.emoniph.witchery.Witchery;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;

public class GarlicRecipes {
    private final ItemStack[] mGarlics;

    public GarlicRecipes() {
        WitcheryExtras.log(0, "Attempting to fix Witchery recipes that don't use OreDict for Garlic.");
        this.mGarlics = Utils.getAllItemsFromOreDictEntry("cropGarlic");
        this.fixGarlicArmour();
        this.fixVampireBook();
    }

    private void fixGarlicArmour() {
        Item[][] hunterItemsSilvered = new Item[][]{{Witchery.Items.HUNTER_BOOTS_SILVERED, Witchery.Items.HUNTER_BOOTS_GARLICKED}, {Witchery.Items.HUNTER_LEGS_SILVERED, Witchery.Items.HUNTER_LEGS_GARLICKED}, {Witchery.Items.HUNTER_COAT_SILVERED, Witchery.Items.HUNTER_COAT_GARLICKED}, {Witchery.Items.HUNTER_HAT_SILVERED, Witchery.Items.HUNTER_HAT_GARLICKED}};
        for (int i = 0; i < hunterItemsSilvered.length; ++i) {
            ItemStack currentStack = new ItemStack(hunterItemsSilvered[i][1]);
            if (Utils.removeAllCraftingRecipesByOutputItem(currentStack)) {
                WitcheryExtras.log(1, "Successfully removed all crafting recipes for " + currentStack.func_82833_r() + ".");
            }
            for (ItemStack garlic : this.mGarlics) {
                CraftingManager.func_77594_a().func_92103_a(currentStack, new Object[]{" g ", "g#g", " s ", Character.valueOf('#'), new ItemStack(hunterItemsSilvered[i][0]), Character.valueOf('s'), new ItemStack(Items.field_151007_F), Character.valueOf('g'), garlic.func_77946_l()}).func_92100_c();
            }
        }
        WitcheryExtras.log(0, "Fixed Recipes for Witchery Armours.");
    }

    private void fixVampireBook() {
        ItemStack currentStack = new ItemStack(Witchery.Items.VAMPIRE_BOOK);
        if (Utils.removeAllCraftingRecipesByOutputItem(currentStack)) {
            WitcheryExtras.log(1, "Successfully removed all crafting recipes for " + currentStack.func_82833_r() + ".");
        }
        for (ItemStack garlic : this.mGarlics) {
            GameRegistry.addShapedRecipe((ItemStack)currentStack, (Object[])new Object[]{"#s#", "#b#", "#g#", Character.valueOf('s'), new ItemStack(Items.field_151156_bN), Character.valueOf('b'), new ItemStack(Items.field_151122_aG), Character.valueOf('g'), garlic.func_77946_l(), Character.valueOf('#'), new ItemStack(Items.field_151075_bm)});
        }
        WitcheryExtras.log(0, "Fixed recipe for the Vampire Book.");
    }
}

