/*
 * Decompiled with CFR 0.152.
 */
package thaumic.tinkerer.common.dim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import thaumic.tinkerer.common.dim.OreClusterGenerator;

public enum EnumOreFrequency {
    ALUMINUM("oreAluminum", 617),
    AMBER("oreAmber", 161),
    APATITE("oreApatite", 269),
    TOPAZ("oreTopaz", 238),
    SILICON("oreSilicon", 234),
    ILMENITE("oreIlmenite", 270),
    CINNABAR("oreCinnabar", 172),
    COAL("oreCoal", 2648),
    COPPER("oreCopper", 603),
    DIAMOND("oreDiamond", 67),
    EMERALD("oreEmerald", 48),
    TANZANITE("oreTanzanite", 61),
    GOLD("oreGold", 164),
    AIR("oreInfusedAir", 94),
    EARTH("oreInfusedEarth", 35),
    ENTROPY("oreInfusedEntropy", 53),
    FIRE("oreInfusedFire", 42),
    ORDER("oreInfusedOrder", 31),
    WATER("oreInfusedWater", 27),
    IRON("oreIron", 1503),
    LAPIS("oreLapis", 57),
    LEAD("oreLead", 335),
    PERIDOT("orePeridot", 79),
    REDSTONE("oreRedstone", 364),
    RUBY("oreRuby", 57),
    SAPPHIRE("oreSapphire", 70),
    MALACHITE("oreMalachite", 416),
    DESH("oreDesh", 105),
    TIN("oreTin", 507),
    URANIUM("oreUranium", 112),
    NETHERQUARTZ("oreNetherQuartz", 809),
    CHARGED_CERTUS_QUARTZ("oreChargedCertusQuartz", 117),
    CHEESE("oreCheese", 1024);

    public int freq;
    public String name;

    private EnumOreFrequency(String name, int freq) {
        this.name = name;
        this.freq = freq;
    }

    public static int getSum() {
        int total = 0;
        for (EnumOreFrequency e : EnumOreFrequency.values()) {
            if (!e.isValid()) continue;
            total += e.freq;
        }
        return total;
    }

    public static ArrayList<EnumOreFrequency> getValidOres() {
        ArrayList<EnumOreFrequency> result = new ArrayList<EnumOreFrequency>();
        for (EnumOreFrequency e : EnumOreFrequency.values()) {
            if (!e.isValid()) continue;
            result.add(e);
        }
        return result;
    }

    public static ItemStack getRandomOre(Random rand) {
        int randInt = rand.nextInt(EnumOreFrequency.getSum());
        for (EnumOreFrequency e : EnumOreFrequency.getValidOres()) {
            if ((randInt -= e.freq) >= 0) continue;
            return (ItemStack)OreDictionary.getOres((String)e.name).get(0);
        }
        return new ItemStack(Blocks.field_150366_p);
    }

    public boolean isValid() {
        return !Arrays.asList(OreClusterGenerator.blacklist).contains(this.name) && !OreDictionary.getOres((String)this.name).isEmpty() && ((ItemStack)OreDictionary.getOres((String)this.name).get(0)).func_77973_b() instanceof ItemBlock;
    }
}

