/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.thing.cover;

import com.github.technus.tectech.mechanics.enderStorage.EnderFluidContainer;
import com.github.technus.tectech.mechanics.enderStorage.EnderLinkTag;
import com.github.technus.tectech.mechanics.enderStorage.EnderWorldSavedData;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.math.Color;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import com.gtnewhorizons.modularui.common.widget.textfield.TextFieldWidget;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import gregtech.api.gui.modularui.GT_CoverUIBuildContext;
import gregtech.api.gui.modularui.GT_UITextures;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.util.GT_CoverBehavior;
import gregtech.api.util.GT_CoverBehaviorBase;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.ISerializableObject;
import gregtech.common.gui.modularui.widget.CoverDataControllerWidget;
import gregtech.common.gui.modularui.widget.CoverDataFollower_ToggleButtonWidget;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_Cover_TM_EnderFluidLink
extends GT_CoverBehavior {
    private static final int L_PER_TICK = 8000;
    private static final int IMPORT_EXPORT_MASK = 1;
    private static final int PUBLIC_PRIVATE_MASK = 2;

    private void transferFluid(IFluidHandler source, ForgeDirection side, IFluidHandler target, ForgeDirection tSide, int amount) {
        FluidStack fluidStack = source.drain(side, amount, false);
        if (fluidStack != null) {
            int fluidTransferred = target.fill(tSide, fluidStack, true);
            source.drain(side, fluidTransferred, true);
        }
    }

    private boolean testBit(int aCoverVariable, int bitMask) {
        return (aCoverVariable & bitMask) != 0;
    }

    private int toggleBit(int aCoverVariable, int bitMask) {
        return aCoverVariable ^ bitMask;
    }

    public int doCoverThings(ForgeDirection side, byte aInputRedstone, int aCoverID, int aCoverVariable, ICoverable aTileEntity, long aTimer) {
        if (aTileEntity instanceof IFluidHandler) {
            IFluidHandler fluidHandlerSelf = (IFluidHandler)aTileEntity;
            EnderFluidContainer fluidHandlerEnder = EnderWorldSavedData.getEnderFluidContainer(EnderWorldSavedData.getEnderLinkTag((IFluidHandler)aTileEntity));
            if (this.testBit(aCoverVariable, 1)) {
                this.transferFluid(fluidHandlerEnder, ForgeDirection.UNKNOWN, fluidHandlerSelf, side, 8000);
            } else {
                this.transferFluid(fluidHandlerSelf, side, fluidHandlerEnder, ForgeDirection.UNKNOWN, 8000);
            }
        }
        return aCoverVariable;
    }

    public String getDescription(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return "";
    }

    public boolean letsFluidIn(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    public boolean letsFluidOut(ForgeDirection side, int aCoverID, int aCoverVariable, Fluid aFluid, ICoverable aTileEntity) {
        return true;
    }

    public int onCoverScrewdriverclick(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        int newCoverVariable = this.toggleBit(aCoverVariable, 1);
        if (this.testBit(aCoverVariable, 1)) {
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Ender Suction Engaged!");
        } else {
            PlayerChatHelper.SendInfo((EntityPlayer)aPlayer, (String)"Ender Filling Engaged!");
        }
        return newCoverVariable;
    }

    public int getTickRate(ForgeDirection side, int aCoverID, int aCoverVariable, ICoverable aTileEntity) {
        return 1;
    }

    public boolean hasCoverGUI() {
        return true;
    }

    public boolean useModularUI() {
        return true;
    }

    public ModularWindow createWindow(GT_CoverUIBuildContext buildContext) {
        if (buildContext.getTile() instanceof IFluidHandler) {
            return new EnderFluidLinkUIFactory(buildContext).createWindow();
        }
        return null;
    }

    private class EnderFluidLinkUIFactory
    extends GT_CoverBehaviorBase.UIFactory {
        private static final int START_X = 10;
        private static final int START_Y = 25;
        private static final int SPACE_X = 18;
        private static final int SPACE_Y = 18;
        private static final int PUBLIC_BUTTON_ID = 0;
        private static final int PRIVATE_BUTTON_ID = 1;
        private static final int IMPORT_BUTTON_ID = 2;
        private static final int EXPORT_BUTTON_ID = 3;

        public EnderFluidLinkUIFactory(GT_CoverUIBuildContext buildContext) {
            super((GT_CoverBehaviorBase)GT_Cover_TM_EnderFluidLink.this, buildContext);
        }

        protected void addUIWidgets(ModularWindow.Builder builder) {
            TextFieldWidget frequencyField = new TextFieldWidget();
            ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(frequencyField.setGetter(() -> {
                ICoverable te = this.getUIBuildContext().getTile();
                if (!frequencyField.isClient() && te instanceof IFluidHandler) {
                    return EnderWorldSavedData.getEnderLinkTag((IFluidHandler)te).getFrequency();
                }
                return "";
            }).setSetter(val -> {
                ICoverable te = this.getUIBuildContext().getTile();
                if (!frequencyField.isClient() && te instanceof IFluidHandler) {
                    UUID uuid;
                    if (GT_Cover_TM_EnderFluidLink.this.testBit(GT_Cover_TM_EnderFluidLink.convert((ISerializableObject.LegacyCoverData)((ISerializableObject.LegacyCoverData)this.getCoverData())), 2)) {
                        uuid = this.getUUID();
                        if (!(te instanceof IGregTechTileEntity)) {
                            return;
                        }
                        if (!uuid.equals(((IGregTechTileEntity)te).getOwnerUuid())) {
                            return;
                        }
                    } else {
                        uuid = null;
                    }
                    EnderWorldSavedData.bindEnderLinkTag((IFluidHandler)te, new EnderLinkTag((String)val, uuid));
                }
            }).setTextColor(Color.WHITE.dark(1)).setTextAlignment(Alignment.CenterLeft).setFocusOnGuiOpen(true).setBackground(new IDrawable[]{GT_UITextures.BACKGROUND_TEXT_FIELD.withOffset(-1.0f, -1.0f, 2.0f, 2.0f)}).setPos(10, 25).setSize(82, 12))).widget((Widget)new CoverDataControllerWidget.CoverDataIndexedControllerWidget_ToggleButtons(() -> ((EnderFluidLinkUIFactory)this).getCoverData(), arg_0 -> ((EnderFluidLinkUIFactory)this).setCoverData(arg_0), (GT_CoverBehaviorBase)GT_Cover_TM_EnderFluidLink.this, (id, coverData) -> !this.getClickable((int)id, GT_Cover_TM_EnderFluidLink.convert((ISerializableObject.LegacyCoverData)coverData)), (id, coverData) -> new ISerializableObject.LegacyCoverData(this.getNewCoverVariable((int)id, GT_Cover_TM_EnderFluidLink.convert((ISerializableObject.LegacyCoverData)coverData)))).addToggleButton(0, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_WHITELIST).addTooltip(GT_Utility.trans((String)"326", (String)"Public")).setPos(10, 61)).addToggleButton(1, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_BLACKLIST).addTooltip(GT_Utility.trans((String)"327", (String)"Private")).setPos(28, 61)).addToggleButton(2, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_IMPORT).addTooltip(GT_Utility.trans((String)"007", (String)"Import")).setPos(10, 79)).addToggleButton(3, CoverDataFollower_ToggleButtonWidget.ofDisableable(), widget -> widget.setStaticTexture((IDrawable)GT_UITextures.OVERLAY_BUTTON_EXPORT).addTooltip(GT_Utility.trans((String)"006", (String)"Export")).setPos(28, 79)))).widget(new TextWidget(GT_Utility.trans((String)"328", (String)"Channel")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(100, 29))).widget(new TextWidget(GT_Utility.trans((String)"329", (String)"Public/Private")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 65))).widget(new TextWidget(GT_Utility.trans((String)"229", (String)"Import/Export")).setDefaultColor(((Integer)this.COLOR_TEXT_GRAY.get()).intValue()).setPos(46, 83));
        }

        private int getNewCoverVariable(int id, int coverVariable) {
            switch (id) {
                case 0: 
                case 1: {
                    return GT_Cover_TM_EnderFluidLink.this.toggleBit(coverVariable, 2);
                }
                case 2: 
                case 3: {
                    return GT_Cover_TM_EnderFluidLink.this.toggleBit(coverVariable, 1);
                }
            }
            return coverVariable;
        }

        private boolean getClickable(int id, int coverVariable) {
            switch (id) {
                case 0: {
                    return GT_Cover_TM_EnderFluidLink.this.testBit(coverVariable, 2);
                }
                case 1: {
                    return !GT_Cover_TM_EnderFluidLink.this.testBit(coverVariable, 2);
                }
                case 2: {
                    return GT_Cover_TM_EnderFluidLink.this.testBit(coverVariable, 1);
                }
                case 3: {
                    return !GT_Cover_TM_EnderFluidLink.this.testBit(coverVariable, 1);
                }
            }
            return false;
        }

        private UUID getUUID() {
            return this.getUIBuildContext().getPlayer().func_110124_au();
        }
    }
}

