/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleAddon;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotIncinerator;

public class ModuleIncinerator
extends ModuleAddon {
    public ModuleIncinerator(MinecartModular cart) {
        super(cart);
    }

    public void incinerate(ItemStack item) {
        if (this.isItemValid(item)) {
            if (this.getIncinerationCost() != 0) {
                int amount = item.field_77994_a * this.getIncinerationCost();
                amount = this.getCart().drain(FluidRegistry.LAVA, amount, false);
                int incinerated = amount / this.getIncinerationCost();
                this.getCart().drain(FluidRegistry.LAVA, incinerated * this.getIncinerationCost(), true);
                item.field_77994_a -= incinerated;
            } else {
                item.field_77994_a = 0;
            }
        }
    }

    protected int getIncinerationCost() {
        return 3;
    }

    protected boolean isItemValid(ItemStack item) {
        if (item != null) {
            for (int i = 0; i < this.getInventorySize(); ++i) {
                if (this.getStack(i) == null || !item.func_77969_a(this.getStack(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    protected int getInventoryWidth() {
        return 4;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotIncinerator(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }
}

