/*
 * Decompiled with CFR 0.152.
 */
package squeek.spiceoflife.foodtracker.foodgroups;

import com.google.gson.annotations.SerializedName;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import squeek.spiceoflife.compat.IByteIO;
import squeek.spiceoflife.foodtracker.FoodModifier;
import squeek.spiceoflife.foodtracker.foodgroups.FoodGroupMember;
import squeek.spiceoflife.helpers.OreDictionaryHelper;
import squeek.spiceoflife.interfaces.IPackable;

public class FoodGroup
implements IPackable {
    static final transient EnumChatFormatting DEFAULT_FORMATTING = EnumChatFormatting.GRAY;
    public transient String identifier;
    public transient EnumChatFormatting formatting;
    public boolean enabled = true;
    public String name = null;
    public boolean blacklist = false;
    public String formula = null;
    public String color = DEFAULT_FORMATTING.func_96297_d();
    @SerializedName(value="food")
    public Map<String, List<String>> foodStringsByType;
    @SerializedName(value="exclude")
    public Map<String, List<String>> excludedFoodStringsByType;
    private transient List<FoodGroupMember> included = new ArrayList<FoodGroupMember>();
    private transient List<FoodGroupMember> excluded = new ArrayList<FoodGroupMember>();
    private transient Set<Integer> matchingItemHashes = new HashSet<Integer>();
    private transient Set<Integer> excludedItemHashes = new HashSet<Integer>();
    private transient FoodModifier foodModifier;
    private boolean hidden = false;

    public FoodGroup() {
    }

    public FoodGroup(String identifier, String name) {
        this.identifier = identifier;
        this.name = name;
    }

    public void initFromConfig() {
        List<String> itemStrings;
        List<String> oredictStrings;
        if (this.foodStringsByType == null) {
            throw new RuntimeException(this.toString() + " food group (" + this.identifier + ".json) missing required \"food\" property");
        }
        this.formatting = EnumChatFormatting.func_96300_b((String)this.color);
        if (this.formatting == null) {
            this.formatting = DEFAULT_FORMATTING;
        }
        if ((oredictStrings = this.foodStringsByType.get("oredict")) != null) {
            for (String string : oredictStrings) {
                this.addFood(string);
            }
        }
        if ((itemStrings = this.foodStringsByType.get("items")) != null) {
            for (String string : itemStrings) {
                ItemStack item = this.getItemFromString(string);
                if (item == null) continue;
                this.addFood(item);
            }
        }
        if (this.excludedFoodStringsByType != null) {
            List<String> list;
            List<String> list2 = this.excludedFoodStringsByType.get("oredict");
            if (list2 != null) {
                for (String oredictString : list2) {
                    this.excludeFood(oredictString);
                }
            }
            if ((list = this.excludedFoodStringsByType.get("items")) != null) {
                for (String itemString : list) {
                    ItemStack item = this.getItemFromString(itemString);
                    if (item == null) continue;
                    this.excludeFood(item);
                }
            }
        }
    }

    public void addFood(String oredictName) {
        this.addFood(new FoodGroupMember(oredictName));
    }

    public ItemStack getItemFromString(String itemString) {
        Item item;
        String[] itemStringParts = itemString.split(":");
        if (itemStringParts.length > 1 && (item = GameRegistry.findItem((String)itemStringParts[0], (String)itemStringParts[1])) != null) {
            boolean exactMetadata = itemStringParts.length > 2 && !itemStringParts[2].equals("*");
            int metadata = exactMetadata ? Integer.parseInt(itemStringParts[2]) : Short.MAX_VALUE;
            return new ItemStack(item, 1, metadata);
        }
        return null;
    }

    public void addFood(ItemStack itemStack) {
        this.addFood(new FoodGroupMember(itemStack));
    }

    public void excludeFood(String oredictName) {
        this.excludeFood(new FoodGroupMember(oredictName));
    }

    public void excludeFood(ItemStack itemStack) {
        this.excludeFood(new FoodGroupMember(itemStack));
    }

    public String getLocalizedName() {
        if (this.name != null) {
            return StatCollector.func_74838_a((String)this.name);
        }
        return StatCollector.func_74838_a((String)("spiceoflife.foodgroup." + this.identifier));
    }

    public void addFood(FoodGroupMember foodMember) {
        this.included.add(foodMember);
    }

    public void excludeFood(FoodGroupMember foodMember) {
        this.excluded.add(foodMember);
    }

    public void init() {
        List<ItemStack> matchingItems;
        this.matchingItemHashes.clear();
        for (FoodGroupMember foodMember : this.included) {
            matchingItems = foodMember.getBaseItemList();
            for (ItemStack matchingItem : matchingItems) {
                this.matchingItemHashes.add(OreDictionaryHelper.getItemStackHash(matchingItem));
            }
        }
        for (FoodGroupMember foodMember : this.excluded) {
            matchingItems = foodMember.getBaseItemList();
            for (ItemStack matchingItem : matchingItems) {
                this.excludedItemHashes.add(OreDictionaryHelper.getItemStackHash(matchingItem));
            }
        }
        this.foodModifier = this.formula != null ? new FoodModifier(this.formula) : FoodModifier.GLOBAL;
    }

    public boolean isFoodIncluded(ItemStack food) {
        return !this.isFoodExcluded(food) && this.matchingItemHashes.contains(OreDictionaryHelper.getItemStackHash(food)) || this.matchingItemHashes.contains(OreDictionaryHelper.getWildCardItemStackHash(food));
    }

    public boolean isFoodExcluded(ItemStack food) {
        return this.excludedItemHashes.contains(OreDictionaryHelper.getItemStackHash(food)) || this.excludedItemHashes.contains(OreDictionaryHelper.getWildCardItemStackHash(food));
    }

    public Set<Integer> getMatchingItemStackHashes() {
        return this.matchingItemHashes;
    }

    public String getFormattedName() {
        return this.formatString(this.getLocalizedName());
    }

    public String formatString(String string) {
        return this.formatting + string;
    }

    public FoodModifier getFoodModifier() {
        return this.foodModifier;
    }

    public boolean hidden() {
        return this.hidden || this.blacklist;
    }

    @Override
    public void pack(IByteIO data) {
        data.writeUTF(this.identifier);
        data.writeUTF(this.name != null ? this.name : "");
        data.writeUTF(this.formula != null ? this.formula : "");
        data.writeBoolean(this.blacklist);
        data.writeBoolean(this.hidden);
        data.writeByte(this.formatting != null ? this.formatting.ordinal() : DEFAULT_FORMATTING.ordinal());
        data.writeShort(this.included.size());
        for (FoodGroupMember foodMember : this.included) {
            foodMember.pack(data);
        }
        data.writeShort(this.excluded.size());
        for (FoodGroupMember foodMember : this.excluded) {
            foodMember.pack(data);
        }
    }

    @Override
    public void unpack(IByteIO data) {
        FoodGroupMember foodMember;
        int i;
        this.identifier = data.readUTF();
        this.name = data.readUTF();
        this.name = !this.name.equals("") ? this.name : null;
        this.formula = data.readUTF();
        this.formula = !this.formula.equals("") ? this.formula : null;
        this.blacklist = data.readBoolean();
        this.hidden = data.readBoolean();
        this.formatting = EnumChatFormatting.values()[data.readByte()];
        int size = data.readShort();
        for (i = 0; i < size; ++i) {
            foodMember = new FoodGroupMember();
            foodMember.unpack(data);
            this.addFood(foodMember);
        }
        size = data.readShort();
        for (i = 0; i < size; ++i) {
            foodMember = new FoodGroupMember();
            foodMember.unpack(data);
            this.excludeFood(foodMember);
        }
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (obj instanceof FoodGroup) {
            return ((FoodGroup)obj).identifier.equals(this.identifier);
        }
        return false;
    }

    public String toString() {
        return this.getLocalizedName();
    }
}

