/*
 * Decompiled with CFR 0.152.
 */
package toast.specialMobs.entity.blaze;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import toast.specialMobs.Properties;
import toast.specialMobs.entity.ISpecialMob;
import toast.specialMobs.entity.SpecialMobData;

public class Entity_SpecialBlaze
extends EntityBlaze
implements ISpecialMob {
    public double BLAZE_SNOWBALL_HITS = Properties.getDouble("_mob_stats", "blaze_snowball_hits");
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/blaze.png")};
    private SpecialMobData specialData;
    public int attackState;
    public short fireballBurstCount;
    public short fireballBurstDelay;
    public static ArrayList<ChatComponentText> chatSnark = new ArrayList();
    public static ArrayList<ChatComponentText> chatSuper = new ArrayList();

    public Entity_SpecialBlaze(World world) {
        super(world);
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.setRangedAI(3, 6, 60, 100, 30.0f);
        this.getSpecialData().arrowSpread = 0.5f;
    }

    protected void func_70088_a() {
        this.specialData = new SpecialMobData((EntityLiving)this, TEXTURES);
        super.func_70088_a();
    }

    protected void setRangedAI(int burstCount, int burstDelay, int chargeTime, int cooldownTime, float range) {
        this.fireballBurstCount = (short)burstCount;
        this.fireballBurstDelay = (short)burstDelay;
        SpecialMobData data = this.getSpecialData();
        data.arrowRefireMin = (short)chargeTime;
        data.arrowRefireMax = (short)(chargeTime + cooldownTime);
        data.arrowRange = range;
    }

    @Override
    public SpecialMobData getSpecialData() {
        return this.specialData;
    }

    @Override
    public void adjustEntityAttributes() {
        float prevMax = this.func_110138_aP();
        this.adjustTypeAttributes();
        this.func_70606_j(this.func_110138_aP() + this.func_110143_aJ() - prevMax);
    }

    protected void adjustTypeAttributes() {
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.getSpecialData().onUpdate();
    }

    public IEntityLivingData func_110161_a(IEntityLivingData data) {
        return this.getSpecialData().onSpawnWithEgg(data, (EntityLiving)new EntityBlaze(this.field_70170_p));
    }

    protected void func_70785_a(Entity target, float distance) {
        SpecialMobData data = this.getSpecialData();
        if (this.field_70724_aR <= 0 && distance < 2.0f && target.field_70121_D.field_72337_e > this.field_70121_D.field_72338_b && target.field_70121_D.field_72338_b < this.field_70121_D.field_72337_e) {
            this.field_70724_aR = 20;
            this.func_70652_k(target);
        } else if (this.canBeHurtByFire(target) && distance < data.arrowRange) {
            if (this.field_70724_aR == 0) {
                ++this.attackState;
                if (this.attackState == 1) {
                    this.field_70724_aR = data.arrowRefireMin;
                    this.func_70844_e(true);
                } else if (this.attackState <= this.fireballBurstCount + 1) {
                    this.field_70724_aR = this.fireballBurstDelay;
                } else {
                    this.field_70724_aR = data.arrowRefireMax - data.arrowRefireMin;
                    this.attackState = 0;
                    this.func_70844_e(false);
                }
                if (this.attackState > 1) {
                    this.shootFireballAtEntity(target, distance);
                }
            }
            this.field_70177_z = (float)(Math.atan2(target.field_70161_v - this.field_70161_v, target.field_70165_t - this.field_70165_t) * 180.0 / Math.PI) - 90.0f;
            this.field_70787_b = true;
        } else if (this.field_70122_E) {
            this.func_70612_e(0.0f, (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 7.0f);
        } else {
            this.func_70060_a(0.0f, (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 7.0f, 0.03f);
        }
    }

    protected boolean canBeHurtByFire(Entity entity) {
        return !entity.func_70045_F() && (!(entity instanceof EntityLivingBase) || !((EntityLivingBase)entity).func_70644_a(Potion.field_76426_n));
    }

    public void shootFireballAtEntity(Entity target, float distance) {
        double dX = target.field_70165_t - this.field_70165_t;
        double dY = target.field_70121_D.field_72338_b + (double)(target.field_70131_O / 2.0f) - this.field_70163_u - (double)(this.field_70131_O / 2.0f);
        double dZ = target.field_70161_v - this.field_70161_v;
        float spread = (float)Math.sqrt(distance) * this.getSpecialData().arrowSpread;
        this.field_70170_p.func_72889_a((EntityPlayer)null, 1009, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
        EntitySmallFireball fireball = new EntitySmallFireball(this.field_70170_p, (EntityLivingBase)this, dX + this.field_70146_Z.nextGaussian() * (double)spread, dY, dZ + this.field_70146_Z.nextGaussian() * (double)spread);
        fireball.field_70163_u = this.field_70163_u + (double)(this.field_70131_O / 2.0f) + 0.5;
        this.field_70170_p.func_72838_d((Entity)fireball);
    }

    public boolean func_70652_k(Entity target) {
        if (super.func_70652_k(target)) {
            this.onTypeAttack(target);
            return true;
        }
        return false;
    }

    protected void onTypeAttack(Entity target) {
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.func_74777_a("SMFireballBurstCount", this.fireballBurstCount);
        saveTag.func_74777_a("SMFireballBurstDelay", this.fireballBurstDelay);
        this.getSpecialData().isImmuneToFire = this.field_70178_ae;
        this.getSpecialData().writeToNBT(saveTag);
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagCompound saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.func_74764_b("SMFireballBurstCount")) {
            this.fireballBurstCount = saveTag.func_74765_d("SMFireballBurstCount");
        } else if (tag.func_74764_b("SMFireballBurstCount")) {
            this.fireballBurstCount = tag.func_74765_d("SMFireballBurstCount");
        }
        if (saveTag.func_74764_b("SMFireballBurstDelay")) {
            this.fireballBurstDelay = saveTag.func_74765_d("SMFireballBurstDelay");
        } else if (tag.func_74764_b("SMFireballBurstDelay")) {
            this.fireballBurstDelay = tag.func_74765_d("SMFireballBurstDelay");
        }
        this.getSpecialData().readFromNBT(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.field_70178_ae = this.getSpecialData().isImmuneToFire;
    }

    public boolean func_70097_a(DamageSource damageSource, float damage) {
        if (damageSource.func_76364_f() instanceof EntitySnowball) {
            damage = (float)Math.max((double)this.func_110138_aP() / (this.BLAZE_SNOWBALL_HITS - 1.0) - 1.0, (double)damage);
            this.sendChatSnark((EntityLiving)this, damageSource, this.field_70146_Z, chatSuper);
        } else if (Properties.EntityFrostShardClass.isInstance(damageSource.func_76364_f()) || Properties.EntityIceArrow.isInstance(damageSource.func_76364_f()) || "frost".equals(damageSource.func_76355_l())) {
            damage = (float)Math.max((double)this.func_110138_aP() / (this.BLAZE_SNOWBALL_HITS - 1.0) + 2.0, (double)damage);
            this.sendChatSnark((EntityLiving)this, damageSource, this.field_70146_Z, chatSuper);
        }
        Entity attacker = damageSource.func_76346_g();
        if (attacker instanceof EntityLivingBase) {
            ItemStack heldItem = ((EntityLivingBase)attacker).func_70694_bm();
            if (heldItem != null) {
                if (Properties.ItemTFIceSword.isInstance(heldItem.func_77973_b())) {
                    damage = Math.max(this.func_110138_aP() / 2.0f + 4.0f, damage);
                    this.sendChatSnark((EntityLiving)this, damageSource, this.field_70146_Z, chatSuper);
                }
            } else {
                this.sendChatSnark((EntityLiving)this, damageSource, this.field_70146_Z, chatSnark);
            }
        }
        if (damageSource.func_76347_k()) {
            this.sendChatSnark((EntityLiving)this, damageSource, this.field_70146_Z, chatSnark);
            damage = 0.0f;
        }
        return super.func_70097_a(damageSource, damage);
    }

    protected void func_70628_a(boolean hit, int looting) {
        super.func_70628_a(hit, looting);
    }

    public int func_70658_aO() {
        return Math.min(20, super.func_70658_aO() + this.getSpecialData().armor);
    }

    public void func_70015_d(int time) {
        if (!this.getSpecialData().isImmuneToBurning) {
            super.func_70015_d(time);
        }
    }

    public boolean func_110164_bC() {
        return !this.func_110167_bD() && this.getSpecialData().allowLeashing;
    }

    public void func_70110_aj() {
        if (!this.getSpecialData().isImmuneToWebs) {
            super.func_70110_aj();
        }
    }

    public boolean func_145773_az() {
        return this.getSpecialData().ignorePressurePlates;
    }

    public boolean func_70648_aU() {
        return this.getSpecialData().canBreatheInWater;
    }

    public boolean func_96092_aw() {
        return !this.getSpecialData().ignoreWaterPush;
    }

    public boolean func_70687_e(PotionEffect effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    static {
        ISpecialMob.loadChat("entity.SpecialMobs.SpecialBlaze", chatSnark, chatSuper);
    }
}

