/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.Mixins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lumien.randomthings.Configuration.ConfigBlocks;
import lumien.randomthings.Configuration.VanillaChanges;
import lumien.randomthings.Mixins.Mixin;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class RTMixinPlugin
implements IMixinConfigPlugin {
    private static final Logger LOG = LogManager.getLogger((String)"RandomThings Mixins");

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        for (Mixin mixin : Mixin.values()) {
            if (!mixin.shouldLoad()) continue;
            mixins.add(mixin.mixinClass);
            LOG.debug("Loading mixin: " + mixin.mixinClass);
        }
        return mixins;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    static {
        File file = new File("config/RandomThings.cfg");
        Configuration config = new Configuration(file);
        config.load();
        VanillaChanges.FASTER_LEAVEDECAY = config.get("VanillaChanges", "FasterLeaveDecay", true, "Leaves will decay much faster when no longer connected to a log").getBoolean(true);
        VanillaChanges.LOCKED_GAMMA = config.get("VanillaChanges", "LockedGamma", false, "Locks the Gamma to 0").setRequiresMcRestart(true).getBoolean(false);
        ConfigBlocks.wirelessLever = config.get("Blocks", "WirelessLever", true).getBoolean(true);
        LOG.info("Loaded early config");
        if (config.hasChanged()) {
            config.save();
        }
    }
}

