/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackSpeed;
import mods.railcraft.common.carts.EntityLocomotive;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackSpeedTransition
extends TrackSpeed
implements ITrackPowered,
ITrackReversable {
    private boolean powered = false;
    private boolean reversed = false;
    private static final double BOOST_AMOUNT = 0.04;
    private static final double SLOW_FACTOR = 0.65;
    private static final double BOOST_THRESHOLD = 0.01;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.SPEED_TRANSITION;
    }

    @Override
    public IIcon getIcon() {
        if (!this.isPowered()) {
            if (this.isReversed()) {
                return this.getIcon(3);
            }
            return this.getIcon(1);
        }
        if (this.isReversed()) {
            return this.getIcon(2);
        }
        return this.getIcon(0);
    }

    @Override
    public int getPowerPropagation() {
        return 16;
    }

    @Override
    public boolean isFlexibleRail() {
        return false;
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        TrackSpeedTransition.testCartSpeedForBooster(this, cart);
        boolean highSpeed = cart.getEntityData().func_74767_n("HighSpeed");
        if (this.powered) {
            double speed = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
            if (speed > 0.01) {
                int meta = this.tileEntity.func_145832_p();
                if (meta == 0 || meta == 4 || meta == 5) {
                    if (this.reversed ^ cart.field_70179_y < 0.0) {
                        this.boostCartSpeed(cart, speed);
                    } else {
                        this.slowOrNormalCartSpeed(cart, highSpeed);
                    }
                } else if (meta == 1 || meta == 2 || meta == 3) {
                    if (!this.reversed ^ cart.field_70159_w < 0.0) {
                        this.boostCartSpeed(cart, speed);
                    } else {
                        this.slowOrNormalCartSpeed(cart, highSpeed);
                    }
                }
            }
        } else if (highSpeed) {
            int meta = this.tileEntity.func_145832_p();
            if (meta == 0 || meta == 4 || meta == 5) {
                if (this.reversed ^ cart.field_70179_y > 0.0) {
                    this.slowCartSpeed(cart);
                }
            } else if ((meta == 1 || meta == 2 || meta == 3) && !this.reversed ^ cart.field_70159_w > 0.0) {
                this.slowCartSpeed(cart);
            }
            cart.field_70181_x = 0.0;
        } else {
            this.normalCartSpeed(cart);
        }
    }

    private void boostCartSpeed(EntityMinecart cart, double currentSpeed) {
        cart.field_70159_w += cart.field_70159_w / currentSpeed * 0.04;
        cart.field_70179_y += cart.field_70179_y / currentSpeed * 0.04;
    }

    private void slowCartSpeed(EntityMinecart cart) {
        if (cart instanceof EntityLocomotive) {
            ((EntityLocomotive)cart).forceIdle(20);
        }
        cart.field_70159_w *= 0.65;
        cart.field_70179_y *= 0.65;
    }

    private void slowOrNormalCartSpeed(EntityMinecart cart, boolean highSpeed) {
        if (highSpeed) {
            this.slowCartSpeed(cart);
        } else {
            this.normalCartSpeed(cart);
        }
    }

    private void normalCartSpeed(EntityMinecart cart) {
        if (Math.abs(cart.field_70159_w) > 0.01) {
            cart.field_70159_w = Math.copySign((double)0.3f, cart.field_70159_w);
        }
        if (Math.abs(cart.field_70179_y) > 0.01) {
            cart.field_70179_y = Math.copySign((double)0.3f, cart.field_70179_y);
        }
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("powered", this.powered);
        nbttagcompound.func_74757_a("reversed", this.reversed);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.powered = nbttagcompound.func_74767_n("powered");
        this.reversed = nbttagcompound.func_74767_n("reversed");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean r) {
        this.reversed = r;
    }
}

