/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.tracks.ITrackPowered;
import mods.railcraft.api.tracks.ITrackReversable;
import mods.railcraft.common.blocks.tracks.EnumTrack;
import mods.railcraft.common.blocks.tracks.TrackBaseRailcraft;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class TrackOneWay
extends TrackBaseRailcraft
implements ITrackPowered,
ITrackReversable {
    private boolean reversed = false;
    private boolean powered = false;
    private static final double LOSS_FACTOR = 0.49;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.ONEWAY;
    }

    @Override
    public IIcon getIcon() {
        if (!this.isPowered()) {
            if (this.isReversed()) {
                return this.getIcon(3);
            }
            return this.getIcon(1);
        }
        if (this.isReversed()) {
            return this.getIcon(2);
        }
        return this.getIcon(0);
    }

    @Override
    public void onMinecartPass(EntityMinecart cart) {
        int meta = this.tileEntity.func_145832_p();
        if (this.isPowered()) {
            if (meta == 1 || meta == 2 || meta == 3) {
                if (this.isReversed() && cart.field_70159_w > 0.0 || !this.isReversed() && cart.field_70159_w < 0.0) {
                    double distX = cart.field_70165_t - ((double)this.tileEntity.field_145851_c + 0.5);
                    if (!this.isReversed() && distX < -0.01 || this.isReversed() && distX > 0.01) {
                        cart.func_70107_b((double)this.tileEntity.field_145851_c + 0.5, cart.field_70163_u, cart.field_70161_v);
                    }
                    cart.field_70159_w = !this.isReversed() ? Math.abs(cart.field_70159_w) * 0.49 : -Math.abs(cart.field_70159_w) * 0.49;
                }
            } else if ((meta == 0 || meta == 4 || meta == 5) && (this.isReversed() && cart.field_70179_y < 0.0 || !this.isReversed() && cart.field_70179_y > 0.0)) {
                double distZ = cart.field_70161_v - ((double)this.tileEntity.field_145849_e + 0.5);
                if (this.isReversed() && distZ < -0.01 || !this.isReversed() && distZ > 0.01) {
                    cart.func_70107_b(cart.field_70165_t, cart.field_70163_u, (double)this.tileEntity.field_145849_e + 0.5);
                }
                cart.field_70179_y = this.isReversed() ? Math.abs(cart.field_70179_y) * 0.49 : -Math.abs(cart.field_70179_y) * 0.49;
            }
        }
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public boolean isPowered() {
        return this.powered;
    }

    @Override
    public void setPowered(boolean powered) {
        this.powered = powered;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74757_a("direction", this.reversed);
        nbttagcompound.func_74757_a("powered", this.powered);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.func_74767_n("direction");
        this.powered = nbttagcompound.func_74767_n("powered");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.powered);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.powered = data.readBoolean();
        this.reversed = data.readBoolean();
        this.markBlockNeedsUpdate();
    }
}

