/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.stairs;

import cpw.mods.fml.common.registry.GameRegistry;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.BlockFactory;
import mods.railcraft.common.blocks.aesthetics.EnumBlockMaterial;
import mods.railcraft.common.blocks.aesthetics.brick.BrickVariant;
import mods.railcraft.common.blocks.aesthetics.brick.EnumBrick;
import mods.railcraft.common.blocks.aesthetics.stairs.BlockRailcraftStairs;
import mods.railcraft.common.blocks.aesthetics.stairs.ItemStair;
import mods.railcraft.common.blocks.aesthetics.stairs.TileStair;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.modules.ModuleManager;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.RailcraftRegistry;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;

public class BlockFactoryStairs
extends BlockFactory {
    public BlockFactoryStairs() {
        super("stair");
    }

    @Override
    protected void doBlockInit() {
        int renderId = Railcraft.getProxy().getRenderId();
        BlockRailcraftStairs.block = new BlockRailcraftStairs(renderId);
        BlockRailcraftStairs.block.func_149663_c("railcraft.stair");
        RailcraftRegistry.register((Block)BlockRailcraftStairs.block, ItemStair.class);
        GameRegistry.registerTileEntity(TileStair.class, (String)"RCStairTile");
        block3: for (EnumBlockMaterial mat : EnumBlockMaterial.VALUES) {
            RailcraftRegistry.register(BlockRailcraftStairs.getItem(mat));
            switch (mat) {
                case SNOW: 
                case ICE: {
                    continue block3;
                }
                default: {
                    ForestryPlugin.addBackpackItem("builder", BlockRailcraftStairs.getItem(mat));
                }
            }
        }
    }

    @Override
    protected void doRecipeInit(ModuleManager.Module module) {
        EnumBlockMaterial.initialize();
        for (EnumBlockMaterial mat : EnumBlockMaterial.VALUES) {
            if (!BlockRailcraftStairs.isEnabled(mat) || mat.getSourceItem() == null) continue;
            CraftingPlugin.addShapedRecipe(BlockRailcraftStairs.getItem(mat, 4), "S  ", "SS ", "SSS", Character.valueOf('S'), mat.getSourceItem());
            if (Game.isGTNH) continue;
            IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(BlockRailcraftStairs.getItem(mat), true, false);
            recipe.addOutput(mat.getSourceItem(), 1.0f);
        }
        if (!Game.isGTNH) {
            this.addRockCrusherRecipe(EnumBrick.ABYSSAL, EnumBlockMaterial.ABYSSAL_BLOCK, EnumBlockMaterial.ABYSSAL_BRICK, EnumBlockMaterial.ABYSSAL_COBBLE, EnumBlockMaterial.ABYSSAL_FITTED);
            this.addRockCrusherRecipe(EnumBrick.BLEACHEDBONE, EnumBlockMaterial.BLEACHEDBONE_BLOCK, EnumBlockMaterial.BLEACHEDBONE_BRICK, EnumBlockMaterial.BLEACHEDBONE_COBBLE, EnumBlockMaterial.BLEACHEDBONE_FITTED);
            this.addRockCrusherRecipe(EnumBrick.BLOODSTAINED, EnumBlockMaterial.BLOODSTAINED_BLOCK, EnumBlockMaterial.BLOODSTAINED_BRICK, EnumBlockMaterial.BLOODSTAINED_COBBLE, EnumBlockMaterial.BLOODSTAINED_FITTED);
            this.addRockCrusherRecipe(EnumBrick.FROSTBOUND, EnumBlockMaterial.FROSTBOUND_BLOCK, EnumBlockMaterial.FROSTBOUND_BRICK, EnumBlockMaterial.FROSTBOUND_COBBLE, EnumBlockMaterial.FROSTBOUND_FITTED);
            this.addRockCrusherRecipe(EnumBrick.INFERNAL, EnumBlockMaterial.INFERNAL_BLOCK, EnumBlockMaterial.INFERNAL_BRICK, EnumBlockMaterial.INFERNAL_COBBLE, EnumBlockMaterial.INFERNAL_FITTED);
            this.addRockCrusherRecipe(EnumBrick.NETHER, EnumBlockMaterial.NETHER_BLOCK, EnumBlockMaterial.NETHER_COBBLE, EnumBlockMaterial.NETHER_FITTED);
            this.addRockCrusherRecipe(EnumBrick.QUARRIED, EnumBlockMaterial.QUARRIED_BLOCK, EnumBlockMaterial.QUARRIED_BRICK, EnumBlockMaterial.QUARRIED_COBBLE, EnumBlockMaterial.QUARRIED_FITTED);
            this.addRockCrusherRecipe(EnumBrick.SANDY, EnumBlockMaterial.SANDY_BLOCK, EnumBlockMaterial.SANDY_BRICK, EnumBlockMaterial.SANDY_COBBLE, EnumBlockMaterial.SANDY_FITTED);
        }
    }

    private void addRockCrusherRecipe(EnumBrick brick, EnumBlockMaterial ... types) {
        if (brick.getBlock() == null) {
            return;
        }
        ItemStack output = brick.get(BrickVariant.COBBLE, 1);
        for (EnumBlockMaterial mat : types) {
            if (!BlockRailcraftStairs.isEnabled(mat)) continue;
            IRockCrusherRecipe recipe = RailcraftCraftingManager.rockCrusher.createNewRecipe(BlockRailcraftStairs.getItem(mat), true, false);
            recipe.addOutput(output, 1.0f);
        }
    }
}

