/*
 * Decompiled with CFR 0.152.
 */
package rwg.biomes.realistic.savanna;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenBlockBlob;
import net.minecraft.world.gen.feature.WorldGenDeadBush;
import net.minecraft.world.gen.feature.WorldGenReed;
import net.minecraft.world.gen.feature.WorldGenShrub;
import rwg.api.RWGBiomes;
import rwg.biomes.realistic.RealisticBiomeBase;
import rwg.deco.DecoCacti;
import rwg.deco.DecoFlowers;
import rwg.deco.DecoGrass;
import rwg.deco.trees.DecoSavannah;
import rwg.surface.SurfaceBase;
import rwg.surface.SurfaceCanyon;
import rwg.terrain.TerrainBase;
import rwg.terrain.TerrainCanyon;
import rwg.util.CellNoise;
import rwg.util.NoiseGenerator;

public class RealisticBiomeCanyonForest
extends RealisticBiomeBase {
    private TerrainBase terrain = new TerrainCanyon(true, 35.0f, 160.0f, 60.0f, 40.0f, 69.0f);
    private SurfaceBase surface = new SurfaceCanyon((Block)Blocks.field_150354_m, (Block)Blocks.field_150354_m, 1, 47);

    public RealisticBiomeCanyonForest() {
        super(0, RWGBiomes.baseHotForest, RealisticBiomeBase.coastDunes, RWGBiomes.baseRiverOasis);
    }

    @Override
    public void rDecorate(World world, Random rand, int chunkX, int chunkY, NoiseGenerator perlin, CellNoise cell, float strength, float river) {
        int j24;
        int k22;
        int l19;
        int l14;
        int j20;
        int j17;
        int j15;
        int f23;
        int b33;
        int z52;
        int k10;
        int j6;
        int l = 0;
        while ((float)l < 1.0f * strength) {
            int j1;
            int i1 = chunkX + rand.nextInt(16) + 8;
            int k1 = world.func_72976_f(i1, j1 = chunkY + rand.nextInt(16) + 8);
            if (k1 < 70) {
                new WorldGenBlockBlob(Blocks.field_150341_Y, 0).func_76484_a(world, rand, i1, k1, j1);
            }
            ++l;
        }
        if (river > 0.7f) {
            WorldGenShrub worldgenerator;
            for (int b1 = 0; b1 < 10; ++b1) {
                j6 = chunkX + rand.nextInt(16) + 8;
                k10 = chunkY + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10);
                worldgenerator = new WorldGenShrub(0, 0);
                worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                worldgenerator.func_76484_a(world, rand, j6, z52, k10);
            }
            if (rand.nextInt(3) == 0) {
                int i18 = chunkX + rand.nextInt(16) + 8;
                int i23 = chunkY + rand.nextInt(16) + 8;
                new WorldGenReed().func_76484_a(world, rand, i18, 60 + rand.nextInt(8), i23);
            }
            b33 = 0;
            while ((float)b33 < 7.0f * strength) {
                j6 = chunkX + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z52 < 80) {
                    worldgenerator = rand.nextInt(3) == 0 ? new WorldGenShrub(0, 0) : new DecoSavannah(2, false);
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                } else if (z52 < 111) {
                    worldgenerator = rand.nextInt(3) == 0 ? new WorldGenShrub(0, 0) : new DecoSavannah(1, false);
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
                ++b33;
            }
            for (f23 = 0; f23 < 3; ++f23) {
                j15 = chunkX + rand.nextInt(16) + 8;
                j17 = rand.nextInt(128);
                j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            l14 = 0;
            while ((float)l14 < 8.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = 60 + rand.nextInt(70);
                j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                } else {
                    new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                }
                ++l14;
            }
        } else {
            b33 = 0;
            while ((float)b33 < 6.0f * strength) {
                WorldGenShrub worldgenerator;
                j6 = chunkX + rand.nextInt(16) + 8;
                z52 = world.func_72976_f(j6, k10 = chunkY + rand.nextInt(16) + 8);
                if (z52 > 127) {
                    worldgenerator = new WorldGenShrub(0, 0);
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                } else if (z52 < 127) {
                    worldgenerator = rand.nextInt(3) != 0 ? new WorldGenShrub(0, 0) : new DecoSavannah(1, false);
                    worldgenerator.func_76487_a(1.0, 1.0, 1.0);
                    worldgenerator.func_76484_a(world, rand, j6, z52, k10);
                }
                ++b33;
            }
            for (int i15 = 0; i15 < 5; ++i15) {
                int i17 = chunkX + rand.nextInt(16) + 8;
                int i20 = 64 + rand.nextInt(100);
                int l22 = chunkY + rand.nextInt(16) + 8;
                new WorldGenDeadBush((Block)Blocks.field_150330_I).func_76484_a(world, rand, i17, i20, l22);
            }
            for (int k18 = 0; k18 < 25; ++k18) {
                int k21 = chunkX + rand.nextInt(16) + 8;
                int j23 = 64 + rand.nextInt(100);
                int k24 = chunkY + rand.nextInt(16) + 8;
                new DecoCacti(true).func_76484_a(world, rand, k21, j23, k24);
            }
            for (f23 = 0; f23 < 3; ++f23) {
                j15 = chunkX + rand.nextInt(16) + 8;
                j17 = rand.nextInt(128);
                j20 = chunkY + rand.nextInt(16) + 8;
                new DecoFlowers(new int[]{9, 9, 9, 9, 3, 3, 3, 3, 3, 2, 2, 2, 11, 11, 11}).func_76484_a(world, rand, j15, j17, j20);
            }
            l14 = 0;
            while ((float)l14 < 8.0f * strength) {
                l19 = chunkX + rand.nextInt(16) + 8;
                k22 = 60 + rand.nextInt(70);
                j24 = chunkY + rand.nextInt(16) + 8;
                if (rand.nextInt(3) == 0) {
                    new DecoGrass((Block)Blocks.field_150398_cm, 2).func_76484_a(world, rand, l19, k22, j24);
                } else {
                    new DecoGrass((Block)Blocks.field_150329_H, 1).func_76484_a(world, rand, l19, k22, j24);
                }
                ++l14;
            }
        }
    }

    @Override
    public float rNoise(NoiseGenerator perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        return this.terrain.generateNoise(perlin, cell, x, y, ocean, border, river);
    }

    @Override
    public void rReplace(Block[] blocks, byte[] metadata, int i, int j, int x, int y, int depth, World world, Random rand, NoiseGenerator perlin, CellNoise cell, float[] noise, float river, BiomeGenBase[] base) {
        this.surface.paintTerrain(blocks, metadata, i, j, x, y, depth, world, rand, perlin, cell, noise, river, base);
    }
}

