/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.gui.widgets.buttons;

import mcp.mobius.opis.gui.interfaces.CType;
import mcp.mobius.opis.gui.interfaces.IWidget;
import mcp.mobius.opis.gui.interfaces.WAlign;
import mcp.mobius.opis.gui.widgets.LayoutBase;
import mcp.mobius.opis.gui.widgets.WidgetBase;
import mcp.mobius.opis.gui.widgets.WidgetGeometry;
import mcp.mobius.opis.gui.widgets.buttons.ButtonBase;
import org.lwjgl.util.Point;

public class ButtonContainer
extends WidgetBase {
    private int nButtons = 0;
    private int columns;
    private int buttonSize;
    private double spacing;

    public ButtonContainer(IWidget parent, int columns, int buttonSize, double spacing) {
        super(parent);
        this.columns = columns;
        this.spacing = spacing;
        this.buttonSize = buttonSize;
    }

    public void addButton(ButtonBase button) {
        String buttonName = String.format("Button_%d", this.nButtons);
        String layoutName = String.format("Layout_%d", this.nButtons);
        String layoutLabelName = String.format("LayoutLabel_%d", this.nButtons);
        String labelName = String.format("Label_%d", this.nButtons);
        this.addWidget(layoutName, new LayoutBase(this));
        this.addWidget(layoutLabelName, new LayoutBase(this));
        int column = this.nButtons % this.columns;
        int row = this.nButtons / this.columns;
        double sizeColumn = 100.0 / (double)this.columns;
        this.getWidget(layoutName).setGeometry(new WidgetGeometry(sizeColumn * (double)column, this.spacing * (double)row, sizeColumn, this.spacing, CType.REL_X, CType.REL_X, WAlign.LEFT, WAlign.TOP));
        this.getWidget(layoutName).addWidget(buttonName, button);
        this.getWidget(layoutName).getWidget(buttonName).setGeometry(new WidgetGeometry(50.0, 50.0, this.buttonSize, 20.0, CType.RELXY, CType.ABSXY, WAlign.CENTER, WAlign.CENTER));
        ++this.nButtons;
    }

    @Override
    public void draw(Point pos) {
    }
}

